/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.init;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.PerspectiveBakedModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.ReplaceableBakedModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public final class InitSpecialItemRender {
    private static final List<Pair<ModelResourceLocation, ModelResourceLocation>> PERSPECTIVE_MODEL_LIST = Lists.newArrayList();
    private static final List<Triple<ModelResourceLocation, ModelResourceLocation, Supplier<Boolean>>> REPLACEABLE_MODEL_LIST = Lists.newArrayList();
    private static final ResourceLocation LIFE_POINT = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"life_point");
    private static final ResourceLocation POINT_ITEM = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"point_item");

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            InitSpecialItemRender.addInHandModel((Item)InitItems.HAKUREI_GOHEI.get());
            InitSpecialItemRender.addInHandModel((Item)InitItems.SANAE_GOHEI.get());
            InitSpecialItemRender.addInHandModel((Item)InitItems.EXTINGUISHER.get());
            InitSpecialItemRender.addInHandModel((Item)InitItems.CAMERA.get());
            InitSpecialItemRender.addInHandModel((Item)InitItems.MAID_BEACON.get());
            InitSpecialItemRender.addReplaceableModel(Items.TOTEM_OF_UNDYING, LIFE_POINT, () -> (Boolean)VanillaConfig.REPLACE_TOTEM_TEXTURE.get());
            InitSpecialItemRender.addReplaceableModel(Items.EXPERIENCE_BOTTLE, POINT_ITEM, () -> (Boolean)VanillaConfig.REPLACE_XP_BOTTLE_TEXTURE.get());
        }
    }

    @SubscribeEvent
    public static void onBakedModel(ModelEvent.BakingCompleted event) {
        Object model;
        Map registry = event.getModelBakery().getBakedTopLevelModels();
        for (Pair<ModelResourceLocation, ModelResourceLocation> pair : PERSPECTIVE_MODEL_LIST) {
            model = new PerspectiveBakedModel((BakedModel)registry.get(pair.getLeft()), (BakedModel)registry.get(pair.getRight()));
            registry.put((ModelResourceLocation)pair.getLeft(), model);
        }
        for (Triple triple : REPLACEABLE_MODEL_LIST) {
            model = new ReplaceableBakedModel((BakedModel)registry.get(triple.getLeft()), (BakedModel)registry.get(triple.getMiddle()), (Supplier)triple.getRight());
            registry.put((ModelResourceLocation)triple.getLeft(), model);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        PERSPECTIVE_MODEL_LIST.forEach(pair -> event.register((ModelResourceLocation)pair.getRight()));
        REPLACEABLE_MODEL_LIST.forEach(triple -> event.register((ModelResourceLocation)triple.getMiddle()));
    }

    public static void addInHandModel(Item item) {
        ResourceLocation res = BuiltInRegistries.ITEM.getKey((Object)item);
        if (res != null) {
            ModelResourceLocation rawName = ModelResourceLocation.inventory((ResourceLocation)res);
            ModelResourceLocation inHandName = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)res.getNamespace(), (String)("item/" + res.getPath() + "_in_hand")));
            PERSPECTIVE_MODEL_LIST.add((Pair<ModelResourceLocation, ModelResourceLocation>)Pair.of((Object)rawName, (Object)inHandName));
        }
    }

    public static void addReplaceableModel(Item item, ResourceLocation replacedModel, Supplier<Boolean> isReplace) {
        ResourceLocation res = BuiltInRegistries.ITEM.getKey((Object)item);
        if (res != null) {
            ModelResourceLocation rawModelResourceLocation = ModelResourceLocation.inventory((ResourceLocation)res);
            ModelResourceLocation replacedModelResourceLocation = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)replacedModel.getNamespace(), (String)("item/" + replacedModel.getPath())));
            REPLACEABLE_MODEL_LIST.add((Triple<ModelResourceLocation, ModelResourceLocation, Supplier<Boolean>>)Triple.of((Object)rawModelResourceLocation, (Object)replacedModelResourceLocation, isReplace));
        }
    }
}

