/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.input;

import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.player2.STTClient;
import com.github.tartaricacid.touhoulittlemaid.client.event.PressAIChatKeyEvent;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendUserChatPackage;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class STTChatKey {
    public static final KeyMapping STT_CHAT_KEY = new KeyMapping("key.touhou_little_maid.stt_chat.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 88, "key.category.touhou_little_maid");
    private static final Timer TIMER = new Timer();

    @SubscribeEvent
    public static void onSttChatPress(InputEvent.Key event) {
        if (STT_CHAT_KEY.matches(event.getKey(), event.getScanCode())) {
            if (!((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null || player.isSpectator()) {
                return;
            }
            if (!STTChatKey.isInGame()) {
                return;
            }
            if (event.getAction() == 1) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.EXPERIENCE_ORB_PICKUP, (float)2.0f));
                STTChatKey.sttStart();
            }
            if (event.getAction() == 0) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.EXPERIENCE_ORB_PICKUP, (float)0.5f));
                Level level = player.level;
                AABB aabb = player.getBoundingBox().inflate(12.0);
                final List maids = level.getEntitiesOfClass(EntityMaid.class, aabb, maid -> maid.isOwnedBy((LivingEntity)player) && maid.isAlive() && PressAIChatKeyEvent.CAN_CHAT_MAID_IDS.contains(maid.getModelId()));
                maids.sort(Comparator.comparingDouble(maid -> maid.distanceToSqr((Entity)player)));
                if (maids.isEmpty()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.stt.content.no_maid_found"));
                } else {
                    TIMER.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            STTChatKey.sttStop((EntityMaid)maids.get(0));
                        }
                    }, 1500L);
                }
            }
        }
    }

    private static boolean isInGame() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getOverlay() != null) {
            return false;
        }
        if (mc.screen != null) {
            return false;
        }
        if (!mc.mouseHandler.isMouseGrabbed()) {
            return false;
        }
        return mc.isWindowActive();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sttStart() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
            String url = (String)AIConfig.STT_URL.get();
            if (StringUtils.isBlank((CharSequence)url)) {
                player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.chat.stt.empty"));
            } else {
                STTClient sttClient = Service.getSttClient(url);
                sttClient.start(message -> {}, throwable -> {
                    String cause = throwable.getLocalizedMessage();
                    player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.stt.connect.fail").append(cause).withStyle(ChatFormatting.RED));
                });
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sttStop(EntityMaid maid) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
            return;
        }
        String url = (String)AIConfig.STT_URL.get();
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        STTClient sttClient = Service.getSttClient(url);
        sttClient.stop(message -> {
            String chatText = message.getText();
            if (StringUtils.isNotBlank((CharSequence)chatText)) {
                LanguageManager languageManager = Minecraft.getInstance().getLanguageManager();
                LanguageInfo info = languageManager.getLanguage(languageManager.getSelected());
                String language = info != null ? info.toComponent().getString() : "English (US)";
                PacketDistributor.sendToServer((CustomPacketPayload)new SendUserChatPackage(maid.getId(), chatText, language), (CustomPacketPayload[])new CustomPacketPayload[0]);
                String name = player.getScoreboardName();
                String format = String.format("<%s> %s", name, chatText);
                player.sendSystemMessage((Component)Component.literal((String)format).withStyle(ChatFormatting.GRAY));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.stt.content.empty").withStyle(ChatFormatting.GRAY));
            }
        }, throwable -> {
            String cause = throwable.getLocalizedMessage();
            player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.stt.connect.fail").append(cause).withStyle(ChatFormatting.RED));
        });
    }
}

