/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.touhoulittlemaid.client.model.AbstractModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBox;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class EntityBoxModel
extends AbstractModel<EntityBox> {
    public static ModelLayerLocation LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"main"), "box");
    private final ModelPart bottom;
    private final ModelPart x1;
    private final ModelPart x2;
    private final ModelPart z1;
    private final ModelPart z2;
    private final ModelPart top;

    public EntityBoxModel(ModelPart root) {
        this.bottom = root.getChild("bottom");
        this.x1 = root.getChild("x1");
        this.x2 = root.getChild("x2");
        this.z1 = root.getChild("z1");
        this.z2 = root.getChild("z2");
        this.top = root.getChild("top");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bottom = partdefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 0).addBox(-15.0f, -1.0f, -15.0f, 30.0f, 1.0f, 30.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition x1 = partdefinition.addOrReplaceChild("x1", CubeListBuilder.create().texOffs(64, 31).addBox(-14.0f, -30.5f, -0.5f, 28.0f, 30.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.5f, (float)-14.5f));
        PartDefinition x2 = partdefinition.addOrReplaceChild("x2", CubeListBuilder.create().texOffs(64, 31).addBox(-14.0f, -30.5f, -0.5f, 28.0f, 30.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.5f, (float)14.5f));
        PartDefinition z1 = partdefinition.addOrReplaceChild("z1", CubeListBuilder.create().texOffs(0, 31).addBox(-0.5f, -30.5f, -15.0f, 1.0f, 30.0f, 30.0f, new CubeDeformation(0.0f)), PartPose.offset((float)14.5f, (float)23.5f, (float)0.0f));
        PartDefinition z2 = partdefinition.addOrReplaceChild("z2", CubeListBuilder.create().texOffs(0, 31).addBox(-0.5f, -30.5f, -15.0f, 1.0f, 30.0f, 30.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-14.5f, (float)23.5f, (float)0.0f));
        PartDefinition top = partdefinition.addOrReplaceChild("top", CubeListBuilder.create().texOffs(0, 0).addBox(-15.0f, -32.0f, -15.0f, 30.0f, 1.0f, 30.0f, new CubeDeformation(0.0f)).texOffs(64, 64).addBox(-16.0f, -32.0f, -16.0f, 32.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(64, 64).addBox(-16.0f, -32.0f, 15.0f, 32.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(32, 61).addBox(-16.0f, -32.0f, -15.0f, 1.0f, 6.0f, 30.0f, new CubeDeformation(0.0f)).texOffs(32, 61).addBox(15.0f, -32.0f, -15.0f, 1.0f, 6.0f, 30.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(EntityBox entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int stage = entityIn.getOpenStage();
        if (stage == 64) {
            this.top.visible = true;
            this.x1.xRot = 0.0f;
            this.x2.xRot = 0.0f;
            this.z1.zRot = 0.0f;
            this.z2.zRot = 0.0f;
        } else if (stage > 60) {
            this.top.visible = false;
            this.x1.xRot = 0.0f;
            this.x2.xRot = 0.0f;
            this.z1.zRot = 0.0f;
            this.z2.zRot = 0.0f;
        } else {
            this.top.visible = false;
            this.x1.xRot = 0.023998277f * (float)(60 - stage);
            this.x2.xRot = -0.023998277f * (float)(60 - stage);
            this.z1.zRot = 0.023998277f * (float)(60 - stage);
            this.z2.zRot = -0.023998277f * (float)(60 - stage);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.bottom.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.x1.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.x2.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.z1.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.z2.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.top.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

