/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class EntityFairyModel
extends EntityModel<EntityFairy> {
    public static ModelLayerLocation LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"main"), "fairy");
    private final ModelPart head;
    private final ModelPart armRight;
    private final ModelPart armLeft;
    private final ModelPart body;
    private final ModelPart legLeft;
    private final ModelPart legRight;
    private final ModelPart wingLeft;
    private final ModelPart wingRight;
    private final ModelPart blink;

    public EntityFairyModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.head = root.getChild("head");
        this.armRight = root.getChild("armRight");
        this.armLeft = root.getChild("armLeft");
        this.body = root.getChild("body");
        this.legLeft = root.getChild("legLeft");
        this.legRight = root.getChild("legRight");
        this.wingLeft = root.getChild("wingLeft");
        this.wingRight = root.getChild("wingRight");
        this.blink = this.head.getChild("blink");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(62, 17).addBox(-6.0f, -10.75f, -1.0f, 12.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(30, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(22, 25).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition blink = head.addOrReplaceChild("blink", CubeListBuilder.create().texOffs(20, 0).addBox(-4.0f, -22.0f, -4.001f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition bone40 = head.addOrReplaceChild("bone40", CubeListBuilder.create().texOffs(0, 33).addBox(-4.0f, 4.1137f, -0.7853f, 8.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.2f, (float)3.8f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition bone5 = head.addOrReplaceChild("bone5", CubeListBuilder.create().texOffs(25, 45).addBox(-1.5f, 4.1137f, -0.7853f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 11).addBox(-1.25f, 4.1137f, -1.7853f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)4.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition bone6 = head.addOrReplaceChild("bone6", CubeListBuilder.create().texOffs(0, 44).addBox(-0.1946f, 3.1892f, -1.75f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(6, 11).addBox(-1.9446f, 3.6892f, -0.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-11.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition bone7 = head.addOrReplaceChild("bone7", CubeListBuilder.create().texOffs(13, 42).addBox(-2.8054f, 3.1892f, -1.75f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-11.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition bone8 = head.addOrReplaceChild("bone8", CubeListBuilder.create().texOffs(0, 11).addBox(-0.0554f, 3.6892f, -0.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-11.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition og_hair = head.addOrReplaceChild("og_hair", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-0.3f, (float)3.8f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition hair9 = og_hair.addOrReplaceChild("hair9", CubeListBuilder.create().texOffs(62, 23).addBox(-0.2f, 0.25f, 0.25f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition hair10 = og_hair.addOrReplaceChild("hair10", CubeListBuilder.create().texOffs(64, 23).addBox(-0.75f, 0.05f, 0.25f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2007f));
        PartDefinition hair11 = og_hair.addOrReplaceChild("hair11", CubeListBuilder.create().texOffs(66, 23).addBox(-0.75f, -0.25f, 0.25f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2356f));
        PartDefinition hair12 = og_hair.addOrReplaceChild("hair12", CubeListBuilder.create().texOffs(68, 23).mirror().addBox(-0.8f, 0.25f, 0.25f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition hair13 = og_hair.addOrReplaceChild("hair13", CubeListBuilder.create().texOffs(70, 23).mirror().addBox(-0.25f, 0.05f, 0.25f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1571f));
        PartDefinition hair14 = og_hair.addOrReplaceChild("hair14", CubeListBuilder.create().texOffs(72, 23).mirror().addBox(-0.25f, -0.25f, 0.25f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2356f));
        PartDefinition hair15 = og_hair.addOrReplaceChild("hair15", CubeListBuilder.create().texOffs(74, 23).addBox(-0.75f, 0.05f, 0.25f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1571f));
        PartDefinition hair16 = og_hair.addOrReplaceChild("hair16", CubeListBuilder.create().texOffs(76, 23).mirror().addBox(-0.25f, 0.05f, 0.25f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2007f));
        PartDefinition hairbun = head.addOrReplaceChild("hairbun", CubeListBuilder.create().texOffs(85, 0).addBox(-3.0f, -1.75f, 0.25f, 6.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(18, 11).addBox(-1.0f, 0.25f, -0.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.7f, (float)4.5f));
        PartDefinition ahoge = head.addOrReplaceChild("ahoge", CubeListBuilder.create().texOffs(62, 34).addBox(-1.0f, -4.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(62, 32).addBox(-0.5f, -4.5f, 0.0f, 6.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(66, 34).addBox(5.5f, -4.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(63, 37).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-8.0f, (float)-2.5f));
        PartDefinition tamed_bowtie = head.addOrReplaceChild("tamed_bowtie", CubeListBuilder.create().texOffs(102, 51).addBox(-2.0f, -1.5f, -1.5f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)4.5f));
        PartDefinition headdressRightTop_r1 = tamed_bowtie.addOrReplaceChild("headdressRightTop_r1", CubeListBuilder.create().texOffs(100, 58).addBox(0.0f, -2.5f, -0.5f, 6.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)0.0f, (float)-0.0456f, (float)-0.1685f, (float)-0.607f));
        PartDefinition headdressLeftBottom_r1 = tamed_bowtie.addOrReplaceChild("headdressLeftBottom_r1", CubeListBuilder.create().texOffs(116, 53).addBox(0.0f, -2.0f, -0.5f, 5.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.9599f));
        PartDefinition headdressRightBottom_r1 = tamed_bowtie.addOrReplaceChild("headdressRightBottom_r1", CubeListBuilder.create().texOffs(116, 48).addBox(-5.0f, -2.0f, -0.5f, 5.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)-0.9599f));
        PartDefinition headdressLeftTop_r1 = tamed_bowtie.addOrReplaceChild("headdressLeftTop_r1", CubeListBuilder.create().texOffs(114, 58).addBox(-6.0f, -2.5f, -0.5f, 6.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)0.0f, (float)-0.0456f, (float)0.1685f, (float)0.607f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.5f, -2.0f, 6.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(62, 0).addBox(-3.5f, -4.5f, -2.0f, 7.0f, 5.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)13.5f, (float)0.0f));
        PartDefinition sittingRotationSkirt = body.addOrReplaceChild("sittingRotationSkirt", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition skirt = sittingRotationSkirt.addOrReplaceChild("skirt", CubeListBuilder.create().texOffs(30, 16).addBox(-2.5f, -7.0f, -1.5f, 7.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)8.0f, (float)-1.0f));
        PartDefinition bone = skirt.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-5.0f, (float)1.0f));
        PartDefinition bone4 = bone.addOrReplaceChild("bone4", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-0.5f));
        PartDefinition bone49 = bone4.addOrReplaceChild("bone49", CubeListBuilder.create().texOffs(54, 0).addBox(-2.0f, -1.5186f, -0.7446f, 4.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.9705f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bone50 = bone49.addOrReplaceChild("bone50", CubeListBuilder.create().texOffs(32, 56).addBox(-1.326f, -2.111f, -0.7206f, 3.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)0.3422f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1719f));
        PartDefinition bone51 = bone49.addOrReplaceChild("bone51", CubeListBuilder.create().texOffs(56, 24).addBox(-1.674f, -2.111f, -0.7436f, 3.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)0.3422f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1719f));
        PartDefinition bone52 = bone.addOrReplaceChild("bone52", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition skirtpart_left = bone52.addOrReplaceChild("skirtpart_left", CubeListBuilder.create().texOffs(54, 16).addBox(-2.0f, -1.7186f, -0.6946f, 4.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)4.4705f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bone54 = skirtpart_left.addOrReplaceChild("bone54", CubeListBuilder.create().texOffs(51, 56).addBox(-0.826f, -2.3188f, -0.6706f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.4422f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1719f));
        PartDefinition bone55 = skirtpart_left.addOrReplaceChild("bone55", CubeListBuilder.create().texOffs(42, 56).addBox(-1.674f, -2.3188f, -0.6936f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)0.3422f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1719f));
        PartDefinition skirtpart_right = bone52.addOrReplaceChild("skirtpart_right", CubeListBuilder.create().texOffs(0, 54).addBox(-2.0f, -1.6186f, -8.2214f, 4.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)4.3705f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bone2 = skirtpart_right.addOrReplaceChild("bone2", CubeListBuilder.create().texOffs(38, 56).addBox(-0.826f, -2.2188f, -8.2464f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.4422f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1719f));
        PartDefinition bone10 = skirtpart_right.addOrReplaceChild("bone10", CubeListBuilder.create().texOffs(47, 54).addBox(-1.674f, -2.2188f, -8.2464f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)0.3422f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1719f));
        PartDefinition skirt_front = bone.addOrReplaceChild("skirt_front", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.5f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        PartDefinition skirt1_front = skirt_front.addOrReplaceChild("skirt1_front", CubeListBuilder.create().texOffs(54, 33).addBox(-2.0f, -1.5436f, -0.7196f, 4.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.9705f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition skirt2_front = skirt1_front.addOrReplaceChild("skirt2_front", CubeListBuilder.create().texOffs(26, 55).addBox(-1.326f, -2.1188f, -0.6956f, 3.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)0.3422f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1719f));
        PartDefinition skirt3_front = skirt1_front.addOrReplaceChild("skirt3_front", CubeListBuilder.create().texOffs(16, 33).addBox(-1.624f, -2.1188f, -0.6956f, 3.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)0.3422f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1719f));
        PartDefinition lace2 = skirt.addOrReplaceChild("lace2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0f, (float)-18.5f, (float)1.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition apron = skirt.addOrReplaceChild("apron", CubeListBuilder.create().texOffs(62, 9).mirror().addBox(-3.5f, -0.683f, -0.5335f, 7.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)-6.4641f, (float)-1.1f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition chestbow = body.addOrReplaceChild("chestbow", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.5f, (float)5.0f));
        PartDefinition bone163 = chestbow.addOrReplaceChild("bone163", CubeListBuilder.create().texOffs(24, 26).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2822f, (float)-0.0079f, (float)-7.5966f, (float)-0.3054f, (float)-0.3054f, (float)-2.3126f));
        PartDefinition bone164 = chestbow.addOrReplaceChild("bone164", CubeListBuilder.create().texOffs(24, 24).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-7.51f));
        PartDefinition bone165 = bone164.addOrReplaceChild("bone165", CubeListBuilder.create().texOffs(24, 28).addBox(-2.0f, 3.1411f, -14.4648f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)15.51f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition bone9 = chestbow.addOrReplaceChild("bone9", CubeListBuilder.create().texOffs(24, 26).mirror().addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.2822f, (float)-0.0079f, (float)-7.5966f, (float)-0.3054f, (float)0.3054f, (float)2.3126f));
        PartDefinition chestbow2 = body.addOrReplaceChild("chestbow2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)10.5f, (float)0.0f));
        PartDefinition bone3 = chestbow2.addOrReplaceChild("bone3", CubeListBuilder.create().texOffs(76, 11).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2037f, (float)-10.7079f, (float)2.5984f, (float)0.2849f, (float)-0.274f, (float)-0.8249f));
        PartDefinition bone11 = chestbow2.addOrReplaceChild("bone11", CubeListBuilder.create().texOffs(76, 9).addBox(-1.25f, -1.25f, -16.01f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.25f, (float)-9.95f, (float)17.8f));
        PartDefinition bone12 = bone11.addOrReplaceChild("bone12", CubeListBuilder.create().texOffs(84, 9).addBox(-0.5f, -0.4589f, -0.4648f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.25f, (float)-0.75f, (float)-15.0f, (float)0.3873f, (float)0.0665f, (float)-0.1615f));
        PartDefinition bone14 = bone11.addOrReplaceChild("bone14", CubeListBuilder.create().texOffs(86, 9).addBox(-0.5f, -0.4589f, -0.4648f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.75f, (float)-0.75f, (float)-15.0f, (float)0.3873f, (float)-0.0665f, (float)0.1615f));
        PartDefinition bone13 = chestbow2.addOrReplaceChild("bone13", CubeListBuilder.create().texOffs(76, 11).mirror().addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.1855f, (float)-10.7079f, (float)2.6397f, (float)0.3311f, (float)0.2895f, (float)0.8777f));
        PartDefinition legLeft = partdefinition.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(46, 22).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(53, 42).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offset((float)1.5f, (float)16.0f, (float)0.0f));
        PartDefinition armLeft = partdefinition.addOrReplaceChild("armLeft", CubeListBuilder.create().texOffs(10, 52).addBox(-0.5f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(18, 53).addBox(-0.5f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.2f)).texOffs(72, 46).addBox(-1.0f, -0.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0986f, (float)9.3589f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition wingLeft = partdefinition.addOrReplaceChild("wingLeft", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0f, (float)11.0f, (float)4.0f, (float)0.0f, (float)1.2217f, (float)0.0f));
        PartDefinition wingLeftUp = wingLeft.addOrReplaceChild("wingLeftUp", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, 9.0f, -2.0f, 0.0f, 9.0f, 15.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)-7.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wingLeftDown = wingLeft.addOrReplaceChild("wingLeftDown", CubeListBuilder.create().texOffs(0, 12).mirror().addBox(-1.0f, 3.0f, -1.5f, 0.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)6.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition legRight = partdefinition.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(37, 45).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(52, 51).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-1.5f, (float)16.0f, (float)0.0f));
        PartDefinition armRight = partdefinition.addOrReplaceChild("armRight", CubeListBuilder.create().texOffs(47, 45).addBox(-1.5f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(55, 56).addBox(-1.5f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.2f)).texOffs(60, 46).mirror().addBox(-2.0f, -0.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0986f, (float)9.3589f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition wingRight = partdefinition.addOrReplaceChild("wingRight", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)11.0f, (float)4.0f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        PartDefinition wingRightUp = wingRight.addOrReplaceChild("wingRightUp", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 9.0f, -2.0f, 0.0f, 9.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)-7.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wingRightDown = wingRight.addOrReplaceChild("wingRightDown", CubeListBuilder.create().texOffs(0, 12).addBox(1.0f, 3.0f, -1.5f, 0.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)6.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(EntityFairy entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.armLeft.zRot = Mth.cos((float)(ageInTicks * 0.05f)) * 0.05f - 0.4f;
        this.armRight.zRot = -Mth.cos((float)(ageInTicks * 0.05f)) * 0.05f + 0.4f;
        if (entityIn.onGround()) {
            this.legLeft.xRot = Mth.cos((float)(limbSwing * 0.67f)) * 0.3f * limbSwingAmount;
            this.legRight.xRot = -Mth.cos((float)(limbSwing * 0.67f)) * 0.3f * limbSwingAmount;
            this.armLeft.xRot = -Mth.cos((float)(limbSwing * 0.67f)) * 0.7f * limbSwingAmount;
            this.armRight.xRot = Mth.cos((float)(limbSwing * 0.67f)) * 0.7f * limbSwingAmount;
            this.wingLeft.yRot = -Mth.cos((float)(ageInTicks * 0.3f)) * 0.2f + 1.0f;
            this.wingRight.yRot = Mth.cos((float)(ageInTicks * 0.3f)) * 0.2f - 1.0f;
        } else {
            this.legLeft.xRot = 0.0f;
            this.legRight.xRot = 0.0f;
            this.armLeft.xRot = -0.17453292f;
            this.armRight.xRot = -0.17453292f;
            this.head.xRot -= 0.13962634f;
            this.wingLeft.yRot = -Mth.cos((float)(ageInTicks * 0.5f)) * 0.4f + 1.2f;
            this.wingRight.yRot = Mth.cos((float)(ageInTicks * 0.5f)) * 0.4f - 1.2f;
        }
        float remainder = ageInTicks % 60.0f;
        this.blink.visible = 55.0f < remainder && remainder < 60.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.armRight.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.armLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.legLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.legRight.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.wingLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.wingRight.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

