/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class NewEntityFairyModel
extends EntityModel<EntityFairy> {
    public static ModelLayerLocation LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"main"), "new_fairy");
    private final ModelPart head;
    private final ModelPart blink;
    private final ModelPart armLeft;
    private final ModelPart body;
    private final ModelPart skirt;
    private final ModelPart apron2;
    private final ModelPart legLeft;
    private final ModelPart legRight;
    private final ModelPart wingLeft;
    private final ModelPart wingRight;
    private final ModelPart armRight;

    public NewEntityFairyModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.head = root.getChild("head");
        this.blink = this.head.getChild("blink");
        this.armLeft = root.getChild("armLeft");
        this.body = root.getChild("body");
        this.skirt = this.body.getChild("skirt");
        this.apron2 = this.skirt.getChild("apron2");
        this.legLeft = root.getChild("legLeft");
        this.legRight = root.getChild("legRight");
        this.wingLeft = root.getChild("wingLeft");
        this.wingRight = root.getChild("wingRight");
        this.armRight = root.getChild("armRight");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(76, 20).addBox(-9.0f, -12.75f, -1.0f, 18.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(76, 33).addBox(-9.0f, -12.75f, -0.9375f, 18.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(-4.0f, -7.75f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(83, 10).addBox(-3.0f, -7.95f, 4.75f, 6.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(80, 10).addBox(-1.0f, -5.95f, 3.9375f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition og_hair_r1 = head.addOrReplaceChild("og_hair_r1", CubeListBuilder.create().texOffs(70, 10).addBox(-0.1799f, -0.2112f, 0.0f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0812f, (float)4.161f, (float)0.2616f, (float)0.0113f, (float)-0.0421f));
        PartDefinition og_hair_r2 = head.addOrReplaceChild("og_hair_r2", CubeListBuilder.create().texOffs(66, 10).addBox(1.2039f, -0.0236f, 0.0f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0812f, (float)4.161f, (float)0.2568f, (float)0.0516f, (float)-0.194f));
        PartDefinition og_hair_r3 = head.addOrReplaceChild("og_hair_r3", CubeListBuilder.create().texOffs(64, 10).addBox(2.1776f, -0.0219f, 0.0f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0812f, (float)4.161f, (float)0.2549f, (float)0.0605f, (float)-0.2279f));
        PartDefinition og_hair_r4 = head.addOrReplaceChild("og_hair_r4", CubeListBuilder.create().texOffs(72, 10).addBox(-0.8201f, -0.2112f, 0.0f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0812f, (float)4.161f, (float)0.2616f, (float)-0.0113f, (float)0.0421f));
        PartDefinition og_hair_r5 = head.addOrReplaceChild("og_hair_r5", CubeListBuilder.create().texOffs(74, 10).addBox(-1.3099f, -0.2495f, 0.0f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0812f, (float)4.161f, (float)0.2587f, (float)-0.0405f, (float)0.1518f));
        PartDefinition og_hair_r6 = head.addOrReplaceChild("og_hair_r6", CubeListBuilder.create().texOffs(78, 10).addBox(-3.1776f, -0.0219f, 0.0f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0812f, (float)4.161f, (float)0.2549f, (float)-0.0605f, (float)0.2279f));
        PartDefinition og_hair_r7 = head.addOrReplaceChild("og_hair_r7", CubeListBuilder.create().texOffs(68, 10).addBox(0.3099f, -0.2495f, 0.0f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0812f, (float)4.161f, (float)0.2587f, (float)0.0405f, (float)-0.1518f));
        PartDefinition og_hair_r8 = head.addOrReplaceChild("og_hair_r8", CubeListBuilder.create().texOffs(76, 10).addBox(-2.2039f, -0.0236f, 0.0f, 1.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0812f, (float)4.161f, (float)0.2568f, (float)-0.0516f, (float)0.194f));
        PartDefinition bone40_r1 = head.addOrReplaceChild("bone40_r1", CubeListBuilder.create().texOffs(101, 9).addBox(-3.75f, 0.25f, 0.25f, 8.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.25f, (float)-0.2f, (float)3.8f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition rear_ponytail_r1 = head.addOrReplaceChild("rear_ponytail_r1", CubeListBuilder.create().texOffs(100, 0).addBox(-1.75f, -1.5f, 1.0f, 3.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(120, 0).addBox(-1.2f, -1.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.25f, (float)-1.75f, (float)4.05f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition rear_ponytail_r2 = head.addOrReplaceChild("rear_ponytail_r2", CubeListBuilder.create().texOffs(110, 0).addBox(-1.25f, -1.5f, 1.0f, 3.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(120, 3).addBox(-0.8f, -1.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.25f, (float)-1.75f, (float)4.05f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition pigtails_r1 = head.addOrReplaceChild("pigtails_r1", CubeListBuilder.create().texOffs(64, 0).addBox(-3.5f, -0.75f, -1.75f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(61, 0).addBox(-0.75f, -0.25f, -0.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-7.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition pigtails_r2 = head.addOrReplaceChild("pigtails_r2", CubeListBuilder.create().texOffs(73, 0).addBox(-1.25f, -0.25f, -0.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(76, 0).addBox(0.5f, -0.75f, -1.75f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-7.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition bone42_r1 = head.addOrReplaceChild("bone42_r1", CubeListBuilder.create().texOffs(85, 0).addBox(-1.0f, -0.25f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(88, 0).addBox(-1.5f, -0.25f, 0.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.5f, (float)4.25f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition blink = head.addOrReplaceChild("blink", CubeListBuilder.create().texOffs(24, 0).addBox(-4.0f, -26.0f, -4.001f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition armLeft = partdefinition.addOrReplaceChild("armLeft", CubeListBuilder.create().texOffs(32, 40).addBox(-0.2113f, -0.0469f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(36, 33).addBox(-0.7113f, -1.0469f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(60, 35).addBox(-0.7113f, -1.0469f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)2.5341f, (float)7.7588f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -7.5f, -3.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(24, 20).addBox(-4.0f, -7.5f, -3.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.2f)).texOffs(0, 33).addBox(-3.5f, 0.5f, -2.0f, 7.0f, 2.0f, 4.0f, new CubeDeformation(-0.0625f)).texOffs(18, 16).addBox(-0.5f, -7.0f, -4.01f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(52, 28).addBox(-0.5f, -3.5f, 2.5f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.5f, (float)0.0f));
        PartDefinition bone168_r1 = body.addOrReplaceChild("bone168_r1", CubeListBuilder.create().texOffs(0, 31).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.6875f, (float)-7.25f, (float)-2.75f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition backbow_r1 = body.addOrReplaceChild("backbow_r1", CubeListBuilder.create().texOffs(64, 20).addBox(-0.2056f, -0.208f, -1.4023f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5962f, (float)4.1137f, (float)0.0f, (float)-0.2618f, (float)-3.1241f));
        PartDefinition backbow_r2 = body.addOrReplaceChild("backbow_r2", CubeListBuilder.create().texOffs(64, 23).addBox(-4.7441f, -0.7487f, -1.3889f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5962f, (float)4.1137f, (float)0.0f, (float)0.2618f, (float)-0.1745f));
        PartDefinition backbow_r3 = body.addOrReplaceChild("backbow_r3", CubeListBuilder.create().texOffs(64, 25).addBox(-4.6903f, -0.7817f, -1.3744f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5962f, (float)4.1137f, (float)0.0f, (float)0.2618f, (float)-0.384f));
        PartDefinition backbow_r4 = body.addOrReplaceChild("backbow_r4", CubeListBuilder.create().texOffs(62, 28).addBox(-0.4847f, 0.1799f, -1.1529f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5962f, (float)4.1137f, (float)0.3927f, (float)0.0f, (float)0.48f));
        PartDefinition backbow_r5 = body.addOrReplaceChild("backbow_r5", CubeListBuilder.create().texOffs(52, 23).addBox(-0.2559f, -0.7487f, -1.3889f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5962f, (float)4.1137f, (float)0.0f, (float)-0.2618f, (float)0.1745f));
        PartDefinition backbow_r6 = body.addOrReplaceChild("backbow_r6", CubeListBuilder.create().texOffs(52, 25).addBox(-0.3097f, -0.7817f, -1.3744f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5962f, (float)4.1137f, (float)0.0f, (float)-0.2618f, (float)0.384f));
        PartDefinition backbow_r7 = body.addOrReplaceChild("backbow_r7", CubeListBuilder.create().texOffs(58, 28).addBox(-0.5153f, 0.1799f, -1.1529f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5962f, (float)4.1137f, (float)0.3927f, (float)0.0f, (float)-0.48f));
        PartDefinition backbow_r8 = body.addOrReplaceChild("backbow_r8", CubeListBuilder.create().texOffs(52, 20).addBox(-4.7944f, -0.208f, -1.4023f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5962f, (float)4.1137f, (float)0.0f, (float)0.2618f, (float)3.1241f));
        PartDefinition bowtie_r1 = body.addOrReplaceChild("bowtie_r1", CubeListBuilder.create().texOffs(18, 20).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-6.5f, (float)-3.75f, (float)-0.3185f, (float)-0.3035f, (float)0.8345f));
        PartDefinition bowtie_r2 = body.addOrReplaceChild("bowtie_r2", CubeListBuilder.create().texOffs(22, 16).addBox(-1.5f, -2.0f, 0.5f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-4.01f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bowtie_r3 = body.addOrReplaceChild("bowtie_r3", CubeListBuilder.create().texOffs(18, 18).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-6.5f, (float)-3.75f, (float)-0.3185f, (float)0.3035f, (float)-0.8345f));
        PartDefinition bone168_r2 = body.addOrReplaceChild("bone168_r2", CubeListBuilder.create().texOffs(8, 31).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.6875f, (float)-7.25f, (float)-2.75f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition skirt = body.addOrReplaceChild("skirt", CubeListBuilder.create().texOffs(24, 50).addBox(-2.5f, -11.0f, -2.5f, 7.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)10.5f, (float)-1.0f));
        PartDefinition apron2_r1 = skirt.addOrReplaceChild("apron2_r1", CubeListBuilder.create().texOffs(45, 48).addBox(-4.0f, -0.5f, 0.0f, 8.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-11.183f, (float)-2.5335f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition bone59_r1 = skirt.addOrReplaceChild("bone59_r1", CubeListBuilder.create().texOffs(16, 59).addBox(1.3605f, -3.9541f, 0.0311f, 3.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-6.1385f, (float)-3.238f, (float)-0.1601f, (float)-0.0388f, (float)-0.2135f));
        PartDefinition bone58_r1 = skirt.addOrReplaceChild("bone58_r1", CubeListBuilder.create().texOffs(60, 59).addBox(-4.3605f, -3.9541f, 0.0311f, 3.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-6.201f, (float)5.262f, (float)0.1765f, (float)-0.036f, (float)0.214f));
        PartDefinition bone59_r2 = skirt.addOrReplaceChild("bone59_r2", CubeListBuilder.create().texOffs(0, 59).addBox(-4.3605f, -3.9541f, 0.0311f, 3.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-6.1385f, (float)-3.238f, (float)-0.1601f, (float)0.0388f, (float)0.2135f));
        PartDefinition bone58_r2 = skirt.addOrReplaceChild("bone58_r2", CubeListBuilder.create().texOffs(6, 59).addBox(-2.5f, -4.4173f, 0.0108f, 5.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-6.1385f, (float)-3.2224f, (float)-0.1644f, (float)0.0f, (float)0.0f));
        PartDefinition bone59_r3 = skirt.addOrReplaceChild("bone59_r3", CubeListBuilder.create().texOffs(22, 56).addBox(0.0f, 0.2989f, -3.8614f, 0.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.4375f, (float)-10.5578f, (float)1.408f, (float)-0.1745f, (float)0.0f, (float)-0.2182f));
        PartDefinition bone57_r1 = skirt.addOrReplaceChild("bone57_r1", CubeListBuilder.create().texOffs(28, 54).addBox(0.0f, 0.0f, -2.5f, 0.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.4531f, (float)-10.5578f, (float)0.9705f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition bone58_r3 = skirt.addOrReplaceChild("bone58_r3", CubeListBuilder.create().texOffs(38, 56).addBox(0.0f, 0.2716f, 0.8809f, 0.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.4375f, (float)-10.5578f, (float)0.5955f, (float)0.1745f, (float)0.0f, (float)-0.2182f));
        PartDefinition bone58_r4 = skirt.addOrReplaceChild("bone58_r4", CubeListBuilder.create().texOffs(50, 59).addBox(-2.5f, -4.4173f, 0.0108f, 5.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-6.201f, (float)5.3245f, (float)0.1847f, (float)0.0f, (float)0.0f));
        PartDefinition bone58_r5 = skirt.addOrReplaceChild("bone58_r5", CubeListBuilder.create().texOffs(44, 59).addBox(1.3605f, -3.9541f, 0.0311f, 3.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-6.201f, (float)5.262f, (float)0.1765f, (float)0.036f, (float)-0.214f));
        PartDefinition bone59_r4 = skirt.addOrReplaceChild("bone59_r4", CubeListBuilder.create().texOffs(82, 56).addBox(0.0f, 0.2989f, -3.8614f, 0.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.4375f, (float)-10.5578f, (float)1.408f, (float)-0.1745f, (float)0.0f, (float)0.2182f));
        PartDefinition bone58_r6 = skirt.addOrReplaceChild("bone58_r6", CubeListBuilder.create().texOffs(66, 56).addBox(0.0f, 0.2716f, 0.8809f, 0.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.4375f, (float)-10.5578f, (float)0.5955f, (float)0.1745f, (float)0.0f, (float)0.2182f));
        PartDefinition bone57_r2 = skirt.addOrReplaceChild("bone57_r2", CubeListBuilder.create().texOffs(72, 54).addBox(0.0f, 0.0f, -2.5f, 0.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.4531f, (float)-10.5578f, (float)0.9705f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition apron2 = skirt.addOrReplaceChild("apron2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0f, (float)-11.0f, (float)-2.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition legLeft = partdefinition.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(12, 46).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 39).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offset((float)2.0f, (float)15.0f, (float)0.0f));
        PartDefinition legRight = partdefinition.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(0, 46).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 39).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-2.0f, (float)15.0f, (float)0.0f));
        PartDefinition wingLeft = partdefinition.addOrReplaceChild("wingLeft", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0f, (float)10.0f, (float)5.0f, (float)0.0f, (float)1.2217f, (float)0.0f));
        PartDefinition wingLeftUp_r1 = wingLeft.addOrReplaceChild("wingLeftUp_r1", CubeListBuilder.create().texOffs(0, 77).addBox(0.0f, -3.5858f, -1.4142f, 0.0f, 9.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0607f, (float)1.7678f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wingLeftDown_r1 = wingLeft.addOrReplaceChild("wingLeftDown_r1", CubeListBuilder.create().texOffs(16, 69).addBox(0.0f, 1.4142f, -7.4142f, 0.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.4142f, (float)1.4142f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wingRight = partdefinition.addOrReplaceChild("wingRight", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)10.0f, (float)5.0f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        PartDefinition wingRightDown_r1 = wingRight.addOrReplaceChild("wingRightDown_r1", CubeListBuilder.create().texOffs(0, 69).addBox(0.0f, 1.4142f, -7.4142f, 0.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.4142f, (float)1.4142f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wingRightUp_r1 = wingRight.addOrReplaceChild("wingRightUp_r1", CubeListBuilder.create().texOffs(0, 53).addBox(0.0f, -3.5858f, -1.4142f, 0.0f, 9.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0607f, (float)1.7678f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition armRight = partdefinition.addOrReplaceChild("armRight", CubeListBuilder.create().texOffs(48, 35).addBox(-2.2887f, -1.0469f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(-0.3f)).texOffs(24, 40).addBox(-1.7887f, -0.0469f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 33).addBox(-2.2887f, -1.0469f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5341f, (float)7.7588f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityFairy entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.armLeft.zRot = Mth.cos((float)(ageInTicks * 0.05f)) * 0.05f - 0.4f;
        this.armRight.zRot = -Mth.cos((float)(ageInTicks * 0.05f)) * 0.05f + 0.4f;
        if (entityIn.onGround()) {
            this.legLeft.xRot = Mth.cos((float)(limbSwing * 0.67f)) * 0.3f * limbSwingAmount;
            this.legRight.xRot = -Mth.cos((float)(limbSwing * 0.67f)) * 0.3f * limbSwingAmount;
            this.armLeft.xRot = -Mth.cos((float)(limbSwing * 0.67f)) * 0.7f * limbSwingAmount;
            this.armRight.xRot = Mth.cos((float)(limbSwing * 0.67f)) * 0.7f * limbSwingAmount;
            this.wingLeft.yRot = -Mth.cos((float)(ageInTicks * 0.3f)) * 0.2f + 1.0f;
            this.wingRight.yRot = Mth.cos((float)(ageInTicks * 0.3f)) * 0.2f - 1.0f;
        } else {
            this.legLeft.xRot = 0.0f;
            this.legRight.xRot = 0.0f;
            this.armLeft.xRot = -0.17453292f;
            this.armRight.xRot = -0.17453292f;
            this.head.xRot -= 0.13962634f;
            this.wingLeft.yRot = -Mth.cos((float)(ageInTicks * 0.5f)) * 0.4f + 1.2f;
            this.wingRight.yRot = Mth.cos((float)(ageInTicks * 0.5f)) * 0.4f - 1.2f;
        }
        float remainder = ageInTicks % 60.0f;
        this.blink.visible = 55.0f < remainder && remainder < 60.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.armRight.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.armLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.legLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.legRight.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.wingLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.wingRight.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

