/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.overlay;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.event.PressAIChatKeyEvent;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.RenderConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaidTipsOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_tips_icon.png");
    private static Map<Item, MutableComponent> TIPS = Maps.newHashMap();
    private static Map<Item, ModConfigSpec.BooleanValue> TIPS_CONFIG = Maps.newHashMap();
    private static Map<CheckCondition, MutableComponent> SPECIAL_TIPS = Maps.newHashMap();

    public static void init() {
        MaidTipsOverlay overlay = new MaidTipsOverlay();
        overlay.addTips("overlay.touhou_little_maid.compass.tips", RenderConfig.ENABLE_COMPASS_TIP, Items.COMPASS);
        overlay.addTips("overlay.touhou_little_maid.golden_apple.tips", RenderConfig.ENABLE_GOLDEN_APPLE_TIP, Items.GOLDEN_APPLE, Items.ENCHANTED_GOLDEN_APPLE);
        overlay.addTips("overlay.touhou_little_maid.potion.tips", RenderConfig.ENABLE_POTION_TIP, Items.POTION);
        overlay.addTips("overlay.touhou_little_maid.milk_bucket.tips", RenderConfig.ENABLE_MILK_BUCKET_TIP, Items.MILK_BUCKET);
        overlay.addTips("overlay.touhou_little_maid.script_book.tips", RenderConfig.ENABLE_SCRIPT_BOOK_TIP, Items.WRITABLE_BOOK, Items.WRITTEN_BOOK);
        overlay.addTips("overlay.touhou_little_maid.glass_bottle.tips", RenderConfig.ENABLE_GLASS_BOTTLE_TIP, Items.GLASS_BOTTLE);
        overlay.addTips("overlay.touhou_little_maid.name_tag.tips", RenderConfig.ENABLE_NAME_TAG_TIP, Items.NAME_TAG);
        overlay.addTips("overlay.touhou_little_maid.lead.tips", RenderConfig.ENABLE_LEAD_TIP, Items.LEAD);
        overlay.addTips("overlay.touhou_little_maid.debug_stick.tips", Items.DEBUG_STICK);
        overlay.addTips("overlay.touhou_little_maid.saddle.tips", RenderConfig.ENABLE_SADDLE_TIP, Items.SADDLE);
        overlay.addSpecialTips("overlay.touhou_little_maid.ntr_item.tips", (item, maid, player) -> !maid.isOwnedBy((LivingEntity)player) && EntityMaid.getNtrItem().test(item));
        overlay.addSpecialTips("overlay.touhou_little_maid.remove_backpack.tips", MaidTipsOverlay::checkShears);
        overlay.addSpecialTips("overlay.touhou_little_maid.ysm_roulette_anim.tips", MaidTipsOverlay::checkYsmRouletteAnimCondition);
        overlay.addSpecialTips("overlay.touhou_little_maid.can_ai_chat.tips", MaidTipsOverlay::checkAiChatCondition);
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.addMaidTips(overlay);
        }
        TIPS = ImmutableMap.copyOf(TIPS);
        TIPS_CONFIG = ImmutableMap.copyOf(TIPS_CONFIG);
        SPECIAL_TIPS = ImmutableMap.copyOf(SPECIAL_TIPS);
    }

    private static boolean checkShears(ItemStack item, EntityMaid maid, LocalPlayer player) {
        if (!((Boolean)RenderConfig.ENABLE_SHEARS_TIP.get()).booleanValue()) {
            return false;
        }
        return maid.isOwnedBy((LivingEntity)player) && maid.hasBackpack() && item.is(Tags.Items.TOOLS_SHEAR);
    }

    private static boolean checkYsmRouletteAnimCondition(ItemStack item, EntityMaid maid, LocalPlayer player) {
        if (!YsmCompat.isInstalled()) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return false;
        }
        if (!item.isEmpty()) {
            return false;
        }
        if (!((Boolean)RenderConfig.ENABLE_YSM_ROULETTE_TIP.get()).booleanValue()) {
            return false;
        }
        return maid.isOwnedBy((LivingEntity)player) && maid.isYsmModel();
    }

    private static boolean checkAiChatCondition(ItemStack item, EntityMaid maid, LocalPlayer player) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return false;
        }
        if (!item.isEmpty()) {
            return false;
        }
        if (!((Boolean)RenderConfig.ENABLE_AI_CHAT_TIP.get()).booleanValue()) {
            return false;
        }
        return maid.isOwnedBy((LivingEntity)player) && PressAIChatKeyEvent.CAN_CHAT_MAID_IDS.contains(maid.getModelId());
    }

    private static MutableComponent checkSpecialTips(ItemStack mainhandItem, EntityMaid maid, LocalPlayer player) {
        for (Map.Entry<CheckCondition, MutableComponent> entry : SPECIAL_TIPS.entrySet()) {
            CheckCondition condition = entry.getKey();
            MutableComponent text = entry.getValue();
            if (!condition.test(mainhandItem, maid, player)) continue;
            return text;
        }
        return null;
    }

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        MutableComponent tip;
        Minecraft minecraft = Minecraft.getInstance();
        Options options = minecraft.options;
        if (!options.getCameraType().isFirstPerson()) {
            return;
        }
        if (minecraft.gameMode == null || minecraft.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        HitResult hitResult = minecraft.hitResult;
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult result = (EntityHitResult)hitResult;
        Entity entity = result.getEntity();
        if (!(entity instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)entity;
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (!maid.isAlive()) {
            return;
        }
        if (player.getVehicle() != null && player.getVehicle().equals((Object)maid.getVehicle())) {
            return;
        }
        ItemStack itemStack = player.getMainHandItem();
        Item item = itemStack.getItem();
        if (maid.isOwnedBy((LivingEntity)player) && TIPS.containsKey(item)) {
            boolean configIsEnable;
            boolean configIsNull = !TIPS_CONFIG.containsKey(item);
            boolean bl = configIsEnable = TIPS_CONFIG.containsKey(item) && (Boolean)TIPS_CONFIG.get(item).get() != false;
            tip = configIsNull || configIsEnable ? TIPS.get(item) : MaidTipsOverlay.checkSpecialTips(itemStack, maid, player);
        } else {
            tip = MaidTipsOverlay.checkSpecialTips(itemStack, maid, player);
        }
        if (tip != null) {
            int screenHeight = guiGraphics.guiHeight();
            int screenWidth = guiGraphics.guiWidth();
            List split = minecraft.font.split((FormattedText)tip, 120);
            int offset = screenHeight / 2 - 5 - split.size() * 10;
            guiGraphics.renderItem(itemStack, screenWidth / 2 + 32, offset);
            guiGraphics.blit(ICON, screenWidth / 2 + 42, offset - 4, 16.0f, 16.0f, 16, 16, 16, 16);
            offset += 18;
            for (FormattedCharSequence sequence : split) {
                guiGraphics.drawString(minecraft.font, sequence, screenWidth / 2 + 32, offset, 0xFFFFFF);
                offset += 10;
            }
        }
    }

    public void addTips(String key, Item ... items) {
        this.addTips(key, (ModConfigSpec.BooleanValue)null, items);
    }

    public void addTips(String key, @Nullable ModConfigSpec.BooleanValue config, Item ... items) {
        for (Item item : items) {
            TIPS.put(item, Component.translatable((String)key));
            if (config == null) continue;
            TIPS_CONFIG.put(item, config);
        }
    }

    public void addSpecialTips(String key, CheckCondition condition) {
        SPECIAL_TIPS.put(condition, Component.translatable((String)key));
    }

    public static interface CheckCondition {
        public boolean test(ItemStack var1, EntityMaid var2, LocalPlayer var3);
    }
}

