/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.MaidChatBubbles;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.client.ClientHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class ChatBubbleRenderer {
    private static final RenderStateShard.TransparencyStateShard NO_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("no_transparency", RenderSystem::disableBlend, () -> {});
    private static final Function<ResourceLocation, RenderType> CHAT_BUBBLE_RENDER = Util.memoize(ChatBubbleRenderer::chatBubbleRender);
    private static final List<Pair<Long, ChatText>> TMP_CHAT_BUBBLES = Lists.newArrayList();
    private static final String LEFT_ARROW = "left_arrow";
    private static final String MIDDLE_ARROW = "middle_arrow";
    private static final String RIGHT_ARROW = "right_arrow";

    public static void renderChatBubble(EntityMaidRenderer renderer, EntityMaid maid, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        double distance = renderer.getDispatcher().distanceToSqr((Entity)maid);
        if (ClientHooks.isNameplateInRenderDistance((Entity)maid, (double)distance)) {
            ChatBubbleRenderer.getTmpChatBubbles(maid);
            Font font = renderer.getFont();
            if (TMP_CHAT_BUBBLES.size() == 1) {
                Pair<Long, ChatText> chatBubble = TMP_CHAT_BUBBLES.get(0);
                ChatText chatText = (ChatText)chatBubble.getRight();
                RenderData data = new RenderData(renderer, maid, matrixStack, buffer, MIDDLE_ARROW);
                if (chatText.isText()) {
                    MutableComponent parseText = ParseI18n.parse(chatText.getText());
                    int width = font.width((FormattedText)parseText);
                    ChatBubbleRenderer.renderChatBubbleBody(0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$1((Component)parseText, maid, width, packedLight, arg_0));
                }
                if (chatText.isIcon()) {
                    ChatBubbleRenderer.renderChatBubbleBody(0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data, d -> ChatBubbleRenderer.renderIcon(0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText.getIconPath(), d));
                }
                return;
            }
            if (TMP_CHAT_BUBBLES.size() == 2) {
                int startX;
                int startX2;
                int fullWidth;
                int width;
                Pair<Long, ChatText> chatBubble1 = TMP_CHAT_BUBBLES.get(0);
                Pair<Long, ChatText> chatBubble2 = TMP_CHAT_BUBBLES.get(1);
                ChatText chatText1 = (ChatText)chatBubble1.getRight();
                ChatText chatText2 = (ChatText)chatBubble2.getRight();
                RenderData data1 = new RenderData(renderer, maid, matrixStack, buffer, RIGHT_ARROW);
                RenderData data2 = new RenderData(renderer, maid, matrixStack, buffer, LEFT_ARROW);
                if (chatText1.isText()) {
                    MutableComponent parseText1 = ParseI18n.parse(chatText1.getText());
                    width = font.width((FormattedText)parseText1);
                    fullWidth = (width / 20 + 2) * 20;
                    startX2 = -fullWidth / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX2, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data1, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$3((Component)parseText1, startX2, maid, width, packedLight, arg_0));
                }
                if (chatText1.isIcon()) {
                    int fullWidth2 = 60;
                    startX = -fullWidth2 / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data1, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText1.getIconPath(), d));
                }
                if (chatText2.isText()) {
                    MutableComponent parseText2 = ParseI18n.parse(chatText2.getText());
                    width = font.width((FormattedText)parseText2);
                    fullWidth = (width / 20 + 2) * 20;
                    startX2 = fullWidth / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX2, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data2, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$5((Component)parseText2, startX2, maid, width, packedLight, arg_0));
                }
                if (chatText2.isIcon()) {
                    int fullWidth3 = 60;
                    startX = fullWidth3 / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data2, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText2.getIconPath(), d));
                }
                return;
            }
            if (TMP_CHAT_BUBBLES.size() == 3) {
                int startX;
                int startX3;
                int fullWidth;
                int width;
                Pair<Long, ChatText> chatBubble1 = TMP_CHAT_BUBBLES.get(0);
                Pair<Long, ChatText> chatBubble2 = TMP_CHAT_BUBBLES.get(1);
                Pair<Long, ChatText> chatBubble3 = TMP_CHAT_BUBBLES.get(2);
                ChatText chatText1 = (ChatText)chatBubble1.getRight();
                ChatText chatText2 = (ChatText)chatBubble2.getRight();
                ChatText chatText3 = (ChatText)chatBubble3.getRight();
                RenderData data1 = new RenderData(renderer, maid, matrixStack, buffer, RIGHT_ARROW);
                RenderData data2 = new RenderData(renderer, maid, matrixStack, buffer, LEFT_ARROW);
                RenderData data3 = new RenderData(renderer, maid, matrixStack, buffer, MIDDLE_ARROW);
                if (chatText1.isText()) {
                    MutableComponent parseText1 = ParseI18n.parse(chatText1.getText());
                    width = font.width((FormattedText)parseText1);
                    fullWidth = (width / 20 + 2) * 20;
                    startX3 = -fullWidth / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX3, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data1, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$7((Component)parseText1, startX3, maid, width, packedLight, arg_0));
                }
                if (chatText1.isIcon()) {
                    int fullWidth4 = 60;
                    startX = -fullWidth4 / 2 - 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data1, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText1.getIconPath(), d));
                }
                if (chatText2.isText()) {
                    MutableComponent parseText2 = ParseI18n.parse(chatText2.getText());
                    width = font.width((FormattedText)parseText2);
                    fullWidth = (width / 20 + 2) * 20;
                    startX3 = fullWidth / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX3, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, data2, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$9((Component)parseText2, startX3, maid, width, packedLight, arg_0));
                }
                if (chatText2.isIcon()) {
                    int fullWidth5 = 60;
                    startX = fullWidth5 / 2 + 5;
                    ChatBubbleRenderer.renderChatBubbleBody(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data2, d -> ChatBubbleRenderer.renderIcon(startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), chatText2.getIconPath(), d));
                }
                if (chatText3.isText()) {
                    MutableComponent parseText3 = ParseI18n.parse(chatText3.getText());
                    width = font.width((FormattedText)parseText3);
                    ChatBubbleRenderer.renderChatBubbleBody(0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), width, data3, arg_0 -> ChatBubbleRenderer.lambda$renderChatBubble$11((Component)parseText3, maid, width, packedLight, arg_0));
                }
                if (chatText3.isIcon()) {
                    ChatBubbleRenderer.renderChatBubbleBody(0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), 20, data3, d -> ChatBubbleRenderer.renderIcon(0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), chatText3.getIconPath(), d));
                }
            }
        }
    }

    private static int getRenderYOffset(EntityMaid maid) {
        if (maid.isSleeping()) {
            return 48;
        }
        return 0;
    }

    private static void renderText(Component chatText, int startX, int startY, int width, int packedLight, RenderData data) {
        Font font = data.renderer.getFont();
        font.drawInBatch(chatText, (float)(-width) / 2.0f + (float)startX, (float)(startY + 6), -16777216, false, data.matrixStack.last().pose(), data.buffer, Font.DisplayMode.NORMAL, 0, packedLight);
    }

    private static void renderIcon(int startX, int startY, ResourceLocation iconPath, RenderData data) {
        VertexConsumer iconVertexBuilder = data.buffer.getBuffer(CHAT_BUBBLE_RENDER.apply(iconPath));
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(iconPath);
        if (texture instanceof SizeTexture) {
            int textureWidth;
            SizeTexture sizeTexture = (SizeTexture)texture;
            int textureHeight = sizeTexture.getHeight();
            int count = textureHeight / ((textureWidth = sizeTexture.getWidth()) / 3);
            if (count <= 1) {
                ChatBubbleRenderer.drawIcon(data.matrixStack, iconVertexBuilder, startX - 30, startY, 0.0f, 0.0f, 1.0f);
            } else {
                int iconDelay = data.maid.tickCount / 2 % count;
                float vStart = 1.0f / (float)count * (float)iconDelay;
                float vEnd = 1.0f / (float)count * (float)(iconDelay + 1);
                ChatBubbleRenderer.drawIcon(data.matrixStack, iconVertexBuilder, startX - 30, startY, 0.0f, vStart, vEnd);
            }
        }
    }

    private static float getChatBubbleStartHeight(EntityMaidRenderer renderer, EntityMaid maid) {
        float height = maid.getBbHeight() + 0.75f;
        if (((BedrockModel)renderer.getModel()).hasHead()) {
            height = (24.0f - ((BedrockModel)renderer.getModel()).getHead().y) * 0.0625f + 0.75f;
        }
        return height;
    }

    private static void getTmpChatBubbles(EntityMaid maid) {
        MaidChatBubbles chatBubble = maid.getChatBubble();
        Pair<Long, ChatText> bubble1 = chatBubble.bubble1();
        Pair<Long, ChatText> bubble2 = chatBubble.bubble2();
        Pair<Long, ChatText> bubble3 = chatBubble.bubble3();
        TMP_CHAT_BUBBLES.clear();
        if (bubble1 != MaidChatBubbles.EMPTY) {
            TMP_CHAT_BUBBLES.add(bubble1);
        }
        if (bubble2 != MaidChatBubbles.EMPTY) {
            TMP_CHAT_BUBBLES.add(bubble2);
        }
        if (bubble3 != MaidChatBubbles.EMPTY) {
            TMP_CHAT_BUBBLES.add(bubble3);
        }
    }

    private static void renderChatBubbleBody(int startX, int startY, int stringWidth, RenderData data, Consumer<RenderData> consumer) {
        ResourceLocation bg = data.renderer.getMainInfo().getChatBubble().getBg();
        float height = ChatBubbleRenderer.getChatBubbleStartHeight(data.renderer, data.maid);
        int count = stringWidth / 20;
        int fullWidth = (count + 2) * 20;
        int leftStartX = -fullWidth / 2 + startX;
        int rightStartX = fullWidth / 2 - 20 + startX;
        int middleStartX = -fullWidth / 2 + 20 + startX;
        data.matrixStack.pushPose();
        data.matrixStack.translate(0.0f, height, 0.0f);
        data.matrixStack.mulPose(data.renderer.getDispatcher().cameraOrientation());
        data.matrixStack.scale(0.025f, -0.025f, -0.025f);
        VertexConsumer vertexBuilder = data.buffer.getBuffer(CHAT_BUBBLE_RENDER.apply(bg));
        ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, leftStartX, startY, 0.2f, 0, 0);
        for (int i = 0; i < count; ++i) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, middleStartX, startY, 0.2f, 1, 0);
            middleStartX += 20;
        }
        ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, rightStartX, startY, 0.2f, 2, 0);
        if (LEFT_ARROW.equals(data.arrow)) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, leftStartX - 10, startY + 10, 0.19f, 0, 1);
        }
        if (MIDDLE_ARROW.equals(data.arrow)) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, startX - 10, startY + 10, 0.19f, 1, 1);
        }
        if (RIGHT_ARROW.equals(data.arrow)) {
            ChatBubbleRenderer.drawBg(data.matrixStack, vertexBuilder, rightStartX + 10, startY + 10, 0.19f, 2, 1);
        }
        consumer.accept(data);
        data.matrixStack.popPose();
    }

    public static void drawBg(PoseStack matrixStack, VertexConsumer builder, int x, int y, float z, int uIndex, int vIndex) {
        float height = 20.0f;
        float width = 20.0f;
        Matrix4f matrix4f = matrixStack.last().pose();
        float u0 = (float)uIndex / 3.0f;
        float u1 = (float)(uIndex + 1) / 3.0f;
        float v0 = (float)vIndex / 2.0f;
        float v1 = (float)(vIndex + 1) / 2.0f;
        ChatBubbleRenderer.vertex(matrix4f, builder, x, (float)y + height, z, u0, v1);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, (float)y + height, z, u1, v1);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, y, z, u1, v0);
        ChatBubbleRenderer.vertex(matrix4f, builder, x, y, z, u0, v0);
    }

    public static void drawIcon(PoseStack matrixStack, VertexConsumer builder, int x, int y, float z, float vStart, float vEnd) {
        float height = 20.0f;
        float width = 60.0f;
        Matrix4f matrix4f = matrixStack.last().pose();
        ChatBubbleRenderer.vertex(matrix4f, builder, x, (float)y + height, z, 0.0f, vEnd);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, (float)y + height, z, 1.0f, vEnd);
        ChatBubbleRenderer.vertex(matrix4f, builder, (float)x + width, y, z, 1.0f, vStart);
        ChatBubbleRenderer.vertex(matrix4f, builder, x, y, z, 0.0f, vStart);
    }

    private static void vertex(Matrix4f matrix4f, VertexConsumer builder, float x, float y, float z, float u, float v) {
        builder.addVertex(matrix4f, x, y, z).setUv(u, v);
    }

    private static RenderType chatBubbleRender(ResourceLocation locationIn) {
        RenderStateShard.ShaderStateShard shaderStateShard = new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexShader);
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setShaderState(shaderStateShard).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false, false)).setTransparencyState(NO_TRANSPARENCY).createCompositeState(true);
        return RenderType.create((String)"chat_bubble", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)255, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState);
    }

    private static /* synthetic */ void lambda$renderChatBubble$11(Component parseText3, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText3, 0, -62 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static /* synthetic */ void lambda$renderChatBubble$9(Component parseText2, int startX, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText2, startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static /* synthetic */ void lambda$renderChatBubble$7(Component parseText1, int startX, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText1, startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static /* synthetic */ void lambda$renderChatBubble$5(Component parseText2, int startX, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText2, startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static /* synthetic */ void lambda$renderChatBubble$3(Component parseText1, int startX, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText1, startX, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static /* synthetic */ void lambda$renderChatBubble$1(Component parseText, EntityMaid maid, int width, int packedLight, RenderData d) {
        ChatBubbleRenderer.renderText(parseText, 0, -32 + ChatBubbleRenderer.getRenderYOffset(maid), width, packedLight, d);
    }

    private static class RenderData {
        private final EntityMaidRenderer renderer;
        private final EntityMaid maid;
        private final PoseStack matrixStack;
        private final MultiBufferSource buffer;
        private final String arrow;

        public RenderData(EntityMaidRenderer renderer, EntityMaid maid, PoseStack matrixStack, MultiBufferSource buffer, String arrow) {
            this.renderer = renderer;
            this.maid = maid;
            this.matrixStack = matrixStack;
            this.buffer = buffer;
            this.arrow = arrow;
        }
    }
}

