/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.AbstractModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityBoxModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBox;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class EntityBoxRender
extends EntityRenderer<EntityBox> {
    private final List<ResourceLocation> texturesGroup = Lists.newArrayList();
    private final AbstractModel<EntityBox> boxModel;

    public EntityBoxRender(EntityRendererProvider.Context manager) {
        super(manager);
        this.boxModel = new EntityBoxModel(manager.bakeLayer(EntityBoxModel.LAYER));
        IntStream.range(0, 8).forEach(this::addBoxTexture);
    }

    public void render(EntityBox entityBox, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0, -1.501, 0.0);
        this.boxModel.setupAnim(entityBox, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        RenderType renderType = RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entityBox));
        VertexConsumer buffer = bufferIn.getBuffer(renderType);
        this.boxModel.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(EntityBox entity) {
        return this.texturesGroup.get(entity.getTextureIndex());
    }

    private void addBoxTexture(int index) {
        String fileName = String.format("textures/entity/box/cake_box_%s.png", index);
        this.texturesGroup.add(ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)fileName));
    }
}

