/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.TombstoneModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class EntityTombstoneRenderer
extends EntityRenderer<EntityTombstone> {
    private static final ResourceLocation DEFAULT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/tombstone/tombstone.png");
    private static final ResourceLocation THE_NETHER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/tombstone/tombstone_the_nether.png");
    private static final ResourceLocation THE_END_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/tombstone/tombstone_the_end.png");
    private static final ResourceLocation TWILIGHT_FOREST_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/tombstone/tombstone_twilight_forest.png");
    private static final ResourceLocation AETHER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/tombstone/tombstone_aether.png");
    private static final ResourceLocation TWILIGHT_FOREST_LEVEL_ID = ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"twilight_forest");
    private static final ResourceLocation AETHER_LEVEL_ID = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"the_aether");
    private static final int NAME_SHOW_DISTANCE = 64;
    private final TombstoneModel tombstoneModel;

    public EntityTombstoneRenderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.tombstoneModel = new TombstoneModel(manager.bakeLayer(TombstoneModel.LAYER));
    }

    public void render(EntityTombstone tombstone, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0, -1.501, 0.0);
        this.tombstoneModel.setupAnim(tombstone, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        RenderType renderType = RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(tombstone));
        VertexConsumer buffer = bufferIn.getBuffer(renderType);
        this.tombstoneModel.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.popPose();
        if (this.shouldShowName(tombstone)) {
            this.renderNameTag(tombstone, (Component)Component.translatable((String)"entity.touhou_little_maid.tombstone.display").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE}), 1.6f, poseStack, bufferIn, packedLight);
            this.renderNameTag(tombstone, tombstone.getMaidName(), 1.85f, poseStack, bufferIn, packedLight);
        }
    }

    protected boolean shouldShowName(EntityTombstone tombstone) {
        return !tombstone.getMaidName().equals((Object)Component.empty());
    }

    public ResourceLocation getTextureLocation(EntityTombstone entity) {
        ResourceLocation dimension = entity.level.dimension().location();
        if (dimension.equals((Object)Level.NETHER.location())) {
            return THE_NETHER_TEXTURE;
        }
        if (dimension.equals((Object)Level.END.location())) {
            return THE_END_TEXTURE;
        }
        if (dimension.equals((Object)TWILIGHT_FOREST_LEVEL_ID)) {
            return TWILIGHT_FOREST_TEXTURE;
        }
        if (dimension.equals((Object)AETHER_LEVEL_ID)) {
            return AETHER_TEXTURE;
        }
        return DEFAULT_TEXTURE;
    }

    private void renderNameTag(EntityTombstone tombstone, Component component, float yOffset, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        double distance = this.entityRenderDispatcher.distanceToSqr((Entity)tombstone);
        if (distance < 4096.0) {
            poseStack.pushPose();
            poseStack.translate(0.0f, yOffset, 0.0f);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.scale(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.last().pose();
            Font font = this.getFont();
            float width = -font.width((FormattedText)component) / 2;
            font.drawInBatch(component, width, 0.0f, -1, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.popPose();
        }
    }
}

