/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBannerModel;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class GeckoLayerMaidBanner<T extends Mob, R extends IGeoEntityRenderer<T>>
extends GeoLayerRenderer<T, R> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/maid_banner.png");
    private final MaidBannerModel bannerModel;
    private final EntityModelSet modelSet;

    public GeckoLayerMaidBanner(R renderer, EntityModelSet modelSet) {
        super(renderer);
        this.modelSet = modelSet;
        this.bannerModel = new MaidBannerModel(modelSet.bakeLayer(MaidBannerModel.LAYER));
    }

    @Override
    public GeoLayerRenderer<T, R> copy(R entityRendererIn) {
        return new GeckoLayerMaidBanner<T, R>(entityRendererIn, this.modelSet);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Item item;
        EntityMaid maid = IMaid.convertToMaid(entity);
        if (maid == null || !((item = maid.getBackpackShowItem().getItem()) instanceof BannerItem)) {
            return;
        }
        BannerItem bannerItem = (BannerItem)item;
        if (!this.getGeoEntity(entity).getMaidInfo().isShowBackpack() || entity.isSleeping() || entity.isInvisible()) {
            return;
        }
        if (!maid.getConfigManager().isShowBackItem()) {
            return;
        }
        ILocationModel geoModel = this.getLocationModel(entity);
        if (geoModel != null && !geoModel.backpackBones().isEmpty()) {
            poseStack.pushPose();
            RenderUtils.prepMatrixForLocator(poseStack, geoModel.backpackBones());
            poseStack.translate(0.0, 0.75, 0.3);
            poseStack.scale(0.65f, -0.65f, -0.65f);
            poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
            poseStack.mulPose(Axis.XN.rotationDegrees(5.0f));
            VertexConsumer buffer = bufferIn.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE));
            this.bannerModel.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
            BannerPatternLayers bannerpatternlayers = (BannerPatternLayers)maid.getBackpackShowItem().get(DataComponents.BANNER_PATTERNS);
            DyeColor baseColor = ((AbstractBannerBlock)bannerItem.getBlock()).getColor();
            if (bannerpatternlayers != null) {
                BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLight, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.bannerModel.getBanner(), (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)baseColor, (BannerPatternLayers)bannerpatternlayers);
            }
            poseStack.popPose();
        }
    }
}

