/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class GeckoLayerMaidBipedHead<T extends Mob, R extends IGeoEntityRenderer<T>>
extends GeoLayerRenderer<T, R> {
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;
    private final EntityModelSet modelSet;

    public GeckoLayerMaidBipedHead(R entityRendererIn, EntityModelSet modelSet) {
        super(entityRendererIn);
        this.modelSet = modelSet;
        this.skullModels = SkullBlockRenderer.createSkullRenderers((EntityModelSet)modelSet);
    }

    @Override
    public GeoLayerRenderer<T, R> copy(R entityRendererIn) {
        return new GeckoLayerMaidBipedHead<T, R>(entityRendererIn, this.modelSet);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IGeoEntity animatableEntity = this.getGeoEntity(entity);
        if (animatableEntity.getGeoModel() != null) {
            IMaid maid;
            Item type;
            boolean allowRenderHead;
            ItemStack head = entity.getItemBySlot(EquipmentSlot.HEAD);
            ILocationModel model = animatableEntity.getGeoModel();
            boolean bl = allowRenderHead = animatableEntity.getMaidInfo().isShowCustomHead() && !model.headBones().isEmpty();
            if (!allowRenderHead) {
                return;
            }
            if (!head.isEmpty()) {
                Block block;
                Item item = head.getItem();
                poseStack.pushPose();
                RenderUtils.prepMatrixForLocator(poseStack, model.headBones());
                if (item instanceof BlockItem && (block = ((BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
                    AbstractSkullBlock skullBlock = (AbstractSkullBlock)block;
                    poseStack.scale(-1.1875f, 1.1875f, -1.1875f);
                    ResolvableProfile resolvableProfile = (ResolvableProfile)head.get(DataComponents.PROFILE);
                    poseStack.translate(-0.5, 0.0, -0.5);
                    type = skullBlock.getType();
                    SkullModelBase modelBase = this.skullModels.get(type);
                    RenderType rendertype = SkullBlockRenderer.getRenderType((SkullBlock.Type)type, (ResolvableProfile)resolvableProfile);
                    SkullBlockRenderer.renderSkull(null, (float)180.0f, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (SkullModelBase)modelBase, (RenderType)rendertype);
                }
                poseStack.popPose();
            }
            if ((maid = IMaid.convert(entity)) == null) {
                return;
            }
            ItemStack stack = maid.getBackpackShowItem();
            type = stack.getItem();
            if (type instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)type;
                BlockState blockState = blockItem.getBlock().defaultBlockState();
                poseStack.pushPose();
                RenderUtils.prepMatrixForLocator(poseStack, model.headBones());
                poseStack.scale(-0.8f, 0.8f, -0.8f);
                poseStack.translate(-0.5, 0.625, -0.5);
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockState, poseStack, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
                poseStack.popPose();
            }
        }
    }
}

