/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBannerModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class LayerMaidBanner
extends RenderLayer<Mob, BedrockModel<Mob>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/maid_banner.png");
    private final EntityMaidRenderer renderer;
    private final MaidBannerModel bannerModel;

    public LayerMaidBanner(EntityMaidRenderer renderer, EntityModelSet modelSet) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
        this.bannerModel = new MaidBannerModel(modelSet.bakeLayer(MaidBannerModel.LAYER));
    }

    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn, Mob mob, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IMaid maid = IMaid.convert(mob);
        if (maid == null) {
            return;
        }
        ItemStack stack = maid.getBackpackShowItem();
        Item item = stack.getItem();
        if (item instanceof BannerItem) {
            EntityMaid entityMaid;
            BannerItem bannerItem = (BannerItem)item;
            if (!this.renderer.getMainInfo().isShowBackpack() || mob.isSleeping() || mob.isInvisible()) {
                return;
            }
            if (maid instanceof EntityMaid && !(entityMaid = (EntityMaid)maid).getConfigManager().isShowBackItem()) {
                return;
            }
            matrixStack.pushPose();
            matrixStack.translate(0.0, 0.5, 0.025);
            matrixStack.scale(0.5f, 0.5f, 0.5f);
            matrixStack.mulPose(Axis.XN.rotationDegrees(5.0f));
            VertexConsumer buffer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
            this.bannerModel.renderToBuffer(matrixStack, buffer, packedLightIn, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
            BannerPatternLayers layers = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
            DyeColor color = ((AbstractBannerBlock)bannerItem.getBlock()).getColor();
            if (layers != null) {
                BannerRenderer.renderPatterns((PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.bannerModel.getBanner(), (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)color, (BannerPatternLayers)layers);
            }
            matrixStack.popPose();
        }
    }
}

