/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class LayerMaidBipedHead
extends RenderLayer<Mob, BedrockModel<Mob>> {
    private final EntityMaidRenderer maidRenderer;
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;

    public LayerMaidBipedHead(EntityMaidRenderer maidRenderer, EntityModelSet modelSet) {
        super((RenderLayerParent)maidRenderer);
        this.maidRenderer = maidRenderer;
        this.skullModels = SkullBlockRenderer.createSkullRenderers((EntityModelSet)modelSet);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, Mob mob, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IMaid maid;
        Item type;
        boolean allowRenderHead;
        boolean bl = allowRenderHead = this.maidRenderer.getMainInfo().isShowCustomHead() && ((BedrockModel)this.getParentModel()).hasHead();
        if (!allowRenderHead) {
            return;
        }
        ItemStack head = mob.getItemBySlot(EquipmentSlot.HEAD);
        if (!head.isEmpty()) {
            Block block;
            Item item = head.getItem();
            poseStack.pushPose();
            ((BedrockModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
            if (item instanceof BlockItem && (block = ((BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
                AbstractSkullBlock skullBlock = (AbstractSkullBlock)block;
                poseStack.scale(1.1875f, -1.1875f, -1.1875f);
                ResolvableProfile resolvableProfile = (ResolvableProfile)head.get(DataComponents.PROFILE);
                poseStack.translate(-0.5, 0.0, -0.5);
                type = skullBlock.getType();
                SkullModelBase modelBase = this.skullModels.get(type);
                RenderType rendertype = SkullBlockRenderer.getRenderType((SkullBlock.Type)type, (ResolvableProfile)resolvableProfile);
                SkullBlockRenderer.renderSkull(null, (float)180.0f, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (SkullModelBase)modelBase, (RenderType)rendertype);
            }
            poseStack.popPose();
        }
        if ((maid = IMaid.convert(mob)) == null) {
            return;
        }
        ItemStack stack = maid.getBackpackShowItem();
        type = stack.getItem();
        if (type instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)type;
            BlockState blockState = blockItem.getBlock().defaultBlockState();
            poseStack.pushPose();
            ((BedrockModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
            poseStack.scale(0.8f, -0.8f, -0.8f);
            poseStack.translate(-0.5, 0.625, -0.5);
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockState, poseStack, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
            poseStack.popPose();
        }
    }
}

