/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.CChessModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.CChessPiecesModel;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityCChess;
import com.github.tartaricacid.touhoulittlemaid.util.CChessUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class TileEntityCChessRenderer
implements BlockEntityRenderer<TileEntityCChess> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/cchess.png");
    private static final ResourceLocation PIECES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/cchess_pieces.png");
    private static final int TIPS_RENDER_DISTANCE = 16;
    private static final int PIECE_RENDER_DISTANCE = 24;
    private final Font font;
    private final BlockEntityRenderDispatcher dispatcher;
    private final CChessModel chessModel;
    private final CChessPiecesModel[] chessPiecesModels;
    private final CChessPiecesModel selectedModels;

    public TileEntityCChessRenderer(BlockEntityRendererProvider.Context context) {
        this.chessModel = new CChessModel(context.bakeLayer(CChessModel.LAYER));
        this.chessPiecesModels = CChessPiecesModel.initModel();
        this.selectedModels = CChessPiecesModel.getSelectedModel();
        this.dispatcher = context.getBlockEntityRenderDispatcher();
        this.font = context.getFont();
    }

    public void render(TileEntityCChess cchess, float pPartialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction facing = (Direction)cchess.getBlockState().getValue((Property)BlockGomoku.FACING);
        this.renderChessboard(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, facing);
        this.renderPiece(cchess, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, facing);
        this.renderTipsText(cchess, poseStack, bufferIn, combinedLightIn);
    }

    private void renderTipsText(TileEntityCChess chess, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        boolean showTips;
        boolean bl = showTips = chess.isCheckmate() || chess.isRepeat() || chess.isMoveNumberLimit();
        if (!showTips || !this.inRenderDistance(chess, 16)) {
            return;
        }
        Camera camera = this.dispatcher.camera;
        MutableComponent loseTips = null;
        MutableComponent resetTips = Component.translatable((String)"message.touhou_little_maid.cchess.reset").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.AQUA);
        MutableComponent roundText = Component.translatable((String)"message.touhou_little_maid.gomoku.round", (Object[])new Object[]{chess.getChessCounter()}).withStyle(ChatFormatting.WHITE);
        MutableComponent preRoundIcon = Component.literal((String)"\u23f9 ").withStyle(ChatFormatting.GREEN);
        MutableComponent postRoundIcon = Component.literal((String)" \u23f9").withStyle(ChatFormatting.GREEN);
        MutableComponent roundTips = preRoundIcon.append((Component)roundText).append((Component)postRoundIcon);
        if (chess.isCheckmate()) {
            loseTips = !chess.isPlayerTurn() ? Component.translatable((String)"message.touhou_little_maid.gomoku.win").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_PURPLE) : Component.translatable((String)"message.touhou_little_maid.gomoku.lose").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_PURPLE);
        } else if (chess.isMoveNumberLimit()) {
            loseTips = Component.translatable((String)"message.touhou_little_maid.cchess.move_limit").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_PURPLE);
        } else if (chess.isRepeat()) {
            loseTips = Component.translatable((String)"message.touhou_little_maid.cchess.repeat").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_PURPLE);
        }
        if (loseTips == null) {
            return;
        }
        float loseTipsWidth = -this.font.width((FormattedText)loseTips) / 2;
        float resetTipsWidth = -this.font.width((FormattedText)resetTips) / 2;
        float roundTipsWidth = -this.font.width((FormattedText)roundTips) / 2;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.75, 0.5);
        poseStack.mulPose(Axis.YN.rotationDegrees(180.0f + camera.getYRot()));
        poseStack.mulPose(Axis.XN.rotationDegrees(camera.getXRot()));
        poseStack.scale(0.03f, -0.03f, 0.03f);
        this.font.drawInBatch((Component)loseTips, loseTipsWidth, -10.0f, 0xFFFFFF, true, poseStack.last().pose(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        this.font.drawInBatch((Component)roundTips, roundTipsWidth, -30.0f, 0xFFFFFF, true, poseStack.last().pose(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
        this.font.drawInBatch((Component)resetTips, resetTipsWidth, 0.0f, 0xFFFFFF, true, poseStack.last().pose(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
        poseStack.popPose();
    }

    private void renderPiece(TileEntityCChess cchess, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Direction facing) {
        if (this.inRenderDistance(cchess, 24)) {
            VertexConsumer piecesBuff = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)PIECES_TEXTURE));
            int selectX = Position.FILE_X(cchess.getSelectChessPoint());
            int selectY = Position.RANK_Y(cchess.getSelectChessPoint());
            byte[] data = cchess.getChessData().squares;
            poseStack.pushPose();
            switch (facing) {
                case NORTH: {
                    poseStack.translate(1.865, 1.625, 1.87);
                    break;
                }
                case EAST: {
                    poseStack.translate(-0.865, 1.625, 1.87);
                    break;
                }
                case WEST: {
                    poseStack.translate(1.865, 1.625, -0.8700000000000001);
                    break;
                }
                default: {
                    poseStack.translate(-0.865, 1.625, -0.8700000000000001);
                }
            }
            poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
            poseStack.mulPose(Axis.YN.rotationDegrees((float)(facing.get2DDataValue() * 90)));
            if (facing == Direction.SOUTH || facing == Direction.NORTH) {
                poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
            }
            for (int y = 3; y <= 12; ++y) {
                for (int x = 3; x <= 11; ++x) {
                    byte piecesIndex = data[Position.COORD_XY(x, y)];
                    if (CChessUtil.isRed(piecesIndex) || CChessUtil.isBlack(piecesIndex)) {
                        CChessPiecesModel chessPiecesModel = this.chessPiecesModels[piecesIndex];
                        chessPiecesModel.renderToBuffer(poseStack, piecesBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                        if (selectX == x && selectY == y) {
                            this.selectedModels.renderToBuffer(poseStack, piecesBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                        }
                    }
                    poseStack.translate(0.304, 0.0, 0.0);
                }
                poseStack.translate(-2.7359999999999998, 0.0, -0.304);
            }
            poseStack.popPose();
        }
    }

    private void renderChessboard(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Direction facing) {
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YN.rotationDegrees((float)(facing.get2DDataValue() * 90)));
        if (facing == Direction.SOUTH || facing == Direction.NORTH) {
            poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
        }
        VertexConsumer checkerBoardBuff = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        this.chessModel.renderToBuffer(poseStack, checkerBoardBuff, combinedLightIn, combinedOverlayIn);
        poseStack.popPose();
    }

    private boolean inRenderDistance(TileEntityCChess chess, int distance) {
        BlockPos pos = chess.getBlockPos();
        return this.dispatcher.camera.getPosition().distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) < (double)(distance * distance);
    }

    public boolean shouldRenderOffScreen(TileEntityCChess te) {
        return true;
    }
}

