/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.client.render.MaidRenderState;
import com.github.tartaricacid.touhoulittlemaid.client.model.StatueBaseModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapDecoder;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class TileEntityItemStackGarageKitRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/statue_base.png");
    private static StatueBaseModel BASE_MODEL;

    public TileEntityItemStackGarageKitRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
        BASE_MODEL = new StatueBaseModel(modelSet.bakeLayer(StatueBaseModel.LAYER));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(1.0, 0.5, 1.0);
        poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
        VertexConsumer buffer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        BASE_MODEL.renderToBuffer(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.popPose();
        CustomData data = ItemGarageKit.getMaidData(stack);
        ClientLevel world = Minecraft.getInstance().level;
        if (data.isEmpty() || world == null) {
            return;
        }
        EntityType.byString((String)((String)data.read((MapDecoder)Codec.STRING.fieldOf("id")).getOrThrow())).ifPresent(arg_0 -> this.lambda$renderByItem$0(stack, poseStack, bufferIn, combinedLightIn, data, (Level)world, arg_0));
    }

    private void renderEntity(ItemStack stack, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, CompoundTag data, Level world, EntityType<?> type) throws ExecutionException {
        Entity entity = type.equals(InitEntities.MAID.get()) ? (Entity)EntityCacheUtil.GARAGE_KIT_CACHE.get((Object)stack, () -> new EntityMaid(world)) : (Entity)EntityCacheUtil.ENTITY_CACHE.get(type, () -> {
            Entity e = type.create(world);
            return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
        });
        float renderItemScale = 1.0f;
        entity.load(data);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            EntityCacheUtil.clearMaidDataResidue(maid, true);
            if (data.contains("model_id", 8)) {
                String modelId = data.getString("model_id");
                renderItemScale = CustomPackLoader.MAID_MODELS.getModelRenderItemScale(modelId);
            }
            maid.renderState = MaidRenderState.GARAGE_KIT;
        }
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.scale(renderItemScale, renderItemScale, renderItemScale);
        poseStack.translate(1.0, 0.21328125, 1.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        EntityRenderDispatcher render = Minecraft.getInstance().getEntityRenderDispatcher();
        boolean isShowHitBox = render.shouldRenderHitBoxes();
        render.setRenderHitBoxes(false);
        RenderSystem.runAsFancy(() -> render.render(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, bufferIn, combinedLightIn));
        render.setRenderHitBoxes(isShowHitBox);
        poseStack.popPose();
    }

    private /* synthetic */ void lambda$renderByItem$0(ItemStack stack, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, CustomData data, Level world, EntityType type) {
        try {
            this.renderEntity(stack, poseStack, bufferIn, combinedLightIn, data.copyTag(), world, type);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

