/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.client.render.MaidRenderState;
import com.github.tartaricacid.touhoulittlemaid.client.model.StatueBaseModel;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class TileEntityStatueRenderer
implements BlockEntityRenderer<TileEntityStatue> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/statue_base.png");
    private final StatueBaseModel BASE_MODEL;

    public TileEntityStatueRenderer(BlockEntityRendererProvider.Context context) {
        this.BASE_MODEL = new StatueBaseModel(context.bakeLayer(StatueBaseModel.LAYER));
    }

    public void render(TileEntityStatue te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.isCoreBlock()) {
            return;
        }
        poseStack.pushPose();
        this.setTranslateAndPose(te, poseStack);
        poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
        VertexConsumer buffer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        this.BASE_MODEL.renderToBuffer(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.popPose();
        CompoundTag data = te.getExtraMaidData();
        ClientLevel world = Minecraft.getInstance().level;
        if (data == null || world == null) {
            return;
        }
        EntityType.byString((String)data.getString("id")).ifPresent(arg_0 -> this.lambda$render$0(te, poseStack, bufferIn, combinedLightIn, data, (Level)world, arg_0));
    }

    private void renderEntity(TileEntityStatue te, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, CompoundTag data, Level world, EntityType<?> type) throws ExecutionException {
        Entity entity;
        if (type.equals(InitEntities.MAID.get())) {
            long posId = te.getBlockPos().asLong();
            entity = (Entity)EntityCacheUtil.STATUE_CACHE.get((Object)posId, () -> new EntityMaid(world));
        } else {
            entity = (Entity)EntityCacheUtil.ENTITY_CACHE.get(type, () -> {
                Entity e = type.create(world);
                return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
            });
        }
        entity.load(data);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            EntityCacheUtil.clearMaidDataResidue(maid, true);
            maid.renderState = MaidRenderState.STATUE;
        }
        float size = te.getSize().getScale();
        float offset = 0.0f;
        if (te.getSize() == TileEntityStatue.Size.MIDDLE) {
            offset = 0.25f;
        } else if (te.getSize() == TileEntityStatue.Size.BIG) {
            offset = 0.33333334f;
        }
        poseStack.pushPose();
        poseStack.scale(size, size, size);
        poseStack.translate(0.5 / (double)size, 0.21328125, 0.5 / (double)size);
        switch (te.getFacing()) {
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            default: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        EntityRenderDispatcher render = Minecraft.getInstance().getEntityRenderDispatcher();
        boolean isShowHitBox = render.shouldRenderHitBoxes();
        render.setRenderHitBoxes(false);
        render.render(entity, (double)offset, 0.0, (double)(-offset), 0.0f, 0.0f, poseStack, bufferIn, combinedLightIn);
        render.setRenderHitBoxes(isShowHitBox);
        poseStack.popPose();
    }

    private void setTranslateAndPose(TileEntityStatue te, PoseStack poseStack) {
        float size = te.getSize().getScale();
        float offset = 0.0f;
        if (te.getSize() == TileEntityStatue.Size.MIDDLE) {
            offset = 0.25f;
        } else if (te.getSize() == TileEntityStatue.Size.BIG) {
            offset = 0.33333334f;
        }
        switch (te.getFacing()) {
            case EAST: {
                poseStack.translate(-offset * size, 0.0f, -offset * size);
                break;
            }
            case NORTH: {
                poseStack.translate(-offset * size, 0.0f, offset * size);
                break;
            }
            case WEST: {
                poseStack.translate(offset * size, 0.0f, offset * size);
                break;
            }
            case SOUTH: {
                poseStack.translate(offset * size, 0.0f, -offset * size);
                break;
            }
            default: {
                poseStack.translate(0.0f, 0.0f, 0.0f);
            }
        }
        poseStack.scale(size, size, size);
        poseStack.translate(0.5 / (double)size, 0.5, 0.5 / (double)size);
    }

    public AABB getRenderBoundingBox(TileEntityStatue te) {
        return RenderHelper.getAABB(te.getWorldPosition().offset(-5, -1, -5), te.getWorldPosition().offset(5, 10, 5));
    }

    private /* synthetic */ void lambda$render$0(TileEntityStatue te, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, CompoundTag data, Level world, EntityType type) {
        try {
            this.renderEntity(te, poseStack, bufferIn, combinedLightIn, data, world, type);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

