/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.cloth;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import java.nio.file.Path;
import java.util.SortedMap;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class GlobalAIIntegration {
    private static final String DEFAULT_LANGUAGE = "en_us";

    public static void aiChat(ConfigBuilder root, ConfigEntryBuilder entryBuilder) {
        ConfigCategory aiChat = root.getOrCreateCategory((Component)Component.translatable((String)"config.touhou_little_maid.global_ai"));
        aiChat.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.chat_enable"), ((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.chat_enable.tooltip")}).setSaveConsumer(value -> {
            AIConfig.CHAT_ENABLED.set(value);
            AIConfig.CHAT_ENABLED.save();
        }).build());
        aiChat.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.tts_enable"), ((Boolean)AIConfig.TTS_ENABLED.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.tts_enable.tooltip")}).setSaveConsumer(value -> {
            AIConfig.TTS_ENABLED.set(value);
            AIConfig.TTS_ENABLED.save();
        }).build());
        aiChat.addEntry((AbstractConfigListEntry)((DoubleFieldBuilder)entryBuilder.startDoubleField((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.chat_temperature"), ((Double)AIConfig.CHAT_TEMPERATURE.get()).doubleValue()).setDefaultValue((Object)((Double)AIConfig.CHAT_TEMPERATURE.getDefault()))).setMin(0.0).setMax(2.0).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.chat_temperature.tooltip")}).setSaveConsumer(value -> {
            AIConfig.CHAT_TEMPERATURE.set(value);
            AIConfig.CHAT_TEMPERATURE.save();
        }).build());
        aiChat.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.maid_max_history_chat_size"), ((Integer)AIConfig.MAID_MAX_HISTORY_CHAT_SIZE.get()).intValue(), 1, 128).setDefaultValue(16).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.maid_max_history_chat_size.tooltip")}).setSaveConsumer(value -> {
            AIConfig.MAID_MAX_HISTORY_CHAT_SIZE.set(value);
            AIConfig.MAID_MAX_HISTORY_CHAT_SIZE.save();
        }).build());
        SortedMap languages = Minecraft.getInstance().getLanguageManager().getLanguages();
        aiChat.addEntry((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.tts_language"), (String)AIConfig.TTS_LANGUAGE.get(), Component::literal, GlobalAIIntegration.cell(languages)).setSelections(languages.keySet()).setDefaultValue((Object)DEFAULT_LANGUAGE).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.tts_language.tooltip")}).setSaveConsumer(info -> {
            AIConfig.TTS_LANGUAGE.set(info);
            AIConfig.TTS_LANGUAGE.save();
        }).build());
        Path availableSiteFile = Utils.getConfigFolder().resolve("touhou_little_maid").resolve("available_sites.yml");
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_FILE, availableSiteFile.toString());
        MutableComponent text = Component.translatable((String)"config.touhou_little_maid.global_ai.chat_site.click");
        text.withStyle(s -> s.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE).withClickEvent(clickEvent));
        aiChat.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)text).build());
    }

    private static DropdownBoxEntry.SelectionCellCreator<String> cell(SortedMap<String, LanguageInfo> languages) {
        LanguageInfo defaultLanguage = (LanguageInfo)languages.get(DEFAULT_LANGUAGE);
        return new DropdownBoxEntry.DefaultSelectionCellCreator(i -> languages.getOrDefault(i, defaultLanguage).toComponent());
    }
}

