/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.cloth;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.AIChatScreen;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveMaidAIDataPackage;
import java.util.List;
import java.util.SortedMap;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

public class PartAIIntegration {
    private static final String DEFAULT_LANGUAGE = "en_us";

    public static ConfigBuilder getConfigBuilder(EntityMaid maid) {
        ConfigBuilder root = ConfigBuilder.create().setTitle((Component)Component.translatable((String)"config.touhou_little_maid.part_ai"));
        root.setGlobalized(true);
        root.setGlobalizedExpanded(false);
        ConfigEntryBuilder entryBuilder = root.entryBuilder();
        PartAIIntegration.init(root, entryBuilder, maid);
        root.setSavingRunnable(() -> PacketDistributor.sendToServer((CustomPacketPayload)new SaveMaidAIDataPackage(maid.getId(), maid.getAiChatManager()), (CustomPacketPayload[])new CustomPacketPayload[0]));
        return root;
    }

    public static void init(ConfigBuilder root, ConfigEntryBuilder entryBuilder, EntityMaid maid) {
        MaidAIChatManager manager = maid.getAiChatManager();
        ConfigCategory ai = root.getOrCreateCategory((Component)Component.translatable((String)"config.touhou_little_maid.part_ai"));
        ai.addEntry((AbstractConfigListEntry)entryBuilder.startTextField((Component)Component.translatable((String)"config.touhou_little_maid.part_ai.owner_name"), manager.getOwnerName()).setDefaultValue("").setSaveConsumer(manager::setOwnerName).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.part_ai.owner_name.tooltip")}).build());
        ai.addEntry((AbstractConfigListEntry)entryBuilder.startTextField((Component)Component.translatable((String)"config.touhou_little_maid.part_ai.custom_setting"), manager.getCustomSetting()).setDefaultValue("").setSaveConsumer(manager::setCustomSetting).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.part_ai.custom_setting.tooltip")}).build());
        String chatSiteName = manager.getChatSiteName();
        String defaultChatSiteName = AIChatScreen.CLIENT_CHAT_SITES.containsKey(chatSiteName) ? chatSiteName : "";
        DropdownBoxEntry chatSite = entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"config.touhou_little_maid.part_ai.chat_site_name"), defaultChatSiteName).setDefaultValue((Object)"").setSelections(AIChatScreen.CLIENT_CHAT_SITES.keySet()).setSaveConsumer(manager::setChatSiteName).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.part_ai.chat_site_name.tooltip")}).build();
        ai.addEntry((AbstractConfigListEntry)chatSite);
        for (String key : AIChatScreen.CLIENT_CHAT_SITES.keySet()) {
            String model;
            List<String> models = AIChatScreen.CLIENT_CHAT_SITES.get(key);
            String defaultModel = models.contains(model = manager.getChatModel()) ? model : "";
            ai.addEntry((AbstractConfigListEntry)((DropdownMenuBuilder)entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"config.touhou_little_maid.part_ai.chat_model"), defaultModel).setDefaultValue((Object)"").setSelections(models).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.part_ai.chat_model.tooltip")}).setSaveConsumer(result -> {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)chatSite.getValue())) && ((String)chatSite.getValue()).equals(key)) {
                    manager.setChatModel((String)result);
                }
            }).setDisplayRequirement(() -> StringUtils.isNotBlank((CharSequence)((CharSequence)chatSite.getValue())) && ((String)chatSite.getValue()).equals(key))).build());
        }
        double defaultTemperature = Math.max(manager.getChatTemperature(), 0.0);
        ai.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)Component.translatable((String)"config.touhou_little_maid.part_ai.chat_temperature"), defaultTemperature).setDefaultValue(0.5).setMin(0.0).setMax(2.0).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.part_ai.chat_temperature.tooltip")}).setSaveConsumer(manager::setChatTemperature).build());
        String ttsSiteName = manager.getTtsSiteName();
        String defaultTtsSiteName = AIChatScreen.CLIENT_TTS_SITES.containsKey(ttsSiteName) ? ttsSiteName : "";
        DropdownBoxEntry ttsSite = entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"config.touhou_little_maid.part_ai.tts_site_name"), defaultTtsSiteName).setDefaultValue((Object)"").setSelections(AIChatScreen.CLIENT_TTS_SITES.keySet()).setSaveConsumer(manager::setTtsSiteName).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.part_ai.tts_site_name.tooltip")}).build();
        ai.addEntry((AbstractConfigListEntry)ttsSite);
        for (String key : AIChatScreen.CLIENT_TTS_SITES.keySet()) {
            String model;
            List<String> models = AIChatScreen.CLIENT_TTS_SITES.get(key);
            String defaultModel = models.contains(model = manager.getTtsModel()) ? model : "";
            ai.addEntry((AbstractConfigListEntry)((DropdownMenuBuilder)entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"config.touhou_little_maid.part_ai.tts_model"), defaultModel).setDefaultValue((Object)"").setSelections(models).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.part_ai.tts_model.tooltip")}).setSaveConsumer(result -> {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)ttsSite.getValue())) && ((String)ttsSite.getValue()).equals(key)) {
                    manager.setTtsModel((String)result);
                }
            }).setDisplayRequirement(() -> StringUtils.isNotBlank((CharSequence)((CharSequence)ttsSite.getValue())) && ((String)ttsSite.getValue()).equals(key))).build());
        }
        SortedMap languages = Minecraft.getInstance().getLanguageManager().getLanguages();
        String defaultLanguage = StringUtils.isBlank((CharSequence)manager.getTtsLanguage()) ? DEFAULT_LANGUAGE : manager.getTtsLanguage();
        ai.addEntry((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"config.touhou_little_maid.part_ai.tts_language"), defaultLanguage, Component::literal, PartAIIntegration.cell(languages)).setSelections(languages.keySet()).setDefaultValue((Object)DEFAULT_LANGUAGE).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.part_ai.tts_language.tooltip")}).setSaveConsumer(manager::setTtsLanguage).build());
    }

    private static DropdownBoxEntry.SelectionCellCreator<String> cell(SortedMap<String, LanguageInfo> languages) {
        LanguageInfo defaultLanguage = (LanguageInfo)languages.get(DEFAULT_LANGUAGE);
        return new DropdownBoxEntry.DefaultSelectionCellCreator(i -> languages.getOrDefault(i, defaultLanguage).toComponent());
    }
}

