/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.embeddium;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoMesh;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import org.embeddedt.embeddium.api.vertex.buffer.VertexBufferWriter;
import org.embeddedt.embeddium.api.vertex.format.common.ModelVertex;
import org.embeddedt.embeddium.impl.render.vertex.VertexConsumerUtils;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

class EmbeddiumGeoRenderer {
    static Vector3f C000 = new Vector3f();
    static Vector3f C100 = new Vector3f();
    static Vector3f C110 = new Vector3f();
    static Vector3f C010 = new Vector3f();
    static Vector3f C001 = new Vector3f();
    static Vector3f C101 = new Vector3f();
    static Vector3f C111 = new Vector3f();
    static Vector3f C011 = new Vector3f();
    static Vector3f dx = new Vector3f();
    static Vector3f dy = new Vector3f();
    static Vector3f dz = new Vector3f();
    static Vector3f nx = new Vector3f();
    static Vector3f ny = new Vector3f();
    static Vector3f nz = new Vector3f();
    private static final long SCRATCH_BUFFER = MemoryUtil.nmemAlignedAlloc((long)64L, (long)864L);
    private static final MemoryStack STACK = MemoryStack.create();

    EmbeddiumGeoRenderer() {
    }

    private static int packUnsafe(float x, float y, float z) {
        int normX = (int)(x * 127.0f) & 0xFF;
        int normY = (int)(y * 127.0f) & 0xFF;
        int normZ = (int)(z * 127.0f) & 0xFF;
        return normZ << 16 | normY << 8 | normX;
    }

    static boolean renderCubesOfBone(AnimatedGeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog((VertexConsumer)buffer);
        if (writer == null) {
            return false;
        }
        if (bone.isHidden()) {
            return true;
        }
        if (bone.cubesAreHidden()) {
            return true;
        }
        GeoMesh mesh = bone.geoBone().cubes();
        int color = (int)(alpha * 255.0f) << 24 | (int)(blue * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(red * 255.0f);
        for (int i = 0; i < mesh.getCubeCount(); ++i) {
            boolean mirrored;
            Matrix4f pose = poseStack.last().pose();
            mesh.position(i).mulPosition((Matrix4fc)pose, C000);
            mesh.dx(i).mulDirection((Matrix4fc)pose, dx);
            mesh.dy(i).mulDirection((Matrix4fc)pose, dy);
            mesh.dz(i).mulDirection((Matrix4fc)pose, dz);
            C000.add((Vector3fc)dx, C100);
            C100.add((Vector3fc)dy, C110);
            C000.add((Vector3fc)dy, C010);
            C000.add((Vector3fc)dz, C001);
            C100.add((Vector3fc)dz, C101);
            C110.add((Vector3fc)dz, C111);
            C010.add((Vector3fc)dz, C011);
            dx.cross((Vector3fc)dy, nz).normalize();
            dy.cross((Vector3fc)dz, nx).normalize();
            dz.cross((Vector3fc)dx, ny).normalize();
            int faces = mesh.faces(i);
            boolean bl = mirrored = (faces & 0x40) != 0;
            if (RenderSystem.getModelViewMatrix().m32() == 0.0f) {
                if ((EmbeddiumGeoRenderer.C101.x + EmbeddiumGeoRenderer.C000.x) * EmbeddiumGeoRenderer.ny.x + (EmbeddiumGeoRenderer.C101.y + EmbeddiumGeoRenderer.C000.y) * EmbeddiumGeoRenderer.ny.y + (EmbeddiumGeoRenderer.C101.z + EmbeddiumGeoRenderer.C000.z) * EmbeddiumGeoRenderer.ny.z < 0.0f) {
                    faces &= 0xFFFFFFFE;
                }
                if ((EmbeddiumGeoRenderer.C110.x + EmbeddiumGeoRenderer.C011.x) * EmbeddiumGeoRenderer.ny.x + (EmbeddiumGeoRenderer.C110.y + EmbeddiumGeoRenderer.C011.y) * EmbeddiumGeoRenderer.ny.y + (EmbeddiumGeoRenderer.C110.z + EmbeddiumGeoRenderer.C011.z) * EmbeddiumGeoRenderer.ny.z > 0.0f) {
                    faces &= 0xFFFFFFFD;
                }
                if ((EmbeddiumGeoRenderer.C100.x + EmbeddiumGeoRenderer.C010.x) * EmbeddiumGeoRenderer.nz.x + (EmbeddiumGeoRenderer.C100.y + EmbeddiumGeoRenderer.C010.y) * EmbeddiumGeoRenderer.nz.y + (EmbeddiumGeoRenderer.C100.z + EmbeddiumGeoRenderer.C010.z) * EmbeddiumGeoRenderer.nz.z < 0.0f) {
                    faces &= 0xFFFFFFFB;
                }
                if ((EmbeddiumGeoRenderer.C001.x + EmbeddiumGeoRenderer.C111.x) * EmbeddiumGeoRenderer.nz.x + (EmbeddiumGeoRenderer.C001.y + EmbeddiumGeoRenderer.C111.y) * EmbeddiumGeoRenderer.nz.y + (EmbeddiumGeoRenderer.C001.z + EmbeddiumGeoRenderer.C111.z) * EmbeddiumGeoRenderer.nz.z > 0.0f) {
                    faces &= 0xFFFFFFF7;
                }
                if ((EmbeddiumGeoRenderer.C101.x + EmbeddiumGeoRenderer.C110.x) * EmbeddiumGeoRenderer.nx.x + (EmbeddiumGeoRenderer.C101.y + EmbeddiumGeoRenderer.C110.y) * EmbeddiumGeoRenderer.nx.y + (EmbeddiumGeoRenderer.C101.z + EmbeddiumGeoRenderer.C110.z) * EmbeddiumGeoRenderer.nx.z > 0.0f) {
                    faces &= mirrored ? -33 : -17;
                }
                if ((EmbeddiumGeoRenderer.C000.x + EmbeddiumGeoRenderer.C011.x) * EmbeddiumGeoRenderer.nx.x + (EmbeddiumGeoRenderer.C000.y + EmbeddiumGeoRenderer.C011.y) * EmbeddiumGeoRenderer.nx.y + (EmbeddiumGeoRenderer.C000.z + EmbeddiumGeoRenderer.C011.z) * EmbeddiumGeoRenderer.nx.z < 0.0f) {
                    faces &= mirrored ? -17 : -33;
                }
            } else {
                Matrix3f normal = poseStack.last().normal();
                mesh.dx(i).cross((Vector3fc)mesh.dy(i), nz);
                mesh.dy(i).cross((Vector3fc)mesh.dz(i), nx);
                mesh.dz(i).cross((Vector3fc)mesh.dx(i), ny);
                nx.mul((Matrix3fc)normal).normalize();
                ny.mul((Matrix3fc)normal).normalize();
                nz.mul((Matrix3fc)normal).normalize();
            }
            int normalPX = EmbeddiumGeoRenderer.packUnsafe(EmbeddiumGeoRenderer.nx.x, EmbeddiumGeoRenderer.nx.y, EmbeddiumGeoRenderer.nx.z);
            int normalPY = EmbeddiumGeoRenderer.packUnsafe(EmbeddiumGeoRenderer.ny.x, EmbeddiumGeoRenderer.ny.y, EmbeddiumGeoRenderer.ny.z);
            int normalPZ = EmbeddiumGeoRenderer.packUnsafe(EmbeddiumGeoRenderer.nz.x, EmbeddiumGeoRenderer.nz.y, EmbeddiumGeoRenderer.nz.z);
            int normalNX = EmbeddiumGeoRenderer.packUnsafe(-EmbeddiumGeoRenderer.nx.x, -EmbeddiumGeoRenderer.nx.y, -EmbeddiumGeoRenderer.nx.z);
            int normalNY = EmbeddiumGeoRenderer.packUnsafe(-EmbeddiumGeoRenderer.ny.z, -EmbeddiumGeoRenderer.ny.y, -EmbeddiumGeoRenderer.ny.z);
            int normalNZ = EmbeddiumGeoRenderer.packUnsafe(-EmbeddiumGeoRenderer.nz.x, -EmbeddiumGeoRenderer.nz.y, -EmbeddiumGeoRenderer.nz.z);
            long ptr = SCRATCH_BUFFER;
            int vertexCount = 0;
            if (!mirrored) {
                if ((faces & 1) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C101.x, EmbeddiumGeoRenderer.C101.y, EmbeddiumGeoRenderer.C101.z, color, mesh.downU0(i), mesh.downV1(i), packedOverlay, packedLight, normalNY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C001.x, EmbeddiumGeoRenderer.C001.y, EmbeddiumGeoRenderer.C001.z, color, mesh.downU1(i), mesh.downV1(i), packedOverlay, packedLight, normalNY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C000.x, EmbeddiumGeoRenderer.C000.y, EmbeddiumGeoRenderer.C000.z, color, mesh.downU1(i), mesh.downV0(i), packedOverlay, packedLight, normalNY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C100.x, EmbeddiumGeoRenderer.C100.y, EmbeddiumGeoRenderer.C100.z, color, mesh.downU0(i), mesh.downV0(i), packedOverlay, packedLight, normalNY);
                    ptr += 36L;
                    vertexCount += 4;
                }
                if ((faces & 2) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C110.x, EmbeddiumGeoRenderer.C110.y, EmbeddiumGeoRenderer.C110.z, color, mesh.upU0(i), mesh.upV1(i), packedOverlay, packedLight, normalPY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C010.x, EmbeddiumGeoRenderer.C010.y, EmbeddiumGeoRenderer.C010.z, color, mesh.upU1(i), mesh.upV1(i), packedOverlay, packedLight, normalPY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C011.x, EmbeddiumGeoRenderer.C011.y, EmbeddiumGeoRenderer.C011.z, color, mesh.upU1(i), mesh.upV0(i), packedOverlay, packedLight, normalPY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C111.x, EmbeddiumGeoRenderer.C111.y, EmbeddiumGeoRenderer.C111.z, color, mesh.upU0(i), mesh.upV0(i), packedOverlay, packedLight, normalPY);
                    ptr += 36L;
                    vertexCount += 4;
                }
                if ((faces & 4) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C100.x, EmbeddiumGeoRenderer.C100.y, EmbeddiumGeoRenderer.C100.z, color, mesh.northU0(i), mesh.northV1(i), packedOverlay, packedLight, normalNZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C000.x, EmbeddiumGeoRenderer.C000.y, EmbeddiumGeoRenderer.C000.z, color, mesh.northU1(i), mesh.northV1(i), packedOverlay, packedLight, normalNZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C010.x, EmbeddiumGeoRenderer.C010.y, EmbeddiumGeoRenderer.C010.z, color, mesh.northU1(i), mesh.northV0(i), packedOverlay, packedLight, normalNZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C110.x, EmbeddiumGeoRenderer.C110.y, EmbeddiumGeoRenderer.C110.z, color, mesh.northU0(i), mesh.northV0(i), packedOverlay, packedLight, normalNZ);
                    ptr += 36L;
                    vertexCount += 4;
                }
                if ((faces & 8) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C001.x, EmbeddiumGeoRenderer.C001.y, EmbeddiumGeoRenderer.C001.z, color, mesh.southU0(i), mesh.southV1(i), packedOverlay, packedLight, normalPZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C101.x, EmbeddiumGeoRenderer.C101.y, EmbeddiumGeoRenderer.C101.z, color, mesh.southU1(i), mesh.southV1(i), packedOverlay, packedLight, normalPZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C111.x, EmbeddiumGeoRenderer.C111.y, EmbeddiumGeoRenderer.C111.z, color, mesh.southU1(i), mesh.southV0(i), packedOverlay, packedLight, normalPZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C011.x, EmbeddiumGeoRenderer.C011.y, EmbeddiumGeoRenderer.C011.z, color, mesh.southU0(i), mesh.southV0(i), packedOverlay, packedLight, normalPZ);
                    ptr += 36L;
                    vertexCount += 4;
                }
                if ((faces & 0x10) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C101.x, EmbeddiumGeoRenderer.C101.y, EmbeddiumGeoRenderer.C101.z, color, mesh.eastU0(i), mesh.eastV1(i), packedOverlay, packedLight, normalPX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C100.x, EmbeddiumGeoRenderer.C100.y, EmbeddiumGeoRenderer.C100.z, color, mesh.eastU1(i), mesh.eastV1(i), packedOverlay, packedLight, normalPX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C110.x, EmbeddiumGeoRenderer.C110.y, EmbeddiumGeoRenderer.C110.z, color, mesh.eastU1(i), mesh.eastV0(i), packedOverlay, packedLight, normalPX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C111.x, EmbeddiumGeoRenderer.C111.y, EmbeddiumGeoRenderer.C111.z, color, mesh.eastU0(i), mesh.eastV0(i), packedOverlay, packedLight, normalPX);
                    ptr += 36L;
                    vertexCount += 4;
                }
                if ((faces & 0x20) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C000.x, EmbeddiumGeoRenderer.C000.y, EmbeddiumGeoRenderer.C000.z, color, mesh.westU0(i), mesh.westV1(i), packedOverlay, packedLight, normalNX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C001.x, EmbeddiumGeoRenderer.C001.y, EmbeddiumGeoRenderer.C001.z, color, mesh.westU1(i), mesh.westV1(i), packedOverlay, packedLight, normalNX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C011.x, EmbeddiumGeoRenderer.C011.y, EmbeddiumGeoRenderer.C011.z, color, mesh.westU1(i), mesh.westV0(i), packedOverlay, packedLight, normalNX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C010.x, EmbeddiumGeoRenderer.C010.y, EmbeddiumGeoRenderer.C010.z, color, mesh.westU0(i), mesh.westV0(i), packedOverlay, packedLight, normalNX);
                    ptr += 36L;
                    vertexCount += 4;
                }
            } else {
                if ((faces & 1) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C101.x, EmbeddiumGeoRenderer.C101.y, EmbeddiumGeoRenderer.C101.z, color, mesh.downU1(i), mesh.downV0(i), packedOverlay, packedLight, normalNY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C001.x, EmbeddiumGeoRenderer.C001.y, EmbeddiumGeoRenderer.C001.z, color, mesh.downU0(i), mesh.downV0(i), packedOverlay, packedLight, normalNY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C000.x, EmbeddiumGeoRenderer.C000.y, EmbeddiumGeoRenderer.C000.z, color, mesh.downU0(i), mesh.downV1(i), packedOverlay, packedLight, normalNY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C100.x, EmbeddiumGeoRenderer.C100.y, EmbeddiumGeoRenderer.C100.z, color, mesh.downU1(i), mesh.downV1(i), packedOverlay, packedLight, normalNY);
                    ptr += 36L;
                    vertexCount += 4;
                }
                if ((faces & 2) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C110.x, EmbeddiumGeoRenderer.C110.y, EmbeddiumGeoRenderer.C110.z, color, mesh.upU1(i), mesh.upV0(i), packedOverlay, packedLight, normalPY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C010.x, EmbeddiumGeoRenderer.C010.y, EmbeddiumGeoRenderer.C010.z, color, mesh.upU0(i), mesh.upV0(i), packedOverlay, packedLight, normalPY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C011.x, EmbeddiumGeoRenderer.C011.y, EmbeddiumGeoRenderer.C011.z, color, mesh.upU0(i), mesh.upV1(i), packedOverlay, packedLight, normalPY);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C111.x, EmbeddiumGeoRenderer.C111.y, EmbeddiumGeoRenderer.C111.z, color, mesh.upU1(i), mesh.upV1(i), packedOverlay, packedLight, normalPY);
                    ptr += 36L;
                    vertexCount += 4;
                }
                if ((faces & 4) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C100.x, EmbeddiumGeoRenderer.C100.y, EmbeddiumGeoRenderer.C100.z, color, mesh.northU1(i), mesh.northV0(i), packedOverlay, packedLight, normalNZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C000.x, EmbeddiumGeoRenderer.C000.y, EmbeddiumGeoRenderer.C000.z, color, mesh.northU0(i), mesh.northV0(i), packedOverlay, packedLight, normalNZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C010.x, EmbeddiumGeoRenderer.C010.y, EmbeddiumGeoRenderer.C010.z, color, mesh.northU0(i), mesh.northV1(i), packedOverlay, packedLight, normalNZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C110.x, EmbeddiumGeoRenderer.C110.y, EmbeddiumGeoRenderer.C110.z, color, mesh.northU1(i), mesh.northV1(i), packedOverlay, packedLight, normalNZ);
                    ptr += 36L;
                    vertexCount += 4;
                }
                if ((faces & 8) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C001.x, EmbeddiumGeoRenderer.C001.y, EmbeddiumGeoRenderer.C001.z, color, mesh.southU1(i), mesh.southV0(i), packedOverlay, packedLight, normalPZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C101.x, EmbeddiumGeoRenderer.C101.y, EmbeddiumGeoRenderer.C101.z, color, mesh.southU0(i), mesh.southV0(i), packedOverlay, packedLight, normalPZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C111.x, EmbeddiumGeoRenderer.C111.y, EmbeddiumGeoRenderer.C111.z, color, mesh.southU0(i), mesh.southV1(i), packedOverlay, packedLight, normalPZ);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C011.x, EmbeddiumGeoRenderer.C011.y, EmbeddiumGeoRenderer.C011.z, color, mesh.southU1(i), mesh.southV1(i), packedOverlay, packedLight, normalPZ);
                    ptr += 36L;
                    vertexCount += 4;
                }
                if ((faces & 0x10) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C101.x, EmbeddiumGeoRenderer.C101.y, EmbeddiumGeoRenderer.C101.z, color, mesh.westU1(i), mesh.westV0(i), packedOverlay, packedLight, normalNX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C100.x, EmbeddiumGeoRenderer.C100.y, EmbeddiumGeoRenderer.C100.z, color, mesh.westU0(i), mesh.westV0(i), packedOverlay, packedLight, normalNX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C110.x, EmbeddiumGeoRenderer.C110.y, EmbeddiumGeoRenderer.C110.z, color, mesh.westU0(i), mesh.westV1(i), packedOverlay, packedLight, normalNX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C111.x, EmbeddiumGeoRenderer.C111.y, EmbeddiumGeoRenderer.C111.z, color, mesh.westU1(i), mesh.westV1(i), packedOverlay, packedLight, normalNX);
                    ptr += 36L;
                    vertexCount += 4;
                }
                if ((faces & 0x20) != 0) {
                    EmbeddiumGeoRenderer.emitVertex(ptr, EmbeddiumGeoRenderer.C000.x, EmbeddiumGeoRenderer.C000.y, EmbeddiumGeoRenderer.C000.z, color, mesh.eastU1(i), mesh.eastV0(i), packedOverlay, packedLight, normalPX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C001.x, EmbeddiumGeoRenderer.C001.y, EmbeddiumGeoRenderer.C001.z, color, mesh.eastU0(i), mesh.eastV0(i), packedOverlay, packedLight, normalPX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C011.x, EmbeddiumGeoRenderer.C011.y, EmbeddiumGeoRenderer.C011.z, color, mesh.eastU0(i), mesh.eastV1(i), packedOverlay, packedLight, normalPX);
                    EmbeddiumGeoRenderer.emitVertex(ptr += 36L, EmbeddiumGeoRenderer.C010.x, EmbeddiumGeoRenderer.C010.y, EmbeddiumGeoRenderer.C010.z, color, mesh.eastU1(i), mesh.eastV1(i), packedOverlay, packedLight, normalPX);
                    ptr += 36L;
                    vertexCount += 4;
                }
            }
            EmbeddiumGeoRenderer.flush(writer, vertexCount);
        }
        return true;
    }

    private static void emitVertex(long ptr, float x, float y, float z, int color, float u, float v, int packedOverlay, int packedLight, int normal) {
        ModelVertex.write((long)ptr, (float)x, (float)y, (float)z, (int)color, (float)u, (float)v, (int)packedOverlay, (int)packedLight, (int)normal);
    }

    private static void flush(VertexBufferWriter writer, int vertexCount) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            writer.push(stack, SCRATCH_BUFFER, vertexCount, ModelVertex.FORMAT);
        }
    }
}

