/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.patchouli;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class AltarRecipeComponent
implements IComponentProcessor {
    private static final String RECIPE_ID = "recipe_id";
    private static final String INPUT = "input";
    private static final String POWER_COST = "power_cost";
    private static final String OUTPUT_ITEM = "output_item";
    private static final String OUTPUT_ENTITY = "output_entity";
    private static final String OUTPUT_DESC = "output_desc";
    @Nullable
    private AltarRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        ResourceLocation recipeId = ResourceLocation.parse((String)variables.get(RECIPE_ID, (HolderLookup.Provider)level.registryAccess()).asString());
        List allAltarRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)InitRecipes.ALTAR_CRAFTING.get());
        for (RecipeHolder recipe : allAltarRecipes) {
            if (!recipe.id().equals((Object)recipeId)) continue;
            this.recipe = (AltarRecipe)recipe.value();
            return;
        }
        this.recipe = new AltarRecipe("altar_recipe", CraftingBookCategory.MISC, (NonNullList<Ingredient>)NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[0]), 0.0f, ItemStack.EMPTY, ResourceLocation.withDefaultNamespace((String)"item"), "");
        TouhouLittleMaid.LOGGER.error("Altar recipe not found: {}", (Object)recipeId);
    }

    @Nullable
    public IVariable process(Level level, String key) {
        if (key.startsWith(INPUT)) {
            int index = Integer.parseInt(key.substring(INPUT.length())) - 1;
            if (index < 0 || index >= this.recipe.getIngredients().size()) {
                return IVariable.from((Object)ItemStack.EMPTY, (HolderLookup.Provider)level.registryAccess());
            }
            Ingredient ingredient = (Ingredient)this.recipe.getIngredients().get(index);
            ItemStack[] stacks = ingredient.getItems();
            if (stacks.length == 0) {
                return IVariable.from((Object)ItemStack.EMPTY, (HolderLookup.Provider)level.registryAccess());
            }
            ArrayList stackNames = Lists.newArrayList();
            for (ItemStack stack : stacks) {
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                stackNames.add(itemId.toString());
            }
            return IVariable.wrap((String)StringUtils.join((Iterable)stackNames, (String)","), (HolderLookup.Provider)level.registryAccess());
        }
        switch (key) {
            case "power_cost": {
                float powerCost = this.recipe.getPower();
                return IVariable.wrap((String)String.format("x%.2f", Float.valueOf(powerCost)), (HolderLookup.Provider)level.registryAccess());
            }
            case "output_item": {
                if (!this.recipe.isItemCraft()) {
                    return IVariable.from((Object)ItemStack.EMPTY, (HolderLookup.Provider)level.registryAccess());
                }
                return IVariable.from((Object)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()), (HolderLookup.Provider)level.registryAccess());
            }
            case "output_desc": {
                return IVariable.wrap((String)I18n.get((String)this.recipe.getLangKey(), (Object[])new Object[0]), (HolderLookup.Provider)level.registryAccess());
            }
            case "output_entity": {
                String entityId = this.recipe.getEntityType().toString();
                if ("touhou_little_maid:box".equals(entityId)) {
                    entityId = "touhou_little_maid:maid";
                }
                return IVariable.wrap((String)entityId, (HolderLookup.Provider)level.registryAccess());
            }
        }
        return null;
    }
}

