/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.ysm;

import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class YsmCompat {
    private static final String MOD_ID = "yes_steve_model";
    private static final VersionRange VERSION_RANGE;
    private static boolean INSTALLED;

    public static void init() {
        ModList.get().getModContainerById(MOD_ID).ifPresent(modContainer -> {
            ArtifactVersion version = modContainer.getModInfo().getVersion();
            INSTALLED = VERSION_RANGE.containsVersion(version) ? true : !FMLEnvironment.production;
        });
    }

    public static boolean isInstalled() {
        return INSTALLED;
    }

    public static YsmMaidInfo getYsmMaidInfo(CompoundTag maidData) {
        if (YsmCompat.isInstalled()) {
            boolean isYsmModel = maidData.getBoolean("IsYsmModel");
            String ysmModelId = maidData.getString("YsmModelId");
            String ysmTextureId = maidData.getString("YsmModelTexture");
            String ysmName = maidData.getString("YsmModelName");
            return new YsmMaidInfo(isYsmModel, ysmModelId, ysmTextureId, ysmName);
        }
        return YsmMaidInfo.EMPTY;
    }

    static {
        INSTALLED = false;
        try {
            VERSION_RANGE = VersionRange.createFromVersionSpec((String)"[2.3.3,)");
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }
}

