/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBox;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFilm;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class AltarRecipe
extends ShapelessRecipe {
    private final String group;
    private final CraftingBookCategory category;
    private final float power;
    private final ItemStack result;
    private final ResourceLocation entityType;
    private final String langKey;

    public AltarRecipe(String group, CraftingBookCategory category, NonNullList<Ingredient> ingredients, float power, ItemStack result, ResourceLocation entityType, String langKey) {
        super(group, category, result, ingredients);
        this.group = group;
        this.category = category;
        this.power = power;
        this.result = result;
        this.entityType = entityType;
        this.langKey = langKey;
    }

    public ResourceLocation getId() {
        return InitRecipes.ALTAR_CRAFTING.getId();
    }

    public String getRecipeString() {
        String recipeId = (String)this.result.get(InitDataComponent.RECIPES_ID_TAG);
        return Objects.requireNonNullElse(recipeId, "spawn_box");
    }

    public boolean isItemCraft() {
        return this.entityType.equals((Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ITEM));
    }

    public void spawnOutputEntity(ServerLevel world, BlockPos pos, @Nullable List<ItemStack> list) {
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.entityType);
        if (type == EntityType.ITEM) {
            this.spawnItem(world, pos);
            return;
        }
        if (type == InitEntities.BOX.get()) {
            this.spawnBoxMaid(world, pos);
            return;
        }
        if (type == InitEntities.MAID.get()) {
            this.rebornMaid(world, pos, list);
            return;
        }
        type.spawn(world, pos, MobSpawnType.STRUCTURE);
    }

    private void rebornMaid(ServerLevel world, BlockPos pos, @Nullable List<ItemStack> list) {
        ItemStack itemFilm = ItemStack.EMPTY;
        if (list != null) {
            itemFilm = list.stream().filter(stack -> stack.getItem() instanceof ItemFilm).findFirst().orElse(ItemStack.EMPTY);
        }
        EntityMaid maid = new EntityMaid((Level)world);
        CustomData compoundData = (CustomData)itemFilm.get(InitDataComponent.MAID_INFO);
        if (compoundData != null) {
            CompoundTag maidCompound = compoundData.copyTag();
            maid.readAdditionalSaveData(maidCompound);
        } else {
            maid.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(pos), MobSpawnType.SPAWN_EGG, null);
        }
        maid.setPos(pos.getX(), pos.getY(), pos.getZ());
        world.addFreshEntity((Entity)maid);
    }

    private void spawnBoxMaid(ServerLevel world, BlockPos pos) {
        EntityBox box = new EntityBox((Level)world);
        box.setPos(pos.getX(), pos.getY(), pos.getZ());
        EntityMaid maid = new EntityMaid((Level)world);
        maid.setPos(pos.getX(), pos.getY(), pos.getZ());
        maid.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(pos), MobSpawnType.SPAWN_EGG, null);
        maid.startRiding(box, true);
        world.tryAddFreshEntityWithPassengers((Entity)box);
    }

    private void spawnItem(ServerLevel world, BlockPos pos) {
        ItemEntity itemEntity = new ItemEntity((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.result.copy());
        world.addFreshEntity((Entity)itemEntity);
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)InitRecipes.ALTAR_CRAFTING.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)InitRecipes.ALTAR_RECIPE_SERIALIZER.get();
    }

    public float getPower() {
        return this.power;
    }

    public String getGroup() {
        return this.group;
    }

    public CraftingBookCategory getCategory() {
        return this.category;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ResourceLocation getEntityType() {
        return this.entityType;
    }

    public String getLangKey() {
        return this.langKey;
    }
}

