/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagItem;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EnchantmentKeys {
    public static final ResourceKey<Enchantment> IMPEDING = EnchantmentKeys.registerKey("impeding");
    public static final ResourceKey<Enchantment> SPEEDY = EnchantmentKeys.registerKey("speedy");
    public static final ResourceKey<Enchantment> ENDERS_ENDER = EnchantmentKeys.registerKey("enders_ender");

    private static ResourceKey<Enchantment> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocationUtil.getResourceLocation(name));
    }

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter damageTypes = context.lookup(Registries.DAMAGE_TYPE);
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter items = context.lookup(Registries.ITEM);
        HolderGetter blocks = context.lookup(Registries.BLOCK);
        EnchantmentKeys.register(context, IMPEDING, new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(TagItem.GOHEI_ENCHANTABLE), (int)4, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)8), (Enchantment.Cost)Enchantment.dynamicCost((int)15, (int)8), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        EnchantmentKeys.register(context, SPEEDY, new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(TagItem.GOHEI_ENCHANTABLE), (int)2, (int)2, (Enchantment.Cost)Enchantment.dynamicCost((int)15, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        EnchantmentKeys.register(context, ENDERS_ENDER, new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(TagItem.GOHEI_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)20), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
    }

    private static void register(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> key, Enchantment.Builder builder) {
        context.register(key, (Object)builder.build(key.location()));
    }

    public static int getEnchantmentLevel(RegistryAccess access, ResourceKey<Enchantment> enchantmentResourceKey, ItemStack mainHandItem) {
        return EnchantmentHelper.getTagEnchantmentLevel(EnchantmentKeys.getEnchantmentHolder(access, enchantmentResourceKey), (ItemStack)mainHandItem);
    }

    public static Holder<Enchantment> getEnchantmentHolder(RegistryAccess access, ResourceKey<Enchantment> enchantmentResourceKey) {
        return access.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantmentResourceKey);
    }
}

