/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.block.BlockMaidBed;
import com.github.tartaricacid.touhoulittlemaid.block.BlockScarecrow;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootTableGenerator {
    public static final ResourceKey<LootTable> ADDITIONAL_LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"chests/additional_loot_table"));
    public static final ResourceKey<LootTable> GIVE_SMART_SLAB = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"give_smart_slab"));
    public static final ResourceKey<LootTable> POWER_POINT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"advancement/power_point"));
    public static final ResourceKey<LootTable> CAKE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"advancement/cake"));

    public static class BlockLootTables
    extends BlockLootSubProvider {
        public final Set<Block> knownBlocks = new HashSet<Block>();

        public BlockLootTables(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.add((Block)InitBlocks.MAID_BED.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)BlockMaidBed.PART, (Comparable)BedPart.HEAD));
            this.add((Block)InitBlocks.SCARECROW.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)BlockScarecrow.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Block)InitBlocks.MODEL_SWITCHER.get());
            this.dropSelf((Block)InitBlocks.KEYBOARD.get());
            this.dropSelf((Block)InitBlocks.BOOKSHELF.get());
            this.dropSelf((Block)InitBlocks.COMPUTER.get());
            this.dropSelf((Block)InitBlocks.SHRINE.get());
        }

        public void add(Block block, LootTable.Builder builder) {
            this.knownBlocks.add(block);
            super.add(block, builder);
        }

        public Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }
    }

    public record AdvancementLootTables(HolderLookup.Provider provider) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(GIVE_SMART_SLAB, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(InitItems.SMART_SLAB_INIT))));
            consumer.accept(POWER_POINT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.POWER_POINT.get())))));
            consumer.accept(CAKE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CAKE))));
        }
    }

    public record ChestLootTables(HolderLookup.Provider provider) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(ADDITIONAL_LOOT_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().name("power_point").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.05f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(InitItems.POWER_POINT))).withPool(LootPool.lootPool().name("shrine").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.05f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(InitItems.SHRINE))));
        }
    }
}

