/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.debug;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class MaidDebugCommand {
    private static final String MAID_DEBUG_NAME = "debug";
    private static final String SPAWN_MAID = "spawn_maid";
    private static final String COUNT_NAME = "count";
    private static final String MODEL_ID = "model_id";
    private static final String SET_FARM = "set_farm";
    private static final String SIZE = "size";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder debug = Commands.literal((String)MAID_DEBUG_NAME);
        LiteralArgumentBuilder spawnMaid = Commands.literal((String)SPAWN_MAID);
        RequiredArgumentBuilder modelId = Commands.argument((String)MODEL_ID, (ArgumentType)StringArgumentType.string());
        RequiredArgumentBuilder count = Commands.argument((String)COUNT_NAME, (ArgumentType)IntegerArgumentType.integer((int)0));
        debug.then(spawnMaid.then(modelId.then(count.executes(MaidDebugCommand::spawnMaid))));
        LiteralArgumentBuilder setFarm = Commands.literal((String)SET_FARM);
        RequiredArgumentBuilder size = Commands.argument((String)SIZE, (ArgumentType)IntegerArgumentType.integer());
        debug.then(setFarm.then(size.executes(MaidDebugCommand::setFarm)));
        return debug;
    }

    private static int spawnMaid(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String modelId = StringArgumentType.getString(context, (String)MODEL_ID);
        int count = IntegerArgumentType.getInteger(context, (String)COUNT_NAME);
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                BlockPos blockPos = serverPlayer.blockPosition();
                int x = blockPos.getX() + i % 10 + 1;
                int z = blockPos.getZ() + i / 10 + 1;
                EntityMaid entityMaid = new EntityMaid(serverPlayer.level);
                entityMaid.setPos(x, blockPos.getY(), z);
                entityMaid.tame((Player)serverPlayer);
                entityMaid.setModelId(modelId);
                entityMaid.setInSittingPose(true);
                serverPlayer.level.addFreshEntity((Entity)entityMaid);
            }
        }
        return 1;
    }

    private static int setFarm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int size = IntegerArgumentType.getInteger(context, (String)SIZE);
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (size > 0) {
            BlockPos blockPos = serverPlayer.blockPosition();
            Level level = serverPlayer.level;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int x = -size; x < size; ++x) {
                for (int z = -size; z < size; ++z) {
                    BlockPos.MutableBlockPos pos = mutableBlockPos.setWithOffset((Vec3i)blockPos, x, -1, z);
                    if (x % 5 == 0 && z % 5 == 0) {
                        level.setBlockAndUpdate((BlockPos)pos, Blocks.WATER.defaultBlockState());
                        level.setBlockAndUpdate((BlockPos)pos.move(Direction.UP), Blocks.LILY_PAD.defaultBlockState());
                        continue;
                    }
                    level.setBlockAndUpdate((BlockPos)pos, (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)));
                    level.setBlockAndUpdate((BlockPos)pos.move(Direction.UP), (BlockState)Blocks.WHEAT.defaultBlockState().setValue((Property)CropBlock.AGE, (Comparable)Integer.valueOf(7)));
                }
            }
        }
        return 1;
    }
}

