/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.ride;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;

public class MaidRideBegTask
extends Behavior<EntityMaid> {
    private static final int BEG_DISTANCE = 6;

    public MaidRideBegTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return owner.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).map(list -> list.find(arg_0 -> ((EntityMaid)owner).isOwnedBy(arg_0)).filter(LivingEntity::isAlive).filter(e -> e.closerThan((Entity)owner, 6.0)).filter(e -> owner.isWithinRestriction(e.blockPosition())).anyMatch(e -> this.holdTemptationItem(owner, (LivingEntity)e))).orElse(false);
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }

    protected void tick(ServerLevel worldIn, EntityMaid maid, long gameTime) {
        LivingEntity owner = maid.getOwner();
        if (owner instanceof Player) {
            BehaviorUtils.lookAtEntity((LivingEntity)maid, (LivingEntity)owner);
            maid.setBegging(true);
        }
    }

    protected void stop(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setBegging(false);
    }

    private boolean holdTemptationItem(EntityMaid owner, LivingEntity e) {
        return owner.getTemptationItem().test(e.getMainHandItem());
    }
}

