/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class MaidBreathAirTask
extends Behavior<EntityMaid> {
    private static final int MAX_PROBABILITY = 5;
    private static final int AIR_SEARCH_RANGE = 16;

    public MaidBreathAirTask() {
        super((Map)ImmutableMap.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        BlockPos target;
        if (maid.getSwimManager().isEatBreatheItem()) {
            return false;
        }
        if (maid.getSwimManager().isGoingToBreath() && maid.getBrain().hasMemoryValue(MemoryModuleType.WALK_TARGET) && this.givesAir(maid, target = ((WalkTarget)maid.getBrain().getMemory(MemoryModuleType.WALK_TARGET).get()).getTarget().currentBlockPosition()) && (!maid.getNavigation().isDone() || maid.blockPosition().distManhattan((Vec3i)target) <= 1)) {
            return false;
        }
        if (maid.getAirSupply() >= 100) {
            return false;
        }
        if (MobEffectUtil.hasWaterBreathing((LivingEntity)maid)) {
            return false;
        }
        if (this.hasDrownBauble(maid)) {
            return false;
        }
        return !maid.isUsingItem();
    }

    protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
        if (this.eatBreatheItem(maid)) {
            return;
        }
        this.findAirPosition(level, maid);
    }

    private boolean hasDrownBauble(EntityMaid maid) {
        BaubleItemHandler maidBauble = maid.getMaidBauble();
        for (int i = 0; i < maidBauble.getSlots(); ++i) {
            if (!maidBauble.getStackInSlot(i).is((Item)InitItems.DROWN_PROTECT_BAUBLE.get())) continue;
            return true;
        }
        return false;
    }

    private boolean eatBreatheItem(EntityMaid maid) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemInHand = maid.getItemInHand(hand);
            if (itemInHand.isEmpty() || !this.isBreatheFood(maid, itemInHand)) continue;
            this.startEatBreatheItem(maid, itemInHand, hand);
            return true;
        }
        InteractionHand eanHand = InteractionHand.OFF_HAND;
        for (InteractionHand hand : InteractionHand.values()) {
            if (!maid.getItemInHand(hand).isEmpty()) continue;
            eanHand = hand;
            break;
        }
        ItemStack itemInHand = maid.getItemInHand(eanHand);
        boolean hasFood = false;
        RangedWrapper backpackInv = maid.getAvailableBackpackInv();
        for (int i = 0; i < backpackInv.getSlots(); ++i) {
            ItemStack stack = backpackInv.getStackInSlot(i);
            if (stack.isEmpty() || !this.isBreatheFood(maid, stack)) continue;
            ItemStack foodStack = backpackInv.extractItem(i, backpackInv.getStackInSlot(i).getCount(), false);
            ItemStack handStack = itemInHand.copy();
            maid.setItemInHand(eanHand, foodStack);
            maid.memoryHandItemStack(handStack);
            itemInHand = maid.getItemInHand(eanHand);
            hasFood = true;
            break;
        }
        if (hasFood) {
            this.startEatBreatheItem(maid, itemInHand, eanHand);
        }
        return hasFood;
    }

    private void startEatBreatheItem(EntityMaid maid, ItemStack stack, InteractionHand hand) {
        maid.getSwimManager().setEatBreatheItem(true);
        FoodProperties foodProperties = stack.getFoodProperties((LivingEntity)maid);
        float total = 0.0f;
        if (foodProperties != null) {
            int nutrition = foodProperties.nutrition();
            float saturationModifier = foodProperties.saturation();
            total = (float)nutrition + (float)nutrition * saturationModifier * 2.0f;
        }
        maid.startUsingItem(hand);
        if ((float)maid.getRandom().nextInt(5) < total) {
            float healCount = Math.max(total / 5.0f, 1.0f);
            maid.heal(healCount);
            NetworkHandler.sendToNearby((Entity)maid, new SpawnParticlePackage(maid.getId(), SpawnParticlePackage.Type.HEAL, stack.getUseDuration((LivingEntity)maid)));
        }
    }

    private boolean isBreatheFood(EntityMaid maid, ItemStack stack) {
        if (stack.getItem() instanceof PotionItem) {
            PotionContents mobEffects = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (mobEffects == null || !mobEffects.hasEffects()) {
                return false;
            }
            for (MobEffectInstance effect : mobEffects.getAllEffects()) {
                if (effect.getEffect() != MobEffects.WATER_BREATHING) continue;
                return true;
            }
            return false;
        }
        FoodProperties foodProperties = stack.getFoodProperties((LivingEntity)maid);
        if (foodProperties == null) {
            return false;
        }
        List effects = foodProperties.effects();
        if (effects.isEmpty()) {
            return false;
        }
        for (FoodProperties.PossibleEffect effect : effects) {
            if (effect.effect().getEffect() != MobEffects.WATER_BREATHING) continue;
            return true;
        }
        return false;
    }

    private void findAirPosition(ServerLevel level, EntityMaid maid) {
        if (!maid.canBrainMoving()) {
            return;
        }
        NodeEvaluator nodeEvaluator = maid.getNavigation().getNodeEvaluator();
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(nodeEvaluator, level, maid, 16.0f, 16);
        Optional<BlockPos> match = pathFinding.find(blockPos -> this.givesAir(maid, (BlockPos)blockPos));
        pathFinding.finish();
        if (match.isPresent() && maid.canPathReach(match.get())) {
            maid.getSwimManager().setGoingToBreath(true);
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)match.get(), (float)0.5f, (int)1);
            return;
        }
        BlockPos.MutableBlockPos seaLevelPos = maid.blockPosition().mutable().setY(level.getSeaLevel() + 1);
        if (this.givesAir(maid, (BlockPos)seaLevelPos) && maid.canPathReach((BlockPos)seaLevelPos)) {
            maid.getSwimManager().setGoingToBreath(true);
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)seaLevelPos, (float)0.5f, (int)1);
            return;
        }
        int seaLevelOffset = 2;
        Iterable canBreathPos = BlockPos.betweenClosed((int)(seaLevelPos.getX() - 2), (int)seaLevelPos.getY(), (int)(seaLevelPos.getZ() - 2), (int)(seaLevelPos.getX() + 2), (int)seaLevelPos.getY(), (int)(seaLevelPos.getZ() + 2));
        for (BlockPos canBreathPo : canBreathPos) {
            if (!this.givesAir(maid, canBreathPo) || !maid.canPathReach(canBreathPo)) continue;
            maid.getSwimManager().setGoingToBreath(true);
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)canBreathPo, (float)0.5f, (int)1);
            return;
        }
    }

    private boolean givesAir(EntityMaid maid, BlockPos pos) {
        Level level = maid.level;
        BlockState blockState = level.getBlockState(pos);
        boolean noFluid = level.getFluidState(pos).isEmpty() || blockState.is(Blocks.BUBBLE_COLUMN);
        return noFluid && !blockState.isCollisionShapeFullBlock((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
    }
}

