/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class MaidCollectHoneyTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 100;
    private final float speed;
    private final int closeEnoughDist;

    public MaidCollectHoneyTask(float speed, int closeEnoughDist) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, InitEntities.TARGET_POS.get(), (Object)MemoryStatus.VALUE_ABSENT));
        this.speed = speed;
        this.closeEnoughDist = closeEnoughDist;
        this.setMaxCheckRate(100);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid) && maid.canBrainMoving()) {
            BlockPos beehivePos = this.findBeehive(worldIn, maid);
            if (beehivePos != null && maid.isWithinRestriction(beehivePos)) {
                if (beehivePos.distToCenterSqr((Position)maid.position()) < Math.pow(this.closeEnoughDist, 2.0)) {
                    maid.getBrain().setMemory(InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker(beehivePos));
                    return true;
                }
                BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)beehivePos, (float)this.speed, (int)1);
                this.setNextCheckTickCount(5);
            } else {
                maid.getBrain().eraseMemory(InitEntities.TARGET_POS.get());
            }
        }
        return false;
    }

    protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
        maid.getBrain().getMemory(InitEntities.TARGET_POS.get()).ifPresent(target -> {
            BlockPos hivePos = target.currentBlockPosition();
            BlockState hiveBlockState = level.getBlockState(hivePos);
            if ((Integer)hiveBlockState.getValue((Property)BeehiveBlock.HONEY_LEVEL) < 5) {
                return;
            }
            CombinedInvWrapper maidAvailableInv = maid.getAvailableInv(true);
            if (!this.collectHoneyComb(level, maid, maidAvailableInv, hiveBlockState, hivePos)) {
                this.collectHoneyBottle(level, maid, maidAvailableInv, hiveBlockState, hivePos);
            }
        });
        maid.getBrain().eraseMemory(InitEntities.TARGET_POS.get());
        maid.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        maid.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    private void collectHoneyBottle(ServerLevel level, EntityMaid maid, CombinedInvWrapper maidAvailableInv, BlockState hiveBlockState, BlockPos hivePos) {
        ItemStack bottle = ItemsUtil.getStack((IItemHandler)maidAvailableInv, stack -> stack.is(Items.GLASS_BOTTLE));
        if (!bottle.isEmpty()) {
            ItemStack honeyBottle = new ItemStack((ItemLike)Items.HONEY_BOTTLE);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyBottle, (boolean)true);
            if (!result.isEmpty()) {
                return;
            }
            bottle.shrink(1);
            level.playSound(null, maid.getX(), maid.getY(), maid.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyBottle, (boolean)false);
            this.resetHoneyLevel((Level)level, hiveBlockState, hivePos);
            maid.swing(InteractionHand.MAIN_HAND);
        }
    }

    private boolean collectHoneyComb(ServerLevel level, EntityMaid maid, CombinedInvWrapper maidAvailableInv, BlockState hiveBlockState, BlockPos hivePos) {
        boolean hasShears = maid.getMainHandItem().canPerformAction(ItemAbilities.SHEARS_HARVEST);
        if (hasShears) {
            ItemStack honeyComb = new ItemStack((ItemLike)Items.HONEYCOMB, 3);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyComb, (boolean)true);
            if (!result.isEmpty()) {
                return false;
            }
            level.playSound(null, maid.getX(), maid.getY(), maid.getZ(), SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyComb, (boolean)false);
            this.resetHoneyLevel((Level)level, hiveBlockState, hivePos);
            maid.swing(InteractionHand.MAIN_HAND);
            maid.getMainHandItem().hurtAndBreak(1, (LivingEntity)maid, EquipmentSlot.MAINHAND);
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos findBeehive(ServerLevel world, EntityMaid maid) {
        BlockPos blockPos = maid.getBrainSearchPos();
        PoiManager poiManager = world.getPoiManager();
        int range = (int)maid.getRestrictRadius();
        return poiManager.getInRange(type -> type.is(PoiTypeTags.BEE_HOME), blockPos, range, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(pos -> this.canCollectHoney(world, (BlockPos)pos)).min(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)maid.blockPosition()))).orElse(null);
    }

    private boolean canCollectHoney(ServerLevel world, BlockPos hivePos) {
        return (Integer)world.getBlockState(hivePos).getValue((Property)BeehiveBlock.HONEY_LEVEL) >= 5;
    }

    public void resetHoneyLevel(Level level, BlockState state, BlockPos pos) {
        level.setBlock(pos, (BlockState)state.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(0)), 3);
    }
}

