/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class MaidFeedAnimalTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private final int maxAnimalCount;
    private Animal feedEntity = null;

    public MaidFeedAnimalTask(float speedModifier, int maxAnimalCount) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.maxAnimalCount = maxAnimalCount;
        this.setMaxCheckRate(12);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.feedEntity = null;
        long animalCount = this.getEntities(maid).find(e -> maid.isWithinRestriction(e.blockPosition())).filter(Entity::isAlive).filter(e -> e instanceof Animal).count();
        if (animalCount < (long)this.maxAnimalCount) {
            this.getEntities(maid).find(e -> maid.isWithinRestriction(e.blockPosition())).filter(Entity::isAlive).filter(e -> e instanceof Animal).filter(e -> ((Animal)e).getAge() == 0).filter(e -> ((Animal)e).canFallInLove()).filter(e -> ItemsUtil.isStackIn((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((Animal)((Animal)e)).isFood(arg_0))).filter(maid::canPathReach).findFirst().ifPresent(e -> {
                this.feedEntity = (Animal)e;
                BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
            });
            if (this.feedEntity != null && this.feedEntity.closerThan((Entity)maid, 2.0)) {
                ItemStack food = ItemsUtil.getStack((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((Animal)this.feedEntity).isFood(arg_0));
                if (!food.isEmpty()) {
                    food.shrink(1);
                    maid.swing(InteractionHand.MAIN_HAND);
                    this.feedEntity.setInLove(null);
                    LivingEntity livingEntity = maid.getOwner();
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                        ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "maid_feed_animal");
                    }
                }
                this.feedEntity = null;
            }
        } else {
            ChatBubbleManger.addInnerChatText(maid, "chat_bubble.touhou_little_maid.inner.feed_animal.max_number");
        }
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
    }
}

