/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.FenceGateBlockAccessor;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class MaidInteractWithDoor {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 3;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 8.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;

    public static BehaviorControl<LivingEntity> create() {
        MutableObject mutableObject = new MutableObject();
        MutableInt mutableInt = new MutableInt();
        return BehaviorBuilder.create(instance -> instance.group((App)instance.present(MemoryModuleType.PATH), (App)instance.registered(MemoryModuleType.DOORS_TO_CLOSE), (App)instance.registered(MemoryModuleType.NEAREST_LIVING_ENTITIES)).apply((Applicative)instance, (pathMemory, doorToCloseMemory, livingEntityMemory) -> (serverLevel, entity, time) -> {
            Path path = (Path)instance.get(pathMemory);
            Optional<Set<GlobalPos>> doorToClosePos = instance.tryGet(doorToCloseMemory);
            if (!path.notStarted() && !path.isDone()) {
                EntityMaid maid;
                EntityMaid maid2;
                if (Objects.equals(mutableObject.getValue(), path.getNextNode())) {
                    mutableInt.setValue(3);
                } else if (mutableInt.decrementAndGet() > 0) {
                    return false;
                }
                boolean canOpenDoor = entity instanceof EntityMaid && (maid2 = (EntityMaid)entity).getConfigManager().isOpenDoor();
                boolean canOpenFenceGate = entity instanceof EntityMaid && (maid = (EntityMaid)entity).getConfigManager().isOpenFenceGate();
                mutableObject.setValue((Object)path.getNextNode());
                Node previousNode = path.getPreviousNode();
                Node nextNode = path.getNextNode();
                BlockPos previousNodeBlockPos = previousNode.asBlockPos();
                BlockState previousNodeBlockState = serverLevel.getBlockState(previousNodeBlockPos);
                if (canOpenDoor && previousNodeBlockState.is(BlockTags.WOODEN_DOORS, stateBase -> stateBase.getBlock() instanceof DoorBlock)) {
                    DoorBlock doorBlock = (DoorBlock)previousNodeBlockState.getBlock();
                    if (!doorBlock.isOpen(previousNodeBlockState)) {
                        doorBlock.setOpen((Entity)entity, (Level)serverLevel, previousNodeBlockState, previousNodeBlockPos, true);
                    }
                    doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>>)doorToCloseMemory, doorToClosePos, serverLevel, previousNodeBlockPos);
                } else if (canOpenFenceGate && previousNodeBlockState.is(BlockTags.FENCE_GATES, stateBase -> stateBase.getBlock() instanceof FenceGateBlock)) {
                    if (!((Boolean)previousNodeBlockState.getValue((Property)FenceGateBlock.OPEN)).booleanValue()) {
                        MaidInteractWithDoor.setFenceGate((Entity)entity, (Level)serverLevel, previousNodeBlockState, previousNodeBlockPos, true);
                    }
                    doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>>)doorToCloseMemory, doorToClosePos, serverLevel, previousNodeBlockPos);
                }
                BlockPos nextNodeBlockPos = nextNode.asBlockPos();
                BlockState nextNodeBlockState = serverLevel.getBlockState(nextNodeBlockPos);
                if (canOpenDoor && nextNodeBlockState.is(BlockTags.WOODEN_DOORS, stateBase -> stateBase.getBlock() instanceof DoorBlock)) {
                    DoorBlock doorBlock = (DoorBlock)nextNodeBlockState.getBlock();
                    if (!doorBlock.isOpen(nextNodeBlockState)) {
                        doorBlock.setOpen((Entity)entity, (Level)serverLevel, nextNodeBlockState, nextNodeBlockPos, true);
                        doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>>)doorToCloseMemory, doorToClosePos, serverLevel, nextNodeBlockPos);
                    }
                } else if (canOpenFenceGate && nextNodeBlockState.is(BlockTags.FENCE_GATES, stateBase -> stateBase.getBlock() instanceof FenceGateBlock) && !((Boolean)nextNodeBlockState.getValue((Property)FenceGateBlock.OPEN)).booleanValue()) {
                    MaidInteractWithDoor.setFenceGate((Entity)entity, (Level)serverLevel, nextNodeBlockState, nextNodeBlockPos, true);
                    doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>>)doorToCloseMemory, doorToClosePos, serverLevel, nextNodeBlockPos);
                }
                doorToClosePos.ifPresent(doorPos -> MaidInteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(serverLevel, entity, previousNode, nextNode, doorPos, instance.tryGet(livingEntityMemory)));
                return true;
            }
            return false;
        }));
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(ServerLevel serverLevel, LivingEntity entity, @Nullable Node previous, @Nullable Node next, Set<GlobalPos> doorPositions, Optional<List<LivingEntity>> nearestLivingEntities) {
        Iterator<GlobalPos> doorPosIterator = doorPositions.iterator();
        while (doorPosIterator.hasNext()) {
            GlobalPos globalPos = doorPosIterator.next();
            BlockPos blockPos = globalPos.pos();
            if (previous != null && previous.asBlockPos().equals((Object)blockPos) && (next == null || !entity.blockPosition().equals((Object)next.asBlockPos())) || next != null && next.asBlockPos().equals((Object)blockPos)) continue;
            if (MaidInteractWithDoor.isDoorTooFarAway(serverLevel, entity, globalPos)) {
                doorPosIterator.remove();
                continue;
            }
            BlockState blockstate = serverLevel.getBlockState(blockPos);
            if (blockstate.is(BlockTags.WOODEN_DOORS, stateBase -> stateBase.getBlock() instanceof DoorBlock)) {
                DoorBlock doorblock = (DoorBlock)blockstate.getBlock();
                if (!doorblock.isOpen(blockstate)) {
                    doorPosIterator.remove();
                    continue;
                }
                if (MaidInteractWithDoor.areOtherMobsComingThroughDoor(entity, blockPos, nearestLivingEntities)) {
                    doorPosIterator.remove();
                    continue;
                }
                doorblock.setOpen((Entity)entity, (Level)serverLevel, blockstate, blockPos, false);
                doorPosIterator.remove();
                continue;
            }
            if (blockstate.is(BlockTags.FENCE_GATES, stateBase -> stateBase.getBlock() instanceof FenceGateBlock)) {
                if (!((Boolean)blockstate.getValue((Property)FenceGateBlock.OPEN)).booleanValue()) {
                    doorPosIterator.remove();
                    continue;
                }
                if (MaidInteractWithDoor.areOtherMobsComingThroughDoor(entity, blockPos, nearestLivingEntities)) {
                    doorPosIterator.remove();
                    continue;
                }
                MaidInteractWithDoor.setFenceGate((Entity)entity, (Level)serverLevel, blockstate, blockPos, false);
                continue;
            }
            doorPosIterator.remove();
        }
    }

    private static boolean areOtherMobsComingThroughDoor(LivingEntity entity, BlockPos pos, Optional<List<LivingEntity>> nearestLivingEntities) {
        return nearestLivingEntities.map(entities -> entities.stream().filter(livingEntity -> livingEntity.getType() == entity.getType()).filter(livingEntity -> pos.closerToCenterThan((Position)livingEntity.position(), 2.0)).anyMatch(livingEntity -> MaidInteractWithDoor.isMobComingThroughDoor(livingEntity.getBrain(), pos))).orElse(false);
    }

    private static boolean isMobComingThroughDoor(Brain<?> brain, BlockPos pos) {
        if (!brain.hasMemoryValue(MemoryModuleType.PATH)) {
            return false;
        }
        Path path = (Path)brain.getMemory(MemoryModuleType.PATH).get();
        if (path.isDone()) {
            return false;
        }
        Node previousNode = path.getPreviousNode();
        if (previousNode == null) {
            return false;
        }
        Node nextNode = path.getNextNode();
        return pos.equals((Object)previousNode.asBlockPos()) || pos.equals((Object)nextNode.asBlockPos());
    }

    private static boolean isDoorTooFarAway(ServerLevel level, LivingEntity entity, GlobalPos pos) {
        return pos.dimension() != level.dimension() || !pos.pos().closerToCenterThan((Position)entity.position(), 8.0);
    }

    private static Optional<Set<GlobalPos>> rememberDoorToClose(MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>> doorsToClose, Optional<Set<GlobalPos>> doorPositions, ServerLevel level, BlockPos blockPos) {
        GlobalPos globalPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)blockPos);
        return Optional.of(doorPositions.map(pos -> {
            pos.add(globalPos);
            return pos;
        }).orElseGet(() -> {
            HashSet posSet = Sets.newHashSet((Object[])new GlobalPos[]{globalPos});
            doorsToClose.set((Object)posSet);
            return posSet;
        }));
    }

    private static void setFenceGate(@Nullable Entity entity, Level serverLevel, BlockState blockstate, BlockPos blockPos, boolean isOpen) {
        serverLevel.setBlock(blockPos, (BlockState)blockstate.setValue((Property)FenceGateBlock.OPEN, (Comparable)Boolean.valueOf(isOpen)), 10);
        Block block = blockstate.getBlock();
        if (block instanceof FenceGateBlockAccessor) {
            FenceGateBlockAccessor fenceGateBlock = (FenceGateBlockAccessor)block;
            SoundEvent openSound = fenceGateBlock.tlmOpenSound();
            SoundEvent closeSound = fenceGateBlock.tlmCloseSound();
            serverLevel.playSound(entity, blockPos, isOpen ? openSound : closeSound, SoundSource.BLOCKS, 1.0f, serverLevel.getRandom().nextFloat() * 0.1f + 0.9f);
        }
        serverLevel.gameEvent(entity, (Holder)(isOpen ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), blockPos);
    }
}

