/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.IdF;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import org.jetbrains.annotations.NotNull;

public class MaidRangedWalkToTarget {
    public static BehaviorControl<EntityMaid> create(float speedModifier) {
        return MaidRangedWalkToTarget.create(entity -> Float.valueOf(speedModifier));
    }

    public static BehaviorControl<EntityMaid> create(Function<LivingEntity, Float> speedModifier) {
        return BehaviorBuilder.create((T maidInstance) -> maidInstance.group((App)maidInstance.registered(MemoryModuleType.WALK_TARGET), (App)maidInstance.registered(MemoryModuleType.LOOK_TARGET), (App)maidInstance.present(MemoryModuleType.ATTACK_TARGET), (App)maidInstance.registered(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)maidInstance, (walkTargetMemory, positionMemory, entityMemory, livingEntitiesMemory) -> MaidRangedWalkToTarget.setTarget(speedModifier, (BehaviorBuilder.Instance<EntityMaid>)maidInstance, (MemoryAccessor<OptionalBox.Mu, WalkTarget>)walkTargetMemory, (MemoryAccessor<OptionalBox.Mu, PositionTracker>)positionMemory, (MemoryAccessor<IdF.Mu, LivingEntity>)entityMemory, (MemoryAccessor<OptionalBox.Mu, NearestVisibleLivingEntities>)livingEntitiesMemory)));
    }

    @NotNull
    private static Trigger<EntityMaid> setTarget(Function<LivingEntity, Float> speedModifier, BehaviorBuilder.Instance<EntityMaid> maidInstance, MemoryAccessor<OptionalBox.Mu, WalkTarget> walkTargetMemory, MemoryAccessor<OptionalBox.Mu, PositionTracker> positionMemory, MemoryAccessor<IdF.Mu, LivingEntity> entityMemory, MemoryAccessor<OptionalBox.Mu, NearestVisibleLivingEntities> livingEntitiesMemory) {
        return (level, maid, gameTime) -> {
            LivingEntity target = (LivingEntity)maidInstance.get(entityMemory);
            if (maid.canSee(target) && MaidRangedWalkToTarget.isWithinRestriction(maid, target)) {
                walkTargetMemory.erase();
            } else {
                positionMemory.set((Object)new EntityTracker((Entity)target, true));
                walkTargetMemory.set((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)target, false), ((Float)speedModifier.apply(maid)).floatValue(), 0));
            }
            return true;
        };
    }

    private static boolean isWithinRestriction(EntityMaid maid, LivingEntity target) {
        float restrictRadius = maid.getRestrictRadius() * 0.65f;
        return target.distanceTo((Entity)maid) < restrictRadius;
    }
}

