/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;

public class MaidUpdateActivityFromSchedule
extends Behavior<EntityMaid> {
    private Activity cacheActivity;

    public MaidUpdateActivityFromSchedule() {
        super((Map)ImmutableMap.of());
    }

    protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
        Brain<EntityMaid> brain = maid.getBrain();
        long dayTime = level.getDayTime();
        if (gameTime - brain.lastScheduleUpdate > 20L) {
            Activity activity = brain.getSchedule().getActivityAt((int)(dayTime % 24000L));
            if (this.cacheActivity == null) {
                this.cacheActivity = activity;
            }
            if (!this.cacheActivity.equals((Object)activity) && maid.isHomeModeEnable() && maid.canBrainMoving()) {
                this.cacheActivity = activity;
                maid.getSchedulePos().restrictTo(maid);
                BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)maid.getRestrictCenter(), (float)0.7f, (int)3);
            }
        }
        MaidUpdateActivityFromSchedule.updateActivityFromSchedule(level, maid, brain, gameTime);
    }

    public static void updateActivityFromSchedule(EntityMaid maid, Brain<EntityMaid> brain) {
        Level level = maid.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long gameTime = serverLevel.getGameTime();
            MaidUpdateActivityFromSchedule.updateActivityFromSchedule(serverLevel, maid, brain, gameTime);
        }
    }

    public static void updateActivityFromSchedule(EntityMaid maid) {
        Level level = maid.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long gameTime = serverLevel.getGameTime();
            Brain<EntityMaid> brain = maid.getBrain();
            MaidUpdateActivityFromSchedule.updateActivityFromSchedule(serverLevel, maid, brain, gameTime);
        }
    }

    private static void updateActivityFromSchedule(ServerLevel level, EntityMaid maid, Brain<EntityMaid> brain, long gameTime) {
        long dayTime = level.getDayTime();
        if (maid.isMaidInSittingPose() || maid.isPassenger()) {
            if (gameTime - brain.lastScheduleUpdate > 20L) {
                brain.lastScheduleUpdate = gameTime;
                Activity activity = brain.getSchedule().getActivityAt((int)(dayTime % 24000L));
                Activity riderActivity = activity.equals((Object)Activity.WORK) ? InitEntities.RIDE_WORK.get() : (activity.equals((Object)Activity.IDLE) ? InitEntities.RIDE_IDLE.get() : InitEntities.RIDE_REST.get());
                if (!brain.isActive(riderActivity)) {
                    brain.eraseMemory(MemoryModuleType.PATH);
                    brain.eraseMemory(MemoryModuleType.WALK_TARGET);
                    brain.setActiveActivityIfPossible(riderActivity);
                    if (maid.isPassenger() && !riderActivity.equals((Object)InitEntities.RIDE_WORK.get())) {
                        if (!maid.getTask().workPointTask(maid)) {
                            return;
                        }
                        if (maid.getVehicle() instanceof EntitySit) {
                            return;
                        }
                        maid.stopRiding();
                    }
                }
            }
        } else {
            brain.updateActivityFromSchedule(dayTime, level.getGameTime());
        }
    }
}

