/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.control;

import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagBlock;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MaidMoveControl
extends MoveControl {
    private final EntityMaid maid;

    public MaidMoveControl(EntityMaid maid) {
        super((Mob)maid);
        this.maid = maid;
    }

    public void tick() {
        if (this.maid.getSwimManager().wantToSwim()) {
            if (this.maid.isUnderWater() && this.maid.getNavigation().isDone()) {
                this.maid.setSpeed(0.0f);
                return;
            }
            double x = this.wantedX - this.maid.getX();
            double y = this.wantedY - this.maid.getY();
            double z = this.wantedZ - this.maid.getZ();
            double sqrt = Math.sqrt(x * x + y * y + z * z);
            float yRot = (float)(Math.toDegrees(Mth.atan2((double)z, (double)x)) - 90.0);
            this.maid.setYRot(this.rotlerp(this.maid.getYRot(), yRot, 90.0f));
            this.maid.yBodyRot = this.maid.getYRot();
            float speed = (float)(this.speedModifier * this.maid.getAttributeValue(Attributes.MOVEMENT_SPEED));
            float speedLerp = Mth.lerp((float)1.0f, (float)this.maid.getSpeed(), (float)speed);
            if (this.maid.getSwimManager().getSwimTarget() != null) {
                this.maid.getLookControl().setLookAt(this.maid.getSwimManager().getSwimTarget().getCenter());
            }
            this.maid.setSpeed(speedLerp * 3.0f);
            this.maid.setDeltaMovement(this.maid.getDeltaMovement().add((double)speedLerp * x * 0.005, (double)speedLerp * y / sqrt * 0.25, (double)speedLerp * z * 0.005));
        } else if (this.operation == MoveControl.Operation.MOVE_TO) {
            double z;
            double y;
            this.operation = MoveControl.Operation.WAIT;
            double x = this.wantedX - this.mob.getX();
            double sqrt = x * x + (y = this.wantedY - this.mob.getY()) * y + (z = this.wantedZ - this.mob.getZ()) * z;
            if (sqrt < 2.5E-7) {
                this.mob.setZza(0.0f);
                return;
            }
            float angle = 57.295776f * (float)Mth.atan2((double)z, (double)x) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), angle, 90.0f));
            this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            BlockPos blockPos = this.mob.blockPosition();
            BlockState blockState = this.mob.level.getBlockState(blockPos);
            VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)this.mob.level(), blockPos);
            if ((double)this.mob.maxUpStep() < y && x * x + z * z < (double)Math.max(1.0f, this.mob.getBbWidth()) || !voxelShape.isEmpty() && this.mob.getY() < voxelShape.max(Direction.Axis.Y) + (double)blockPos.getY() && !blockState.is(TagBlock.MAID_JUMP_FORBIDDEN_BLOCK)) {
                this.mob.getJumpControl().jump();
                this.operation = MoveControl.Operation.JUMPING;
            }
        } else if (this.operation == MoveControl.Operation.JUMPING && this.mob.isInWater()) {
            this.operation = MoveControl.Operation.WAIT;
        } else {
            super.tick();
        }
    }
}

