/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack.data;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class FurnaceBackpackData
extends SimpleContainer
implements IBackpackData {
    private static final int INPUT_INDEX = 0;
    private static final int FUEL_INDEX = 1;
    private static final int OUTPUT_INDEX = 2;
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private final RecipeManager.CachedCheck<SingleRecipeInput, SmeltingRecipe> quickCheck;
    private final Level level;
    private final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> FurnaceBackpackData.this.litTime;
                case 1 -> FurnaceBackpackData.this.litDuration;
                case 2 -> FurnaceBackpackData.this.cookingProgress;
                case 3 -> FurnaceBackpackData.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    FurnaceBackpackData.this.litTime = value;
                    break;
                }
                case 1: {
                    FurnaceBackpackData.this.litDuration = value;
                    break;
                }
                case 2: {
                    FurnaceBackpackData.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    FurnaceBackpackData.this.cookingTotalTime = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public FurnaceBackpackData(EntityMaid maid) {
        super(3);
        this.quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.SMELTING);
        this.level = maid.level;
    }

    @Override
    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public void load(CompoundTag tag, EntityMaid maid) {
        this.litTime = tag.getInt("BurnTime");
        this.cookingProgress = tag.getInt("CookTime");
        this.cookingTotalTime = tag.getInt("CookTimeTotal");
        this.litDuration = this.getBurnDuration(this.getItem(1));
        this.fromTag(tag.getList("Items", 10), (HolderLookup.Provider)this.level.registryAccess());
    }

    @Override
    public void save(CompoundTag tag, EntityMaid maid) {
        tag.putInt("BurnTime", this.litTime);
        tag.putInt("CookTime", this.cookingProgress);
        tag.putInt("CookTimeTotal", this.cookingTotalTime);
        tag.put("Items", (Tag)this.createTag((HolderLookup.Provider)this.level.registryAccess()));
    }

    @Override
    public void serverTick(EntityMaid maid) {
        boolean readyForLit;
        Level level = maid.level();
        if (this.isLit()) {
            --this.litTime;
        }
        ItemStack fuelItem = this.getItem(1);
        boolean inputNotEmpty = !this.getItem(0).isEmpty();
        boolean fuelNotEmpty = !fuelItem.isEmpty();
        boolean bl = readyForLit = inputNotEmpty && fuelNotEmpty;
        if (this.isLit() || readyForLit) {
            SmeltingRecipe recipe = null;
            if (inputNotEmpty) {
                recipe = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(this.getItem(0)), level).map(RecipeHolder::value).orElse(null);
            }
            int maxStackSize = this.getMaxStackSize();
            if (!this.isLit() && this.canBurn(level.registryAccess(), recipe, this, maxStackSize)) {
                this.litDuration = this.litTime = this.getBurnDuration(fuelItem);
                if (this.isLit()) {
                    if (fuelItem.hasCraftingRemainingItem()) {
                        this.setItem(1, fuelItem.getCraftingRemainingItem());
                    } else if (fuelNotEmpty) {
                        fuelItem.shrink(1);
                        if (fuelItem.isEmpty()) {
                            this.setItem(1, fuelItem.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (this.isLit() && this.canBurn(level.registryAccess(), recipe, this, maxStackSize)) {
                ++this.cookingProgress;
                if (this.cookingProgress == this.cookingTotalTime) {
                    this.cookingProgress = 0;
                    this.cookingTotalTime = this.getTotalCookTime(level);
                    if (this.burn(level.registryAccess(), recipe, this, maxStackSize)) {
                        int exp = this.createExperience(recipe.getExperience());
                        maid.setExperience(maid.getExperience() + exp);
                    }
                }
            } else {
                this.cookingProgress = 0;
            }
        } else if (this.cookingProgress > 0) {
            this.cookingProgress = Mth.clamp((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
        }
    }

    public void setItem(int index, ItemStack stack) {
        ItemStack slotItem = this.getItem(index);
        boolean isSameItem = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)slotItem, (ItemStack)stack);
        super.setItem(index, stack);
        if (index == 0 && !isSameItem) {
            this.cookingTotalTime = this.getTotalCookTime(this.level);
            this.cookingProgress = 0;
        }
    }

    private int createExperience(float recipeExp) {
        int integer = Mth.floor((float)recipeExp);
        float decimal = Mth.frac((float)recipeExp);
        if (decimal != 0.0f && Math.random() < (double)decimal) {
            ++integer;
        }
        return integer;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    private int getBurnDuration(ItemStack fuel) {
        if (fuel.isEmpty()) {
            return 0;
        }
        return fuel.getBurnTime(RecipeType.SMELTING);
    }

    private boolean canBurn(RegistryAccess access, @Nullable SmeltingRecipe recipe, SimpleContainer container, int maxStackSize) {
        if (!container.getItem(0).isEmpty() && recipe != null) {
            ItemStack result = recipe.assemble(new SingleRecipeInput(this.getItem(0)), (HolderLookup.Provider)access);
            if (result.isEmpty()) {
                return false;
            }
            ItemStack output = container.getItem(2);
            if (output.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)output, (ItemStack)result)) {
                return false;
            }
            if (output.getCount() + result.getCount() <= maxStackSize && output.getCount() + result.getCount() <= output.getMaxStackSize()) {
                return true;
            }
            return output.getCount() + result.getCount() <= result.getMaxStackSize();
        }
        return false;
    }

    private boolean burn(RegistryAccess access, @Nullable SmeltingRecipe recipe, SimpleContainer container, int maxStackSize) {
        if (recipe != null && this.canBurn(access, recipe, container, maxStackSize)) {
            ItemStack input = container.getItem(0);
            ItemStack result = recipe.assemble(new SingleRecipeInput(this.getItem(0)), (HolderLookup.Provider)access);
            ItemStack output = container.getItem(2);
            if (output.isEmpty()) {
                container.setItem(2, result.copy());
            } else if (output.is(result.getItem())) {
                output.grow(result.getCount());
            }
            if (input.is(Blocks.WET_SPONGE.asItem()) && !container.getItem(1).isEmpty() && container.getItem(1).is(Items.BUCKET)) {
                container.setItem(1, new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            input.shrink(1);
            return true;
        }
        return false;
    }

    private int getTotalCookTime(Level level) {
        return this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(this.getItem(0)), level).map(recipeHolder -> ((SmeltingRecipe)recipeHolder.value()).getCookingTime()).orElse(200);
    }
}

