/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatTextType;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Type;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.StringUtils;

public final class ChatText {
    public static final ResourceLocation EMPTY_ICON_PATH = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"empty");
    public static final ChatText EMPTY_CHAT_TEXT = new ChatText(ChatTextType.EMPTY, EMPTY_ICON_PATH, "");
    public static final StreamCodec<ByteBuf, ChatText> STREAM_CODEC = StreamCodec.composite(ChatTextType.STREAM_CODEC, ChatText::getType, (StreamCodec)ResourceLocation.STREAM_CODEC, ChatText::getIconPath, (StreamCodec)ByteBufCodecs.STRING_UTF8, ChatText::getText, ChatText::new);
    private static final String ICON_IDENTIFIER_CHAR = "%";
    private final ChatTextType type;
    private final ResourceLocation iconPath;
    private final String text;

    public ChatText(ChatTextType type, ResourceLocation iconPath, String text) {
        this.type = type;
        this.iconPath = iconPath;
        this.text = text;
    }

    public boolean isText() {
        return this.type == ChatTextType.TEXT;
    }

    public boolean isIcon() {
        return this.type == ChatTextType.ICON;
    }

    public ResourceLocation getIconPath() {
        return this.iconPath;
    }

    public String getText() {
        return this.text;
    }

    public ChatTextType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChatText)) {
            return false;
        }
        ChatText chatText = (ChatText)obj;
        return this.type.equals((Object)chatText.type) && this.iconPath.equals((Object)chatText.iconPath) && this.text.equals(chatText.text);
    }

    public static class Serializer
    implements JsonDeserializer<ChatText> {
        public ChatText deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String text = GsonHelper.convertToString((JsonElement)json, (String)"chat_text");
            if (StringUtils.isEmpty((CharSequence)text)) {
                return EMPTY_CHAT_TEXT;
            }
            if (text.startsWith(ChatText.ICON_IDENTIFIER_CHAR) && text.endsWith(ChatText.ICON_IDENTIFIER_CHAR)) {
                String substring = text.substring(1, text.length() - 1);
                if (ResourceLocationUtil.isValidResourceLocation(substring)) {
                    return new ChatText(ChatTextType.ICON, ResourceLocation.parse((String)substring), "");
                }
                return EMPTY_CHAT_TEXT;
            }
            return new ChatText(ChatTextType.TEXT, EMPTY_ICON_PATH, text);
        }
    }
}

