/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatTextType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import org.apache.commons.lang3.StringUtils;

public class MaidScriptBookManager {
    private static final String STORE_TAG = "MaidScriptBook";
    private static final String SEPARATOR = "\n\n";
    private final Map<String, List<ChatText>> scripts = Maps.newHashMap();

    private static List<String> readBookPages(WrittenBookContent bookContent) {
        return bookContent.getPages(false).stream().map(Component::getString).toList();
    }

    private static List<String> readBookPages(WritableBookContent bookContent) {
        return bookContent.getPages(false).toList();
    }

    private static WritableBookContent replaceBookContentWithPages(List<String> pages, WritableBookContent book) {
        return book.withReplacedPages(pages.stream().map(Filterable::passThrough).toList());
    }

    private static void readScriptsFromPages(List<String> pages, Map<String, List<ChatText>> scripts) {
        scripts.clear();
        for (String page : pages) {
            String type;
            String[] split = StringUtils.split((String)page, (String)SEPARATOR);
            if (split.length < 2 || StringUtils.isBlank((CharSequence)(type = StringUtils.strip((String)split[0]).toLowerCase(Locale.US)))) continue;
            List scriptList = scripts.computeIfAbsent(type, k -> Lists.newArrayList());
            for (int j = 1; j < split.length; ++j) {
                String script = StringUtils.strip((String)split[j]);
                if (!StringUtils.isNotBlank((CharSequence)script)) continue;
                ChatText chatText = new ChatText(ChatTextType.TEXT, ChatText.EMPTY_ICON_PATH, script);
                scriptList.add(chatText);
            }
        }
    }

    private static void writeScriptsToPages(Map<String, List<ChatText>> scripts, List<String> pages) {
        pages.clear();
        for (Map.Entry<String, List<ChatText>> entry : scripts.entrySet()) {
            String type = entry.getKey();
            List<ChatText> scriptList = entry.getValue();
            if (scriptList.isEmpty()) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(type).append(SEPARATOR);
            for (ChatText chatText : scriptList) {
                builder.append(chatText.getText()).append(SEPARATOR);
            }
            pages.add(builder.toString());
        }
    }

    public boolean installScript(ItemStack stack) {
        WrittenBookContent writtenBookContent = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (writtenBookContent != null && !writtenBookContent.getPages(false).isEmpty()) {
            List<String> pages = MaidScriptBookManager.readBookPages(writtenBookContent);
            MaidScriptBookManager.readScriptsFromPages(pages, this.scripts);
            return true;
        }
        WritableBookContent writableBookContent = (WritableBookContent)stack.get(DataComponents.WRITABLE_BOOK_CONTENT);
        if (writableBookContent != null && writableBookContent.getPages(false).findAny().isPresent()) {
            List<String> pages = MaidScriptBookManager.readBookPages(writableBookContent);
            MaidScriptBookManager.readScriptsFromPages(pages, this.scripts);
            return true;
        }
        return false;
    }

    public void removeScript() {
        this.scripts.clear();
    }

    public boolean copyScript(ItemStack stack) {
        WritableBookContent book = (WritableBookContent)stack.get(DataComponents.WRITABLE_BOOK_CONTENT);
        if (book == null || !book.pages().isEmpty()) {
            return false;
        }
        ArrayList pages = Lists.newArrayList();
        MaidScriptBookManager.writeScriptsToPages(this.scripts, pages);
        WritableBookContent newBook = MaidScriptBookManager.replaceBookContentWithPages(pages, book);
        stack.set(DataComponents.WRITABLE_BOOK_CONTENT, (Object)newBook);
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        ListTag scriptsTags = new ListTag();
        ArrayList pages = Lists.newArrayList();
        MaidScriptBookManager.writeScriptsToPages(this.scripts, pages);
        for (String page : pages) {
            scriptsTags.add((Object)StringTag.valueOf((String)page));
        }
        compound.put(STORE_TAG, (Tag)scriptsTags);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (!compound.contains(STORE_TAG, 9)) {
            return;
        }
        ListTag scriptsTags = compound.getList(STORE_TAG, 8);
        ArrayList pages = Lists.newArrayList();
        for (Tag tag : scriptsTags) {
            pages.add(tag.getAsString());
        }
        MaidScriptBookManager.readScriptsFromPages(pages, this.scripts);
    }

    public List<ChatText> getScripts(String type) {
        return this.scripts.getOrDefault(type, Lists.newArrayList());
    }
}

