/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.favorability;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;

public class FavorabilityManager {
    public static final Map<String, Type> TYPES = Maps.newHashMap();
    private static final int LEVEL_0 = 0;
    private static final int LEVEL_1 = 1;
    private static final int LEVEL_2 = 2;
    private static final int LEVEL_3 = 3;
    private static final int LEVEL_0_POINT = 0;
    private static final int LEVEL_1_POINT = 64;
    private static final int LEVEL_2_POINT = 192;
    private static final int LEVEL_3_POINT = 384;
    private static final int LEVEL_0_HEALTH = 20;
    private static final int LEVEL_1_HEALTH = 30;
    private static final int LEVEL_2_HEALTH = 40;
    private static final int LEVEL_3_HEALTH = 80;
    private static final int LEVEL_0_ATTACK_DAMAGE = 2;
    private static final int LEVEL_1_ATTACK_DAMAGE = 3;
    private static final int LEVEL_2_ATTACK_DAMAGE = 4;
    private static final int LEVEL_3_ATTACK_DAMAGE = 6;
    private static final int LEVEL_0_ATTACK_DISTANCE = 2;
    private static final int LEVEL_1_ATTACK_DISTANCE = 3;
    private static final int LEVEL_2_ATTACK_DISTANCE = 5;
    private static final int LEVEL_3_ATTACK_DISTANCE = 7;
    private static final double LEVEL_0_SWEEP_RANGE = 1.0;
    private static final double LEVEL_1_SWEEP_RANGE = 2.0;
    private static final double LEVEL_2_SWEEP_RANGE = 3.0;
    private static final double LEVEL_3_SWEEP_RANGE = 4.0;
    private static final String TAG_NAME = "FavorabilityManagerCounter";
    private final Map<String, Time> counter = Maps.newHashMap();
    private final EntityMaid maid;

    public FavorabilityManager(EntityMaid maid) {
        this.maid = maid;
    }

    public void tick() {
        this.counter.values().forEach(Time::tick);
    }

    public void apply(String type) {
        Type typeInstance = TYPES.get(type);
        if (typeInstance != null) {
            this.apply(typeInstance);
        }
    }

    public void apply(Type type) {
        if (this.canAdd(type.getTypeName())) {
            if (type.isReduce()) {
                this.reduce(type.getPoint());
            } else {
                this.add(type.getPoint());
            }
            this.addCooldown(type.getTypeName(), type.getCooldown());
        }
    }

    public void apply(Type type, int point) {
        if (this.canAdd(type.getTypeName())) {
            if (type.isReduce()) {
                this.reduce(point);
            } else {
                this.add(point);
            }
            this.addCooldown(type.getTypeName(), type.getCooldown());
        }
    }

    private void addCooldown(String type, int tickCount) {
        this.counter.put(type, new Time(tickCount));
    }

    public boolean canAdd(String type) {
        if (this.counter.containsKey(type)) {
            return this.counter.get(type).isZero();
        }
        return true;
    }

    public int getLevel() {
        return this.getLevel(this.maid.getFavorability());
    }

    private int getLevel(int favorability) {
        if (favorability < 64) {
            return 0;
        }
        if (favorability < 192) {
            return 1;
        }
        if (favorability < 384) {
            return 2;
        }
        return 3;
    }

    public double getLevelPercent() {
        int favorability = this.maid.getFavorability();
        if (favorability < 64) {
            return (double)favorability / 64.0;
        }
        if (favorability < 192) {
            return (double)(favorability - 64) / 128.0;
        }
        if (favorability < 384) {
            return (double)(favorability - 192) / 192.0;
        }
        return 0.0;
    }

    public int nextLevelPoint() {
        int level = this.getLevel();
        if (level == 3) {
            return 0;
        }
        int pointByLevel = this.getPointByLevel(level + 1);
        return pointByLevel - this.maid.getFavorability();
    }

    public int getHealthByLevel(int level) {
        switch (level) {
            case 1: {
                return 30;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 80;
            }
        }
        return 20;
    }

    public int getAttackByLevel(int level) {
        switch (level) {
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 6;
            }
        }
        return 2;
    }

    public int getAttackDistanceByPoint(int favorability) {
        if (favorability < 64) {
            return 2;
        }
        if (favorability < 192) {
            return 3;
        }
        if (favorability < 384) {
            return 5;
        }
        return 7;
    }

    public AABB getSweepRange(Entity target, int favorability) {
        AABB boundingBox = target.getBoundingBox();
        if (favorability < 64) {
            return this.sweepRangeTransform(boundingBox, 1.0);
        }
        if (favorability < 192) {
            return this.sweepRangeTransform(boundingBox, 2.0);
        }
        if (favorability < 384) {
            return this.sweepRangeTransform(boundingBox, 3.0);
        }
        return this.sweepRangeTransform(boundingBox, 4.0);
    }

    private AABB sweepRangeTransform(AABB boundingBox, double range) {
        return boundingBox.inflate(range, Math.max(range / 4.0, 0.25), range);
    }

    public int getPointByLevel(int level) {
        switch (level) {
            case 1: {
                return 64;
            }
            case 2: {
                return 192;
            }
            case 3: {
                return 384;
            }
        }
        return 0;
    }

    public void add(int addPoint) {
        int favorability = this.maid.getFavorability();
        int levelBefore = this.getLevel();
        int result = Mth.clamp((int)(favorability + addPoint), (int)0, (int)384);
        this.maid.setFavorability(result);
        int levelAfter = this.getLevel();
        if (levelBefore < levelAfter) {
            ServerPlayer serverPlayer;
            LivingEntity livingEntity;
            AttributeInstance attack = this.maid.getAttribute(Attributes.ATTACK_DAMAGE);
            AttributeInstance health = this.maid.getAttribute(Attributes.MAX_HEALTH);
            if (attack != null) {
                attack.setBaseValue((double)this.getAttackByLevel(levelAfter));
            }
            if (health != null) {
                if (this.maid.isStruckByLightning()) {
                    health.setBaseValue((double)(this.getHealthByLevel(levelAfter) + 20));
                } else {
                    health.setBaseValue((double)this.getHealthByLevel(levelAfter));
                }
                if (this.maid.getHealth() > this.maid.getMaxHealth()) {
                    this.maid.setHealth(this.maid.getMaxHealth());
                }
                if (this.maid.getMaxHealth() >= 100.0f && (livingEntity = this.maid.getOwner()) instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)livingEntity;
                    ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "maid_100_healthy");
                }
            }
            if ((livingEntity = this.maid.getOwner()) instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)livingEntity;
                ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "favorability_increased");
                if (levelAfter == 3) {
                    ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "favorability_increased_max");
                }
            }
            this.maid.playSound(SoundEvents.PLAYER_LEVELUP, 0.5f, this.maid.getRandom().nextFloat() * 0.1f + 0.9f);
        }
        NetworkHandler.sendToNearby((Entity)this.maid, new SpawnParticlePackage(this.maid.getId(), SpawnParticlePackage.Type.HEART));
    }

    public void reduce(int reducePoint) {
        int favorability = this.maid.getFavorability();
        int pointByLevel = this.getPointByLevel(this.getLevel());
        int result = Mth.clamp((int)(favorability - reducePoint), (int)pointByLevel, (int)384);
        this.maid.setFavorability(result);
    }

    public void reduceWithoutLevel(int reducePoint) {
        int favorability = this.maid.getFavorability();
        int levelBefore = this.getLevel();
        int result = Mth.clamp((int)(favorability - reducePoint), (int)0, (int)384);
        this.maid.setFavorability(result);
        int levelAfter = this.getLevel();
        if (levelBefore > levelAfter) {
            AttributeInstance attack = this.maid.getAttribute(Attributes.ATTACK_DAMAGE);
            AttributeInstance health = this.maid.getAttribute(Attributes.MAX_HEALTH);
            if (attack != null) {
                attack.setBaseValue((double)this.getAttackByLevel(levelAfter));
            }
            if (health != null) {
                if (this.maid.isStruckByLightning()) {
                    health.setBaseValue((double)(this.getHealthByLevel(levelAfter) + 20));
                } else {
                    health.setBaseValue((double)this.getHealthByLevel(levelAfter));
                }
                if (this.maid.getHealth() > this.maid.getMaxHealth()) {
                    this.maid.setHealth(this.maid.getMaxHealth());
                }
            }
        }
    }

    public void max() {
        this.add(384);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        CompoundTag data = new CompoundTag();
        this.counter.forEach((name, time) -> data.putInt(name, time.getTickCount()));
        compound.put(TAG_NAME, (Tag)data);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains(TAG_NAME, 10)) {
            CompoundTag data = compound.getCompound(TAG_NAME);
            for (String name : data.getAllKeys()) {
                this.counter.put(name, new Time(data.getInt(name)));
            }
        }
    }

    public static class Time {
        private int tickCount;

        public Time(int tickCount) {
            this.tickCount = tickCount;
        }

        public int getTickCount() {
            return this.tickCount;
        }

        public void setTickCount(int tickCount) {
            this.tickCount = tickCount;
        }

        public void tick() {
            if (this.tickCount > 0) {
                --this.tickCount;
            }
        }

        public boolean isZero() {
            return this.tickCount <= 0;
        }
    }
}

