/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityBox
extends Entity {
    public static final int FIRST_STAGE = 64;
    public static final int SECOND_STAGE = 60;
    public static final int THIRD_STAGE = 0;
    public static final int MAX_TEXTURE_SIZE = 8;
    private static final EntityDataAccessor<Integer> OPEN_STAGE = SynchedEntityData.defineId(EntityBox.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TEXTURE_INDEX = SynchedEntityData.defineId(EntityBox.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityType<EntityBox> TYPE = EntityType.Builder.of(EntityBox::new, (MobCategory)MobCategory.MISC).sized(2.0f, 2.0f).clientTrackingRange(10).build("box");
    private static final String STAGE_TAG = "OpenStage";
    private static final String TEXTURE_TAG = "TextureIndex";

    public EntityBox(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setRandomTexture();
    }

    public EntityBox(Level worldIn) {
        this(TYPE, worldIn);
    }

    public void baseTick() {
        if (!this.isNoGravity() && !this.onGround()) {
            this.move(MoverType.SELF, this.getDeltaMovement().add(0.0, -0.1, 0.0));
        }
        super.baseTick();
        int stage = this.getOpenStage();
        this.stageChange(stage);
        this.getPassengers().stream().filter(e -> e instanceof TamableAnimal).forEach(e -> this.applyInvisibilityEffect((TamableAnimal)e, stage));
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.getOpenStage() == 64) {
            this.setOpenStage(63);
            this.playSound((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.getOpenStage() == 60) {
            this.setOpenStage(59);
            this.playSound((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.getOpenStage() == 0) {
            this.setOpenStage(-1);
            this.playSound((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 2.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.interact(player, hand);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OPEN_STAGE, (Object)64);
        builder.define(TEXTURE_INDEX, (Object)0);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains(STAGE_TAG)) {
            this.setOpenStage(compound.getInt(STAGE_TAG));
        }
        if (compound.contains(TEXTURE_TAG)) {
            this.setTextureIndex(compound.getInt(TEXTURE_TAG));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt(STAGE_TAG, this.getOpenStage());
        compound.putInt(TEXTURE_TAG, this.getTextureIndex());
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public int getOpenStage() {
        return (Integer)this.entityData.get(OPEN_STAGE);
    }

    public void setOpenStage(int stage) {
        this.entityData.set(OPEN_STAGE, (Object)Mth.clamp((int)stage, (int)-1, (int)64));
    }

    public int getTextureIndex() {
        return (Integer)this.entityData.get(TEXTURE_INDEX);
    }

    public void setTextureIndex(int index) {
        this.entityData.set(TEXTURE_INDEX, (Object)Mth.clamp((int)index, (int)1, (int)7));
    }

    public void setRandomTexture() {
        this.setTextureIndex(this.random.nextInt(8));
    }

    private void stageChange(int stage) {
        if (stage != 64 && stage != 60 && stage != 0) {
            this.setOpenStage(stage - 1);
        }
        if (stage < 0) {
            this.discard();
            if (!this.level.isClientSide) {
                this.spawnAtLocation((ItemLike)Items.PAPER, 2 + this.random.nextInt(3));
            }
        }
    }

    private void applyInvisibilityEffect(TamableAnimal tameable, int stage) {
        if (stage >= 64) {
            tameable.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 2, 1, false, false));
        }
    }

    public Vec3 getPassengerRidingPosition(Entity pEntity) {
        return this.position().add(this.getPassengerAttachmentPoint(pEntity, this.getDimensions(Pose.STANDING), 1.0f)).subtract(0.0, 2.0, 0.0);
    }
}

