/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityBroom
extends AbstractEntityFromItem
implements OwnableEntity,
HasCustomInventoryScreen {
    public static final EntityType<EntityBroom> TYPE = EntityType.Builder.of(EntityBroom::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10).ridingOffset(0.0f).build("broom");
    private static final EntityDataAccessor<Optional<UUID>> OWNER_ID = SynchedEntityData.defineId(EntityBroom.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private boolean keyForward = false;
    private boolean keyBack = false;
    private boolean keyLeft = false;
    private boolean keyRight = false;

    public EntityBroom(EntityType<EntityBroom> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.setNoGravity(true);
    }

    public EntityBroom(Level worldIn) {
        this(TYPE, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean keyForward() {
        return Minecraft.getInstance().options.keyUp.isDown();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean keyBack() {
        return Minecraft.getInstance().options.keyDown.isDown();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean keyLeft() {
        return Minecraft.getInstance().options.keyLeft.isDown();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean keyRight() {
        return Minecraft.getInstance().options.keyRight.isDown();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER_ID, Optional.empty());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("owner_uuid")) {
            this.setOwnerUUID(NbtUtils.loadUUID((Tag)Objects.requireNonNull(compound.get("owner_uuid"))));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ((Optional)this.entityData.get(OWNER_ID)).ifPresent(uuid -> compound.putUUID("owner_uuid", uuid));
    }

    public void travel(Vec3 vec3) {
        LivingEntity entity = this.getControllingPassenger();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isVehicle() && this.hasPassenger(e -> e instanceof EntityMaid)) {
                float vertical;
                if (this.level.isClientSide) {
                    this.keyForward = EntityBroom.keyForward();
                    this.keyBack = EntityBroom.keyBack();
                    this.keyLeft = EntityBroom.keyLeft();
                    this.keyRight = EntityBroom.keyRight();
                }
                float strafe = this.keyLeft ? 0.5f : (this.keyRight ? -0.5f : 0.0f);
                float f = vertical = this.keyForward ? -(player.getXRot() - 10.0f) / 22.5f : 0.0f;
                float forward = this.keyForward ? 3.0f : (this.keyBack ? -0.5f : 0.0f);
                this.moveRelative(0.02f, new Vec3((double)strafe, (double)vertical, (double)forward));
                this.move(MoverType.SELF, this.getDeltaMovement());
                return;
            }
        }
        if (!this.onGround()) {
            super.travel(new Vec3(0.0, (double)-0.3f, 0.0));
            return;
        }
        super.travel(vec3);
    }

    protected void pushEntities() {
        if (this.getPassengers().size() >= 2) {
            return;
        }
        if (!this.getPassengers().isEmpty() && !(this.getControllingPassenger() instanceof Player)) {
            return;
        }
        if (!this.level.isClientSide) {
            List list = this.level.getEntitiesOfClass(EntityMaid.class, this.getBoundingBox().expandTowards(0.5, 0.1, 0.5), this::canMaidRide);
            list.stream().findFirst().ifPresent(entity -> entity.startRiding((Entity)this));
        }
    }

    private boolean canMaidRide(EntityMaid maid) {
        if (maid.canBrainMoving() && !maid.isVehicle() && EntitySelector.pushableBy((Entity)this).test(maid)) {
            UUID maidOwnerUUID = maid.getOwnerUUID();
            UUID broomOwnerUUID = this.getOwnerUUID();
            if (maidOwnerUUID == null || broomOwnerUUID == null) {
                return false;
            }
            return maidOwnerUUID.equals(broomOwnerUUID);
        }
        return false;
    }

    protected void tickRidden(Player player, Vec3 pTravelVector) {
        this.fallDistance = 0.0f;
        if (!this.onGround()) {
            this.addDeltaMovement(new Vec3(0.0, 0.01 * Math.sin((double)this.tickCount * Math.PI / 18.0), 0.0));
        }
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.setRot(player.getYRot(), player.getXRot());
        super.tickRidden(player, pTravelVector);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimension, float partialTick) {
        double xOffset;
        double d = xOffset = passenger instanceof EntityMaid ? -0.5 : 0.0;
        if (this.getPassengers().size() > 1) {
            xOffset = this.getPassengers().indexOf(passenger) == 0 ? 0.35 : -0.35;
        }
        Vec3 hOffset = new Vec3(xOffset, -0.3125, 0.0).yRot((float)((double)(-(this.getYRot() + 90.0f)) * Math.PI / 180.0));
        return super.getPassengerAttachmentPoint(passenger, dimension, partialTick).add(hOffset);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!(player.isDiscrete() || this.isPassenger() || this.getControllingPassenger() instanceof Player)) {
            if (this.getPassengers().size() > 1) {
                return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
            }
            if (!this.level.isClientSide) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        return super.interact(player, hand);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    public void openCustomInventoryScreen(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        List passengers = this.getPassengers();
        boolean hasPlayer = false;
        EntityMaid maidOpen = null;
        for (int i = 0; i < Math.max(passengers.size(), 2); ++i) {
            EntityMaid maid;
            Entity entity = (Entity)passengers.get(i);
            if (entity.equals((Object)player)) {
                hasPlayer = true;
            }
            if (!(entity instanceof EntityMaid) || !(maid = (EntityMaid)entity).isOwnedBy((LivingEntity)player)) continue;
            maidOpen = maid;
        }
        if (hasPlayer && maidOpen != null) {
            maidOpen.openMaidGui((Player)serverPlayer);
        }
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    protected boolean canAddPassenger(Entity entity) {
        return this.getPassengers().size() < 2;
    }

    @Override
    protected boolean canKillEntity(Player player) {
        return true;
    }

    @Override
    protected SoundEvent getHitSound() {
        return SoundEvents.WOOL_BREAK;
    }

    @Override
    protected Item getWithItem() {
        return (Item)InitItems.BROOM.get();
    }

    @Override
    protected ItemStack getKilledStack() {
        return new ItemStack((ItemLike)this.getWithItem());
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        this.resetFallDistance();
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(OWNER_ID, Optional.ofNullable(uuid));
    }
}

