/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class EntityTombstone
extends Entity {
    public static final EntityType<EntityTombstone> TYPE = EntityType.Builder.of(EntityTombstone::new, (MobCategory)MobCategory.MISC).sized(0.8f, 1.2f).clientTrackingRange(10).build("tombstone");
    private static final String OWNER_ID_TAG = "OwnerId";
    private static final String TOMBSTONE_ITEMS_TAG = "TombstoneItems";
    private static final String MAID_NAME_TAG = "MaidName";
    private static final EntityDataAccessor<Component> MAID_NAME = SynchedEntityData.defineId(EntityTombstone.class, (EntityDataSerializer)EntityDataSerializers.COMPONENT);
    private final ItemStackHandler items = new ItemStackHandler(72);
    private UUID ownerId = Util.NIL_UUID;

    public EntityTombstone(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityTombstone(Level worldIn, UUID ownerId, Vec3 pos) {
        this(TYPE, worldIn);
        this.ownerId = ownerId;
        this.setPos(pos);
    }

    public void insertItem(ItemStack item) {
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.items, (ItemStack)item, (boolean)false);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        Ingredient ntrItem = EntityMaid.getNtrItem();
        if (player.getUUID().equals(this.ownerId) || ntrItem.test(itemInHand)) {
            for (int i = 0; i < this.items.getSlots(); ++i) {
                int size = this.items.getSlotLimit(i);
                ItemStack extractItem = this.items.extractItem(i, size, false);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extractItem);
            }
            this.discard();
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        if (!player.level.isClientSide && hand == InteractionHand.MAIN_HAND) {
            ItemStack stack = Arrays.stream(ntrItem.getItems()).findFirst().orElse(ItemStack.EMPTY);
            Component displayName = stack.getDisplayName();
            player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.tombstone.not_yours.1"));
            player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.tombstone.not_yours.2").append(displayName));
        }
        return super.interact(player, hand);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MAID_NAME, (Object)Component.empty());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains(OWNER_ID_TAG)) {
            this.ownerId = tag.getUUID(OWNER_ID_TAG);
        }
        if (tag.contains(TOMBSTONE_ITEMS_TAG)) {
            this.items.deserializeNBT((HolderLookup.Provider)this.registryAccess(), tag.getCompound(TOMBSTONE_ITEMS_TAG));
        }
        if (tag.contains(MAID_NAME_TAG)) {
            String nameJson = tag.getString(MAID_NAME_TAG);
            this.setMaidName((Component)Component.Serializer.fromJson((String)nameJson, (HolderLookup.Provider)this.registryAccess()));
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putUUID(OWNER_ID_TAG, this.ownerId);
        tag.put(TOMBSTONE_ITEMS_TAG, (Tag)this.items.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        tag.putString(MAID_NAME_TAG, Component.Serializer.toJson((Component)this.getMaidName(), (HolderLookup.Provider)this.registryAccess()));
    }

    public void tick() {
        if (!this.level.isClientSide) {
            this.checkBelowWorld();
        }
    }

    public boolean skipAttackInteraction(Entity pEntity) {
        return true;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return false;
    }

    public void move(MoverType pType, Vec3 pPos) {
    }

    public void push(Entity entity) {
    }

    public void push(double pX, double pY, double pZ) {
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    public void thunderHit(ServerLevel pLevel, LightningBolt pLightning) {
    }

    public void refreshDimensions() {
    }

    public void remove(Entity.RemovalReason reason) {
        MaidWorldData maidWorldData;
        if (reason.shouldDestroy() && (maidWorldData = MaidWorldData.get(this.level)) != null) {
            maidWorldData.removeTombstones(this);
        }
        super.remove(reason);
    }

    public boolean canCollideWith(Entity entity) {
        return false;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public void setMaidName(@Nullable Component name) {
        if (name != null) {
            this.entityData.set(MAID_NAME, (Object)name);
        }
    }

    public Component getMaidName() {
        return (Component)this.entityData.get(MAID_NAME);
    }

    public ItemStackHandler getItems() {
        return this.items;
    }
}

