/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.monster;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.goal.FairyAttackGoal;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.FairyType;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.IHasPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuShoot;
import com.github.tartaricacid.touhoulittlemaid.init.InitPoi;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityFairy
extends Monster
implements RangedAttackMob,
FlyingAnimal,
IHasPowerPoint {
    public static final EntityType<EntityFairy> TYPE = EntityType.Builder.of(EntityFairy::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.5f).clientTrackingRange(10).build("fairy");
    public static final String RICK = "rick";
    private static final String FAIRY_TYPE_TAG_NAME = "FairyType";
    private static final EntityDataAccessor<Integer> FAIRY_TYPE = SynchedEntityData.defineId(EntityFairy.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final double AIMED_SHOT_PROBABILITY = 0.9;

    protected EntityFairy(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new FlyingMoveControl((Mob)this, 15, true);
    }

    public EntityFairy(Level worldIn) {
        this(TYPE, worldIn);
    }

    public static AttributeSupplier.Builder createFairyAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 1.5).add(Attributes.ARMOR, 1.0).add(Attributes.FLYING_SPEED, 0.4);
    }

    public static boolean checkFairySpawnRules(EntityType<EntityFairy> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        if (Monster.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)randomSource) && levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            int scarecrowRange = (Integer)MiscConfig.SCARECROW_RANGE.get();
            long findCount = level.getPoiManager().getInSquare(type -> ((PoiType)type.value()).equals(InitPoi.SCARECROW.get()), pos, scarecrowRange, PoiManager.Occupancy.ANY).count();
            return findCount <= 0L;
        }
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FairyAttackGoal(this, 6.0, 1.0));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, EntityMaid.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FAIRY_TYPE, (Object)FairyType.BLACK.ordinal());
    }

    @Override
    public int getPowerPoint() {
        return (int)((Double)MiscConfig.MAID_FAIRY_POWER_POINT.get() * 100.0);
    }

    protected void tickDeath() {
        super.tickDeath();
        this.dropPowerPoint((LivingEntity)this);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        float damageBase = 1.0f;
        Difficulty difficulty = target.level.getDifficulty();
        switch (difficulty) {
            case NORMAL: {
                damageBase = 1.5f;
                break;
            }
            case HARD: {
                damageBase = 2.0f;
            }
        }
        if ((double)this.random.nextFloat() <= 0.9) {
            DanmakuShoot.create().setWorld(this.level).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + damageBase).setGravity(0.0f).setVelocity(0.2f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).aimedShot();
        } else {
            DanmakuShoot.create().setWorld(this.level).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + damageBase + 0.5f).setGravity(0.0f).setVelocity(0.2f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(3).setYawTotal(0.5235987755982988).fanShapedShot();
        }
    }

    protected PathNavigation createNavigation(Level worldIn) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, worldIn);
        navigator.setCanOpenDoors(false);
        navigator.setCanFloat(true);
        navigator.setCanPassDoors(true);
        return navigator;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setFairyTypeOrdinal(this.random.nextInt(FairyType.values().length));
        if (this.random.nextInt(20) == 0) {
            this.setCustomName((Component)Component.literal((String)RICK));
            this.setCustomNameVisible(true);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt(FAIRY_TYPE_TAG_NAME, this.getFairyTypeOrdinal());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains(FAIRY_TYPE_TAG_NAME, 3)) {
            this.setFairyTypeOrdinal(compound.getInt(FAIRY_TYPE_TAG_NAME));
        }
    }

    public int getFairyTypeOrdinal() {
        return (Integer)this.entityData.get(FAIRY_TYPE);
    }

    public void setFairyTypeOrdinal(int ordinal) {
        this.entityData.set(FAIRY_TYPE, (Object)ordinal);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)InitSounds.FAIRY_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)InitSounds.FAIRY_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)InitSounds.FAIRY_DEATH.get();
    }
}

