/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.client.render.MaidRenderState;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAfterEatEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAttackEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDeathEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidEquipEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidHurtEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidPlaySoundEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTickEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.event.YsmMaidClientTickEvent;
import com.github.tartaricacid.touhoulittlemaid.config.ServerConfig;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.datagen.EnchantmentKeys;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagItem;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidBrain;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.control.MaidMoveControl;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.MaidPathNavigation;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BigBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.EmptyBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.MiddleBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.SmallBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.MaidChatBubbles;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.MaidScriptBookManager;
import com.github.tartaricacid.touhoulittlemaid.entity.data.MaidTaskDataMaps;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.info.ServerCustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.DefaultMaidSoundPack;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidConfigManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidGameRecordManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidKillRecordManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidNavigationManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidSwimManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.PickType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskIdle;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.config.MaidConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.MaidBackpackHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.MaidHandsInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFilm;
import com.github.tartaricacid.touhoulittlemaid.mixin.MixinArrowEntity;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.ItemBreakPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.PlayMaidSoundPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncYsmMaidDataPackage;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.TeleportHelper;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityHandsInvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import net.neoforged.neoforge.network.PacketDistributor;

public class EntityMaid
extends TamableAnimal
implements CrossbowAttackMob,
IMaid {
    public static final EntityType<EntityMaid> TYPE = EntityType.Builder.of(EntityMaid::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.5f).clientTrackingRange(10).build("maid");
    public static final String IS_YSM_MODEL_TAG = "IsYsmModel";
    public static final String YSM_MODEL_ID_TAG = "YsmModelId";
    public static final String YSM_MODEL_TEXTURE_TAG = "YsmModelTexture";
    public static final String YSM_MODEL_NAME_TAG = "YsmModelName";
    public static final String YSM_ROULETTE_ANIM_TAG = "YsmRouletteAnim";
    public static final String YSM_ROAMING_VARS_TAG = "YsmRoamingVars";
    public static final String YSM_ROAMING_UPDATE_FLAG_TAG = "YsmRoamingUpdateFlag";
    public static final String MODEL_ID_TAG = "model_id";
    public static final String SOUND_PACK_ID_TAG = "SoundPackId";
    public static final String MAID_BACKPACK_TYPE = "MaidBackpackType";
    public static final String MAID_INVENTORY_TAG = "MaidInventory";
    public static final String MAID_BAUBLE_INVENTORY_TAG = "MaidBaubleInventory";
    public static final String MAID_HIDE_INVENTORY_TAG = "MaidHideInventory";
    public static final String MAID_TASK_INVENTORY_TAG = "MaidTaskInventory";
    public static final String EXPERIENCE_TAG = "MaidExperience";
    private static final long WARNING_TIME_NANOS = Duration.ofMillis(50L).toNanos();
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;
    private static final EntityDataAccessor<Boolean> DATA_IS_YSM_MODEL = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> DATA_YSM_MODEL_ID = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> DATA_YSM_MODEL_TEXTURE = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Component> DATA_YSM_MODEL_NAME = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.COMPONENT);
    private static final EntityDataAccessor<String> DATA_MODEL_ID = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> DATA_SOUND_PACK_ID = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> DATA_TASK = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> DATA_BEGGING = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_INVULNERABLE = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_HUNGER = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_FAVORABILITY = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_EXPERIENCE = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_STRUCK_BY_LIGHTNING = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING_CROSSBOW = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_ARM_RISE = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<MaidSchedule> SCHEDULE_MODE = SynchedEntityData.defineId(EntityMaid.class, MaidSchedule.DATA);
    private static final EntityDataAccessor<BlockPos> RESTRICT_CENTER = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Float> RESTRICT_RADIUS = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<MaidChatBubbles> CHAT_BUBBLE = SynchedEntityData.defineId(EntityMaid.class, MaidChatBubbles.DATA);
    private static final EntityDataAccessor<String> BACKPACK_TYPE = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<ItemStack> BACKPACK_ITEM_SHOW = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<String> BACKPACK_FLUID = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    static final EntityDataAccessor<CompoundTag> GAME_SKILL = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    static final EntityDataAccessor<Byte> GAME_STATUE = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    static final EntityDataAccessor<Boolean> DATA_PICKUP = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Boolean> DATA_HOME_MODE = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Boolean> DATA_RIDEABLE = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Boolean> BACKPACK_SHOW = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Boolean> BACK_ITEM_SHOW = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Boolean> CHATBUBBLE_SHOW = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Float> SOUND_FREQ = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    static final EntityDataAccessor<Integer> PICKUP_TYPE = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.INT);
    static final EntityDataAccessor<Boolean> OPEN_DOOR = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Boolean> OPEN_FENCE_GATE = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Boolean> ACTIVE_CLIMBING = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<CompoundTag> TASK_DATA_SYNC = SynchedEntityData.defineId(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final String TASK_TAG = "MaidTask";
    private static final String STRUCK_BY_LIGHTNING_TAG = "StruckByLightning";
    private static final String INVULNERABLE_TAG = "Invulnerable";
    private static final String HUNGER_TAG = "MaidHunger";
    private static final String FAVORABILITY_TAG = "MaidFavorability";
    private static final String SCHEDULE_MODE_TAG = "MaidScheduleMode";
    private static final String BACKPACK_DATA_TAG = "MaidBackpackData";
    private static final String STRUCTURE_SPAWN_TAG = "StructureSpawn";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    @Deprecated
    private static final String BACKPACK_LEVEL_TAG = "MaidBackpackLevel";
    @Deprecated
    private static final String RESTRICT_CENTER_TAG = "MaidRestrictCenter";
    public final ItemStack[] handItemsForAnimation = new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY};
    private final EntityArmorInvWrapper armorInvWrapper = new EntityArmorInvWrapper((LivingEntity)this);
    private final EntityHandsInvWrapper handsInvWrapper = new MaidHandsInvWrapper((LivingEntity)this);
    private final ItemStackHandler maidInv = new MaidBackpackHandler(36, this);
    private final BaubleItemHandler maidBauble = new BaubleItemHandler(9);
    private final ItemStackHandler hideInv = new ItemStackHandler(1);
    private final ItemStackHandler taskInv = new ItemStackHandler(9);
    private final MaidKillRecordManager killRecordManager = new MaidKillRecordManager();
    private final MaidTaskDataMaps taskDataMaps = new MaidTaskDataMaps();
    private final FavorabilityManager favorabilityManager;
    private final MaidScriptBookManager scriptBookManager;
    private final MaidSwimManager swimManager;
    private final MaidNavigationManager navigationManager;
    private final MaidAIChatManager aiChatManager;
    private final SchedulePos schedulePos;
    private final ItemCooldowns cooldowns;
    public boolean guiOpening = false;
    public MaidFishingHook fishing = null;
    public MaidRenderState renderState = MaidRenderState.ENTITY;
    public boolean rouletteAnimPlaying = false;
    public String rouletteAnim = "empty";
    public boolean rouletteAnimDirty = false;
    public int roamingVarsUpdateFlag = 0;
    public Object2FloatOpenHashMap<String> roamingVars = new Object2FloatOpenHashMap();
    private List<SendEffectPackage.EffectData> effects = Lists.newArrayList();
    private IMaidTask task = TaskManager.getIdleTask();
    private IMaidBackpack backpack = BackpackManager.getEmptyBackpack();
    private int playerHurtSoundCount = 120;
    private int pickupSoundCount = 5;
    private int backpackDelay = 0;
    private int passiveUseShieldTick = 0;
    private IBackpackData backpackData = null;
    private boolean syncTaskDataMaps = false;
    private MaidConfigManager configManager = new MaidConfigManager(this.entityData);
    private MaidGameRecordManager gameRecordManager = new MaidGameRecordManager(this);
    private boolean structureSpawn = false;
    private boolean canClimb = false;
    private boolean alreadyDropped = false;
    private int climbFallDelayTicks = 0;

    protected EntityMaid(EntityType<EntityMaid> type, Level world) {
        super(type, world);
        this.favorabilityManager = new FavorabilityManager(this);
        this.scriptBookManager = new MaidScriptBookManager();
        this.aiChatManager = new MaidAIChatManager(this);
        ResourceKey dimension = Objects.requireNonNullElse(world.dimension(), Level.OVERWORLD);
        this.schedulePos = new SchedulePos(BlockPos.ZERO, dimension.location());
        this.moveControl = new MaidMoveControl(this);
        this.swimManager = new MaidSwimManager(this);
        this.navigationManager = new MaidNavigationManager(this);
        this.cooldowns = new ItemCooldowns();
    }

    public EntityMaid(Level worldIn) {
        this(TYPE, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.ATTACK_KNOCKBACK).add(Attributes.ATTACK_DAMAGE).add(Attributes.SWEEPING_DAMAGE_RATIO).add(Attributes.LUCK);
    }

    public static boolean canInsertItem(ItemStack stack) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (key != null && ((List)MaidConfig.MAID_BACKPACK_BLACKLIST.get()).contains(key.toString())) {
            return false;
        }
        return stack.getItem().canFitInsideContainerItems();
    }

    public static Ingredient getNtrItem() {
        return EntityMaid.getConfigIngredient((String)MaidConfig.MAID_NTR_ITEM.get(), Items.STRUCTURE_VOID);
    }

    private static Ingredient getConfigIngredient(String config, Item defaultItem) {
        if (config.startsWith("#")) {
            ResourceLocation key = ResourceLocation.parse((String)config.substring(1));
            TagKey tagKey = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)key);
            return Ingredient.of((TagKey)tagKey);
        }
        ResourceLocation key = ResourceLocation.parse((String)config);
        if (BuiltInRegistries.ITEM.containsKey(key)) {
            return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(key)});
        }
        return Ingredient.of((ItemLike[])new ItemLike[]{defaultItem});
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_YSM_MODEL, (Object)false);
        builder.define(DATA_YSM_MODEL_ID, (Object)"");
        builder.define(DATA_YSM_MODEL_TEXTURE, (Object)"");
        builder.define(DATA_YSM_MODEL_NAME, (Object)Component.empty());
        builder.define(DATA_MODEL_ID, (Object)DEFAULT_MODEL_ID);
        builder.define(DATA_SOUND_PACK_ID, (Object)DefaultMaidSoundPack.getInitSoundPackId());
        builder.define(DATA_TASK, (Object)TaskIdle.UID.toString());
        builder.define(DATA_BEGGING, (Object)false);
        builder.define(DATA_INVULNERABLE, (Object)false);
        builder.define(DATA_HUNGER, (Object)0);
        builder.define(DATA_FAVORABILITY, (Object)0);
        builder.define(DATA_EXPERIENCE, (Object)0);
        builder.define(DATA_STRUCK_BY_LIGHTNING, (Object)false);
        builder.define(DATA_IS_CHARGING_CROSSBOW, (Object)false);
        builder.define(DATA_ARM_RISE, (Object)false);
        builder.define(SCHEDULE_MODE, (Object)MaidSchedule.DAY);
        builder.define(RESTRICT_CENTER, (Object)BlockPos.ZERO);
        builder.define(RESTRICT_RADIUS, (Object)Float.valueOf(((Integer)MaidConfig.MAID_NON_HOME_RANGE.get()).floatValue()));
        builder.define(CHAT_BUBBLE, (Object)MaidChatBubbles.DEFAULT);
        builder.define(BACKPACK_TYPE, (Object)EmptyBackpack.ID.toString());
        builder.define(BACKPACK_ITEM_SHOW, (Object)ItemStack.EMPTY);
        builder.define(BACKPACK_FLUID, (Object)"");
        builder.define(TASK_DATA_SYNC, (Object)new CompoundTag());
        if (this.configManager == null) {
            this.configManager = new MaidConfigManager(this.entityData);
        }
        this.configManager.defineSynchedData(builder);
        if (this.gameRecordManager == null) {
            this.gameRecordManager = new MaidGameRecordManager(this);
        }
        this.gameRecordManager.defineSynchedData(builder);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (this.level.isClientSide && TASK_DATA_SYNC.equals(key)) {
            this.taskDataMaps.readFromServer(this.getSyncTaskData());
        }
    }

    @Nullable
    public <T> T getData(TaskDataKey<T> dataKey) {
        return this.taskDataMaps.getData(dataKey);
    }

    public <T> T getOrCreateData(TaskDataKey<T> dataKey, T defaultValue) {
        return this.taskDataMaps.getOrCreateData(dataKey, defaultValue);
    }

    public <T> void setData(TaskDataKey<T> dataKey, T value) {
        this.taskDataMaps.setData(dataKey, value);
    }

    public <T> void setAndSyncData(TaskDataKey<T> dataKey, T value) {
        this.setData(dataKey, value);
        this.syncTaskDataMaps = true;
    }

    protected PathNavigation createNavigation(Level levelIn) {
        return new MaidPathNavigation((Mob)this, levelIn);
    }

    public Brain<EntityMaid> getBrain() {
        return super.getBrain();
    }

    protected Brain.Provider<EntityMaid> brainProvider() {
        return Brain.provider(MaidBrain.getMemoryTypes(), MaidBrain.getSensorTypes());
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamicIn) {
        Brain brain = this.brainProvider().makeBrain(dynamicIn);
        MaidBrain.registerBrainGoals((Brain<EntityMaid>)brain, this);
        return brain;
    }

    public void refreshBrain(ServerLevel serverWorldIn) {
        Brain<EntityMaid> brain = this.getBrain();
        brain.stopAll(serverWorldIn, (LivingEntity)this);
        this.brain = brain.copyWithoutBehaviors();
        MaidBrain.registerBrainGoals(this.getBrain(), this);
    }

    protected void customServerAiStep() {
        long timeRecord = Util.getNanos();
        this.level.getProfiler().push("maidBrain");
        if (!this.guiOpening) {
            this.getBrain().tick((ServerLevel)this.level, (LivingEntity)this);
        }
        this.level.getProfiler().pop();
        timeRecord = Util.getNanos() - timeRecord;
        if (((Boolean)ServerConfig.MAID_AI_TIME_DEBUG.get()).booleanValue() && timeRecord > WARNING_TIME_NANOS) {
            double timeMs = (double)timeRecord / 1000000.0;
            BlockPos blockPos = this.blockPosition();
            String taskId = this.getTask().getUid().toString();
            int searchRange = Math.round(this.getRestrictRadius());
            TouhouLittleMaid.LOGGER.error("Maid's AI taking too long! Time: {} ms, Pos: ({},{},{}), Task ID: {}, Search Range: {}", (Object)timeMs, (Object)blockPos.getX(), (Object)blockPos.getY(), (Object)blockPos.getZ(), (Object)taskId, (Object)searchRange);
        }
        super.customServerAiStep();
    }

    public void tick() {
        if (!((MaidTickEvent)NeoForge.EVENT_BUS.post((Event)new MaidTickEvent(this))).isCanceled()) {
            super.tick();
            this.maidBauble.fireEvent((b, s) -> {
                b.onTick(this, (ItemStack)s);
                return false;
            });
        }
        if (YsmCompat.isInstalled() && this.isYsmModel()) {
            if (this.level.isClientSide) {
                NeoForge.EVENT_BUS.post((Event)new YsmMaidClientTickEvent(this));
            }
            if (!this.level.isClientSide && this.rouletteAnimDirty) {
                this.rouletteAnimDirty = false;
                SyncYsmMaidDataPackage message = new SyncYsmMaidDataPackage(this.getId(), this.rouletteAnim, this.rouletteAnimPlaying, this.roamingVars);
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void baseTick() {
        super.baseTick();
        if (this.backpackDelay > 0) {
            --this.backpackDelay;
        }
        if (this.playerHurtSoundCount > 0) {
            --this.playerHurtSoundCount;
        }
        if (this.climbFallDelayTicks > 0) {
            --this.climbFallDelayTicks;
            this.fallDistance = 0.0f;
        }
        this.spawnPortalParticle();
        this.randomRestoreHealth();
        this.onMaidSleep();
        this.syncData();
        this.gameRecordManager.tick();
    }

    public void rideTick() {
        super.rideTick();
        if (this.getVehicle() != null) {
            Entity vehicle = this.getVehicle();
            this.setYHeadRot(vehicle.getYRot());
            this.setYBodyRot(vehicle.getYRot());
        }
    }

    private void syncData() {
        if (!this.level.isClientSide && this.syncTaskDataMaps) {
            this.setSyncTaskData(this.taskDataMaps.getUpdateTag());
            this.syncTaskDataMaps = false;
        }
    }

    private void onMaidSleep() {
        if (this.isSleeping()) {
            this.getSleepingPos().ifPresent(pos -> this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5));
            this.setDeltaMovement(Vec3.ZERO);
            if (!this.isSilent()) {
                this.setSilent(true);
            }
        } else if (this.isSilent()) {
            this.setSilent(false);
        }
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
        this.navigationManager.tick();
        if (!this.level.isClientSide) {
            ChatBubbleManger.tick(this);
            if (this.backpackData != null) {
                this.level.getProfiler().push("maidBackpackData");
                this.backpackData.serverTick(this);
                this.level.getProfiler().pop();
            }
            this.level.getProfiler().push("maidFavorability");
            this.favorabilityManager.tick();
            this.level.getProfiler().pop();
            this.level.getProfiler().push("maidSchedulePos");
            this.schedulePos.tick(this);
            this.level.getProfiler().pop();
            this.level.getProfiler().push("maidCooldowns");
            this.cooldowns.tick();
            if (this.passiveUseShieldTick > 0) {
                --this.passiveUseShieldTick;
                if (this.passiveUseShieldTick == 1 && this.isUsingItem() && this.getUsedItemHand() == InteractionHand.OFF_HAND) {
                    this.stopUsingItem();
                }
            }
            this.level.getProfiler().pop();
        }
    }

    public InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        if (playerIn instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        if (hand == InteractionHand.MAIN_HAND && this.isOwnedBy((LivingEntity)playerIn)) {
            ItemStack stack = playerIn.getMainHandItem();
            InteractMaidEvent event = new InteractMaidEvent(playerIn, this, stack);
            if (((InteractMaidEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() || stack.interactLivingEntity(playerIn, (LivingEntity)this, hand).consumesAction() || this.openMaidGui(playerIn)) {
                return InteractionResult.SUCCESS;
            }
        } else {
            return this.tameMaid(playerIn.getItemInHand(hand), playerIn);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tameMaid(ItemStack stack, Player player) {
        MaidNumAttachment cap = (MaidNumAttachment)player.getData(InitDataAttachment.MAID_NUM);
        if (cap.canAdd() || player.isCreative()) {
            boolean isNormal = !this.isTame() && this.getTamedItem().test(stack);
            boolean isNtr = EntityMaid.getNtrItem().test(stack);
            if (isNormal || isNtr) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                    cap.add();
                }
                this.tame(player);
                this.navigation.stop();
                this.setTarget(null);
                this.brain.eraseMemory(MemoryModuleType.ATTACK_TARGET);
                this.level.broadcastEntityEvent((Entity)this, (byte)7);
                this.playSound((SoundEvent)InitSounds.MAID_TAMED.get(), 1.0f, 1.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "tamed_maid");
                    if (this.isStructureSpawn()) {
                        ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "tamed_maid_from_structure");
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (player instanceof ServerPlayer) {
            MutableComponent msg = Component.translatable((String)"message.touhou_little_maid.owner_maid_num.can_not_add", (Object[])new Object[]{cap.get(), cap.getMaxNum()});
            player.sendSystemMessage((Component)msg);
        }
        return InteractionResult.PASS;
    }

    protected void pushEntities() {
        List entityList;
        super.pushEntities();
        if (this.isPickup() && this.isTame() && !(entityList = this.level.getEntities((Entity)this, this.getBoundingBox().inflate(0.5, 0.0, 0.5), this::canPickup)).isEmpty() && this.isAlive()) {
            for (Entity entityPickup : entityList) {
                if (entityPickup instanceof ItemEntity) {
                    this.pickupItem((ItemEntity)entityPickup, false);
                }
                if (entityPickup instanceof ExperienceOrb) {
                    this.pickupXPOrb((ExperienceOrb)entityPickup);
                }
                if (entityPickup instanceof EntityPowerPoint) {
                    this.pickupPowerPoint((EntityPowerPoint)entityPickup);
                }
                if (!(entityPickup instanceof AbstractArrow)) continue;
                this.pickupArrow((AbstractArrow)entityPickup, false);
            }
        }
    }

    public boolean pickupItem(ItemEntity entityItem, boolean simulate) {
        if (!this.level.isClientSide && entityItem.isAlive() && !entityItem.hasPickUpDelay()) {
            ItemStack itemstack = entityItem.getItem();
            if (!EntityMaid.canInsertItem(itemstack)) {
                return false;
            }
            int count = itemstack.getCount();
            if (count == (itemstack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableInv(false), (ItemStack)itemstack, (boolean)simulate)).getCount()) {
                return false;
            }
            if (!simulate) {
                this.take((Entity)entityItem, count - itemstack.getCount());
                if (!((MaidPlaySoundEvent)NeoForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))).isCanceled()) {
                    --this.pickupSoundCount;
                    if (this.pickupSoundCount == 0) {
                        this.playSound((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                        this.pickupSoundCount = 5;
                    }
                }
                if (itemstack.isEmpty()) {
                    entityItem.discard();
                } else {
                    entityItem.setItem(itemstack);
                }
            }
            return true;
        }
        return false;
    }

    public void pickupXPOrb(ExperienceOrb entityXPOrb) {
        if (!this.level.isClientSide && entityXPOrb.isAlive() && entityXPOrb.tickCount > 2) {
            ItemStack itemstack;
            Optional entry;
            this.take((Entity)entityXPOrb, 1);
            if (!((MaidPlaySoundEvent)NeoForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))).isCanceled()) {
                --this.pickupSoundCount;
                if (this.pickupSoundCount == 0) {
                    this.playSound((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                    this.pickupSoundCount = 5;
                }
            }
            if ((entry = EnchantmentHelper.getRandomItemWith((DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP, (LivingEntity)this, ItemStack::isDamaged)).isPresent() && !(itemstack = ((EnchantedItemInUse)entry.get()).itemStack()).isEmpty() && itemstack.isDamaged()) {
                int i = Math.min((int)((float)entityXPOrb.value * itemstack.getXpRepairRatio()), itemstack.getDamageValue());
                entityXPOrb.value -= i / 2;
                itemstack.setDamageValue(itemstack.getDamageValue() - i);
            }
            if (entityXPOrb.value > 0) {
                this.setExperience(this.getExperience() + entityXPOrb.value);
            }
            entityXPOrb.discard();
        }
    }

    public void pickupPowerPoint(EntityPowerPoint powerPoint) {
        if (!this.level.isClientSide && powerPoint.isAlive() && powerPoint.throwTime == 0) {
            powerPoint.take((Entity)this, 1);
            if (!((MaidPlaySoundEvent)NeoForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))).isCanceled()) {
                --this.pickupSoundCount;
                if (this.pickupSoundCount == 0) {
                    this.playSound((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                    this.pickupSoundCount = 5;
                }
            }
            ItemStack itemstack = this.getRandomItemWithMendingEnchantments();
            int xpValue = EntityPowerPoint.transPowerValueToXpValue(powerPoint.getValue());
            if (!itemstack.isEmpty() && itemstack.isDamaged()) {
                int i = Math.min((int)((float)xpValue * itemstack.getXpRepairRatio()), itemstack.getDamageValue());
                xpValue -= i / 2;
                itemstack.setDamageValue(itemstack.getDamageValue() - i);
            }
            if (xpValue > 0) {
                this.setExperience(this.getExperience() + xpValue);
            }
            powerPoint.discard();
        }
    }

    private ItemStack getRandomItemWithMendingEnchantments() {
        ArrayList stacks = Lists.newArrayList();
        RegistryAccess access = this.level.registryAccess();
        IItemHandler itemHandler = (IItemHandler)this.getCapability(Capabilities.ItemHandler.ENTITY, null);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack itemstack = itemHandler.getStackInSlot(i);
                if (itemstack.isEmpty() || EnchantmentKeys.getEnchantmentLevel(access, (ResourceKey<Enchantment>)Enchantments.MENDING, itemstack) <= 0 || !itemstack.isDamaged()) continue;
                stacks.add(itemstack);
            }
        }
        return stacks.isEmpty() ? ItemStack.EMPTY : (ItemStack)stacks.get(this.getRandom().nextInt(stacks.size()));
    }

    public boolean pickupArrow(AbstractArrow arrow, boolean simulate) {
        if (!this.level.isClientSide && arrow.isAlive() && arrow.shakeTime <= 0) {
            if (arrow.pickup != AbstractArrow.Pickup.ALLOWED) {
                return false;
            }
            ItemStack stack = this.getArrowFromEntity(arrow);
            if (stack.isEmpty()) {
                return false;
            }
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableInv(false), (ItemStack)stack, (boolean)simulate).isEmpty()) {
                return false;
            }
            if (!simulate) {
                this.take((Entity)arrow, 1);
                if (!((MaidPlaySoundEvent)NeoForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))).isCanceled()) {
                    --this.pickupSoundCount;
                    if (this.pickupSoundCount == 0) {
                        this.playSound((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                        this.pickupSoundCount = 5;
                    }
                }
                arrow.discard();
            }
            return true;
        }
        return false;
    }

    private ItemStack getArrowFromEntity(AbstractArrow entity) {
        MixinArrowEntity mixinArrow;
        if (entity instanceof MixinArrowEntity && ((mixinArrow = (MixinArrowEntity)entity).tlmInGround() || entity.isNoPhysics())) {
            return mixinArrow.getTlmPickupItem();
        }
        return ItemStack.EMPTY;
    }

    public boolean isWithinMeleeAttackRange(LivingEntity target) {
        int attackDistance = this.favorabilityManager.getAttackDistanceByPoint(this.getFavorability());
        return this.distanceTo((Entity)target) < (float)attackDistance;
    }

    public boolean doHurtTarget(Entity target) {
        IAttackTask attackTask;
        boolean result = super.doHurtTarget(target);
        if (result) {
            this.doSweepHurt(target);
        }
        this.getMainHandItem().hurtAndBreak(1, (LivingEntity)this, EquipmentSlot.MAINHAND);
        IMaidTask iMaidTask = this.getTask();
        if (iMaidTask instanceof IAttackTask && (attackTask = (IAttackTask)iMaidTask).hasExtraAttack(this, target)) {
            boolean extraResult = attackTask.doExtraAttack(this, target);
            return result && extraResult;
        }
        return result;
    }

    private void doSweepHurt(Entity target) {
        ItemStack mainhandItem = this.getItemInHand(InteractionHand.MAIN_HAND);
        boolean canSweep = mainhandItem.canPerformAction(ItemAbilities.SWORD_SWEEP);
        float sweepingDamageRatio = (float)this.getAttributes().getValue(Attributes.SWEEPING_DAMAGE_RATIO);
        if (canSweep && sweepingDamageRatio > 0.0f) {
            float baseDamage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
            float sweepDamage = 1.0f + sweepingDamageRatio * baseDamage;
            AABB sweepRange = this.getFavorabilityManager().getSweepRange(target, this.getFavorability());
            List hurtEntities = this.level.getEntitiesOfClass(LivingEntity.class, sweepRange);
            for (LivingEntity entity : hurtEntities) {
                if (entity == this || entity == target || this.isAlliedTo((Entity)entity) || !this.canAttack(entity) || !this.canAttackType(entity.getType())) continue;
                float posX = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
                float posY = -Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
                entity.knockback(0.4, (double)posX, (double)posY);
                entity.hurt(this.damageSources().mobAttack((LivingEntity)this), sweepDamage);
            }
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, this.getSoundSource(), 1.0f, 1.0f);
            this.spawnSweepAttackParticle();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Player player;
        if (((MaidAttackEvent)NeoForge.EVENT_BUS.post((Event)new MaidAttackEvent(this, source, amount))).isCanceled()) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player && this.isAlliedTo((Entity)(player = (Player)entity))) {
            amount = Mth.clamp((float)(amount / 5.0f), (float)0.0f, (float)2.0f);
            return super.hurt(source, amount);
        }
        if (source.is(DamageTypeTags.IS_PROJECTILE) && this.canUseShield()) {
            boolean isUsingShield;
            boolean bl = isUsingShield = this.isUsingItem() && this.getUsedItemHand() == InteractionHand.OFF_HAND;
            if (!isUsingShield) {
                this.startUsingItem(InteractionHand.OFF_HAND);
                this.passiveUseShieldTick = 100;
            }
        }
        return super.hurt(source, amount);
    }

    protected void actuallyHurt(DamageSource damageSrc, float damageAmount) {
        if (!this.isInvulnerableTo(damageSrc) && this.damageContainers != null) {
            MaidDamageEvent maidDamageEvent;
            float damageAfterAbsorption;
            Entity entity;
            DamageContainer peek = (DamageContainer)this.damageContainers.peek();
            float armorAbsorb = this.getDamageAfterArmorAbsorb(damageSrc, peek.getNewDamage());
            peek.setReduction(DamageContainer.Reduction.ARMOR, peek.getNewDamage() - armorAbsorb);
            this.getDamageAfterMagicAbsorb(damageSrc, peek.getNewDamage());
            MaidHurtEvent maidHurtEvent = new MaidHurtEvent(this, damageSrc, peek.getNewDamage());
            damageAmount = ((MaidHurtEvent)NeoForge.EVENT_BUS.post((Event)maidHurtEvent)).isCanceled() ? 0.0f : maidHurtEvent.getAmount();
            peek.setReduction(DamageContainer.Reduction.ABSORPTION, peek.getNewDamage() - damageAmount);
            float damage = CommonHooks.onLivingDamagePre((LivingEntity)this, (DamageContainer)peek);
            peek.setReduction(DamageContainer.Reduction.ABSORPTION, Math.min(this.getAbsorptionAmount(), damage));
            float damageDealtAbsorbed = Math.min(damage, peek.getReduction(DamageContainer.Reduction.ABSORPTION));
            this.setAbsorptionAmount(Math.max(0.0f, this.getAbsorptionAmount() - damageDealtAbsorbed));
            if (0.0f < damageDealtAbsorbed && (double)damageDealtAbsorbed < 3.5 && (entity = damageSrc.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.awardStat(Stats.DAMAGE_DEALT_ABSORBED, Math.round(damageDealtAbsorbed * 10.0f));
            }
            float f = damageAfterAbsorption = ((MaidDamageEvent)NeoForge.EVENT_BUS.post((Event)(maidDamageEvent = new MaidDamageEvent(this, damageSrc, damageAfterAbsorption = peek.getNewDamage())))).isCanceled() ? 0.0f : maidDamageEvent.getAmount();
            if (damageAfterAbsorption != 0.0f) {
                this.getCombatTracker().recordDamage(damageSrc, damageAfterAbsorption);
                this.setHealth(this.getHealth() - damageAfterAbsorption);
                this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE);
                this.onDamageTaken(peek);
            }
            CommonHooks.onLivingDamagePost((LivingEntity)this, (DamageContainer)peek);
        }
    }

    @Nullable
    public Entity changeDimension(DimensionTransition pTransition) {
        if (this.level instanceof ServerLevel && !this.isRemoved()) {
            int MAX_RETRY = 16;
            for (int i = 0; i < 16; ++i) {
                if (!TeleportHelper.teleport(this)) continue;
                this.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 1, true, false));
            }
        }
        return null;
    }

    public void onAddedToLevel() {
        MaidWorldData data;
        super.onAddedToLevel();
        if (this.getOwnerUUID() != null && (data = MaidWorldData.get(this.level)) != null) {
            data.removeInfo(this);
        }
    }

    public void onRemovedFromLevel() {
        MaidWorldData data;
        super.onRemovedFromLevel();
        if (!this.level.isClientSide && this.isAlive() && this.getOwnerUUID() != null && (data = MaidWorldData.get(this.level)) != null) {
            data.addInfo(this);
        }
    }

    public void die(DamageSource cause) {
        if (!((MaidDeathEvent)NeoForge.EVENT_BUS.post((Event)new MaidDeathEvent(this, cause))).isCanceled()) {
            super.die(cause);
        }
    }

    public boolean canPickup(Entity pickupEntity, boolean checkInWater) {
        if (this.isPickup()) {
            if (checkInWater && pickupEntity.isInWater()) {
                return false;
            }
            PickType pickupType = this.configManager.getPickupType();
            if (pickupType.canPickItem() && pickupEntity instanceof ItemEntity) {
                return this.pickupItem((ItemEntity)pickupEntity, true);
            }
            if (pickupType.canPickItem() && pickupEntity instanceof AbstractArrow) {
                return this.pickupArrow((AbstractArrow)pickupEntity, true);
            }
            if (pickupType.canPickXp() && pickupEntity instanceof ExperienceOrb) {
                return true;
            }
            return pickupType.canPickXp() && pickupEntity instanceof EntityPowerPoint;
        }
        return false;
    }

    public boolean canPickup(Entity pickupEntity) {
        return this.canPickup(pickupEntity, false);
    }

    public void setChargingCrossbow(boolean isCharging) {
        this.entityData.set(DATA_IS_CHARGING_CROSSBOW, (Object)isCharging);
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.brain.getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public ItemStack getProjectile(ItemStack weaponStack) {
        if (this.getOffhandItem().getItem() instanceof FireworkRocketItem) {
            return this.getOffhandItem();
        }
        Item item = this.getMainHandItem().getItem();
        if (!(item instanceof ProjectileWeaponItem)) {
            return ItemStack.EMPTY;
        }
        ProjectileWeaponItem weaponItem = (ProjectileWeaponItem)item;
        CombinedInvWrapper handler = this.getAvailableInv(true);
        int slot = ItemsUtil.findStackSlot((IItemHandler)handler, weaponItem.getAllSupportedProjectiles());
        if (slot < 0) {
            return ItemStack.EMPTY;
        }
        return handler.getStackInSlot(slot);
    }

    public void thunderHit(ServerLevel world, LightningBolt lightning) {
        super.thunderHit(world, lightning);
        if (!this.isStruckByLightning()) {
            double beforeMaxHealth = this.getAttributeBaseValue(Attributes.MAX_HEALTH);
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(beforeMaxHealth + 20.0);
            this.setStruckByLightning(true);
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "lightning_bolt");
                if (this.getMaxHealth() >= 100.0f) {
                    ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "maid_100_healthy");
                }
            }
        }
    }

    protected void hurtArmor(DamageSource damageSource, float damage) {
        this.doHurtEquipment(damageSource, damage, new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD});
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        IMaidTask maidTask = this.getTask();
        if (maidTask instanceof IRangedAttackTask) {
            IRangedAttackTask rangedAttackTask = (IRangedAttackTask)maidTask;
            rangedAttackTask.performRangedAttack(this, target, distanceFactor);
        }
    }

    public boolean canAttackType(EntityType<?> typeIn) {
        return typeIn != EntityType.ARMOR_STAND && super.canAttackType(typeIn);
    }

    public boolean canAttack(LivingEntity target) {
        IMaidTask iMaidTask = this.getTask();
        if (iMaidTask instanceof IAttackTask) {
            IAttackTask attackTask = (IAttackTask)iMaidTask;
            return attackTask.canAttack(this, target);
        }
        return super.canAttack(target);
    }

    public void hurtAndBreak(ItemStack stack, int amount) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            stack.hurtAndBreak(amount, serverLevel, (LivingEntity)this, stackIn -> NetworkHandler.sendToNearby((Entity)this, new ItemBreakPackage(this.getId(), stackIn.getDefaultInstance())));
        }
    }

    private void randomRestoreHealth() {
        if (this.getHealth() < this.getMaxHealth() && (double)this.random.nextFloat() < 0.0025) {
            this.heal(1.0f);
            this.spawnRestoreHealthParticle(this.random.nextInt(3) + 7);
        }
    }

    private void spawnPortalParticle() {
        if (this.level.isClientSide && this.getIsInvulnerable() && this.getOwner() != null) {
            this.level.addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight() - 0.25, this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
        }
    }

    public void spawnRestoreHealthParticle(int particleCount) {
        if (this.level.isClientSide) {
            for (int i = 0; i < particleCount; ++i) {
                double xRandom = this.random.nextGaussian() * 0.02;
                double yRandom = this.random.nextGaussian() * 0.02;
                double zRandom = this.random.nextGaussian() * 0.02;
                this.level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.9f, (float)0.1f, (float)0.1f), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth() - xRandom * 10.0, this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()) - yRandom * 10.0, this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth() - zRandom * 10.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void spawnExplosionParticle() {
        if (this.level.isClientSide) {
            for (int i = 0; i < 20; ++i) {
                float mx = (this.random.nextFloat() - 0.5f) * 0.02f;
                float my = (this.random.nextFloat() - 0.5f) * 0.02f;
                float mz = (this.random.nextFloat() - 0.5f) * 0.02f;
                this.level.addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX() + (double)this.random.nextFloat() - 0.5, this.getY() + (double)this.random.nextFloat() - 0.5, this.getZ() + (double)this.random.nextFloat() - 0.5, (double)mx, (double)my, (double)mz);
            }
        }
    }

    public void spawnBubbleParticle() {
        if (this.level.isClientSide) {
            for (int i = 0; i < 8; ++i) {
                double offsetX = 2.0 * this.random.nextDouble() - 1.0;
                double offsetY = this.random.nextDouble() / 2.0;
                double offsetZ = 2.0 * this.random.nextDouble() - 1.0;
                this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.1, 0.0);
            }
        }
    }

    public void spawnHeartParticle() {
        if (this.level.isClientSide) {
            for (int i = 0; i < 8; ++i) {
                double offsetX = this.random.nextGaussian() * 0.02;
                double offsetY = this.random.nextGaussian() * 0.02;
                double offsetZ = this.random.nextGaussian() * 0.02;
                this.level.addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), offsetX, offsetY, offsetZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnRankUpParticle() {
        if (this.level.isClientSide) {
            Minecraft minecraft = Minecraft.getInstance();
            minecraft.particleEngine.createTrackingEmitter((Entity)this, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, 30);
            this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.BELL_BLOCK, this.getSoundSource(), 1.0f, 1.0f, false);
            minecraft.gui.setTitle((Component)Component.translatable((String)"message.touhou_little_maid.gomoku.rank_up.title"));
            minecraft.gui.setSubtitle((Component)Component.translatable((String)"message.touhou_little_maid.gomoku.rank_up.subtitle"));
        }
    }

    private void spawnSweepAttackParticle() {
        double xOffset = -Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
        double zOffset = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, this.getX() + xOffset, this.getY(0.5), this.getZ() + zOffset, 0, xOffset, 0.0, zOffset, 0.0);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString(MODEL_ID_TAG, this.getModelId());
        compound.putBoolean(IS_YSM_MODEL_TAG, this.isYsmModel());
        compound.putString(YSM_MODEL_ID_TAG, this.getYsmModelId());
        compound.putString(YSM_MODEL_TEXTURE_TAG, this.getYsmModelTexture());
        compound.putString(YSM_MODEL_NAME_TAG, Component.Serializer.toJson((Component)this.getYsmModelName(), (HolderLookup.Provider)this.registryAccess()));
        compound.putString(YSM_ROULETTE_ANIM_TAG, this.rouletteAnim);
        compound.putInt(YSM_ROAMING_UPDATE_FLAG_TAG, this.roamingVarsUpdateFlag);
        CompoundTag roamingVarsTag = new CompoundTag();
        this.roamingVars.forEach((arg_0, arg_1) -> ((CompoundTag)roamingVarsTag).putFloat(arg_0, arg_1));
        compound.put(YSM_ROAMING_VARS_TAG, (Tag)roamingVarsTag);
        compound.putString(SOUND_PACK_ID_TAG, this.getSoundPackId());
        compound.putString(TASK_TAG, this.getTask().getUid().toString());
        compound.put(MAID_INVENTORY_TAG, (Tag)this.maidInv.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compound.put(MAID_BAUBLE_INVENTORY_TAG, (Tag)this.maidBauble.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compound.put(MAID_HIDE_INVENTORY_TAG, (Tag)this.hideInv.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compound.put(MAID_TASK_INVENTORY_TAG, (Tag)this.taskInv.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compound.putBoolean(STRUCK_BY_LIGHTNING_TAG, this.isStruckByLightning());
        compound.putBoolean(INVULNERABLE_TAG, this.getIsInvulnerable());
        compound.putInt(HUNGER_TAG, this.getHunger());
        compound.putInt(FAVORABILITY_TAG, this.getFavorability());
        compound.putInt(EXPERIENCE_TAG, this.getExperience());
        compound.putString(SCHEDULE_MODE_TAG, this.getSchedule().name());
        compound.putString(MAID_BACKPACK_TYPE, this.getMaidBackpackType().getId().toString());
        compound.putBoolean(STRUCTURE_SPAWN_TAG, this.structureSpawn);
        this.configManager.addAdditionalSaveData(compound);
        this.gameRecordManager.addAdditionalSaveData(compound);
        this.favorabilityManager.addAdditionalSaveData(compound);
        this.scriptBookManager.addAdditionalSaveData(compound);
        this.schedulePos.save(compound);
        if (this.backpackData != null) {
            CompoundTag tag = new CompoundTag();
            this.backpackData.save(tag, this);
            compound.put(BACKPACK_DATA_TAG, (Tag)tag);
        } else {
            compound.put(BACKPACK_DATA_TAG, (Tag)new CompoundTag());
        }
        this.taskDataMaps.writeSaveData(compound);
        this.killRecordManager.addAdditionalSaveData(compound);
        this.aiChatManager.writeToTag(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.taskDataMaps.readSaveData(compound);
        this.setSyncTaskData(this.taskDataMaps.getUpdateTag());
        if (compound.contains(MODEL_ID_TAG, 8)) {
            this.setModelId(compound.getString(MODEL_ID_TAG));
        }
        if (compound.contains(IS_YSM_MODEL_TAG, 1)) {
            this.setIsYsmModel(compound.getBoolean(IS_YSM_MODEL_TAG));
        }
        if (compound.contains(YSM_MODEL_ID_TAG, 8)) {
            this.setYsmModelId(compound.getString(YSM_MODEL_ID_TAG));
        }
        if (compound.contains(YSM_MODEL_TEXTURE_TAG, 8)) {
            this.setYsmModelTexture(compound.getString(YSM_MODEL_TEXTURE_TAG));
        }
        if (compound.contains(YSM_MODEL_NAME_TAG, 8)) {
            MutableComponent component = Component.Serializer.fromJson((String)compound.getString(YSM_MODEL_NAME_TAG), (HolderLookup.Provider)this.registryAccess());
            this.setYsmModelName((Component)Objects.requireNonNullElse(component, Component.empty()));
        }
        if (compound.contains(YSM_ROULETTE_ANIM_TAG, 8)) {
            this.rouletteAnim = compound.getString(YSM_ROULETTE_ANIM_TAG);
        }
        if (compound.contains(YSM_ROAMING_UPDATE_FLAG_TAG, 3)) {
            this.roamingVarsUpdateFlag = compound.getInt(YSM_ROAMING_UPDATE_FLAG_TAG);
        }
        if (compound.contains(YSM_ROAMING_VARS_TAG, 10)) {
            CompoundTag roamingVarsTag = compound.getCompound(YSM_ROAMING_VARS_TAG);
            roamingVarsTag.getAllKeys().forEach(key -> this.roamingVars.put(key, roamingVarsTag.getFloat(key)));
        }
        if (compound.contains(SOUND_PACK_ID_TAG, 8)) {
            this.setSoundPackId(compound.getString(SOUND_PACK_ID_TAG));
        }
        if (compound.contains(SCHEDULE_MODE_TAG, 8)) {
            this.setSchedule(MaidSchedule.valueOf(compound.getString(SCHEDULE_MODE_TAG)));
        }
        if (compound.contains(TASK_TAG, 8)) {
            ResourceLocation uid = ResourceLocation.parse((String)compound.getString(TASK_TAG));
            IMaidTask task = TaskManager.findTask(uid).orElse(TaskManager.getIdleTask());
            this.setTask(task);
        }
        if (compound.contains(BACKPACK_LEVEL_TAG, 3)) {
            int backpackLevel = compound.getInt(BACKPACK_LEVEL_TAG);
            if (backpackLevel == 1) {
                BackpackManager.findBackpack(SmallBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            if (backpackLevel == 2) {
                BackpackManager.findBackpack(MiddleBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            if (backpackLevel == 3) {
                BackpackManager.findBackpack(BigBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            compound.remove(BACKPACK_LEVEL_TAG);
        }
        if (compound.contains(MAID_INVENTORY_TAG, 10)) {
            this.maidInv.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound(MAID_INVENTORY_TAG));
        }
        if (compound.contains(MAID_BAUBLE_INVENTORY_TAG, 10)) {
            this.maidBauble.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound(MAID_BAUBLE_INVENTORY_TAG));
        }
        if (compound.contains(MAID_HIDE_INVENTORY_TAG, 10)) {
            this.hideInv.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound(MAID_HIDE_INVENTORY_TAG));
        }
        if (compound.contains(MAID_TASK_INVENTORY_TAG, 10)) {
            this.taskInv.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound(MAID_TASK_INVENTORY_TAG));
        }
        if (compound.contains(STRUCK_BY_LIGHTNING_TAG, 1)) {
            this.setStruckByLightning(compound.getBoolean(STRUCK_BY_LIGHTNING_TAG));
        }
        if (compound.contains(INVULNERABLE_TAG, 1)) {
            this.setEntityInvulnerable(compound.getBoolean(INVULNERABLE_TAG));
        }
        if (compound.contains(HUNGER_TAG, 3)) {
            this.setHunger(compound.getInt(HUNGER_TAG));
        }
        if (compound.contains(FAVORABILITY_TAG, 3)) {
            this.setFavorability(compound.getInt(FAVORABILITY_TAG));
        }
        if (compound.contains(EXPERIENCE_TAG, 3)) {
            this.setExperience(compound.getInt(EXPERIENCE_TAG));
        }
        if (compound.contains(STRUCTURE_SPAWN_TAG, 1)) {
            this.structureSpawn = compound.getBoolean(STRUCTURE_SPAWN_TAG);
        }
        if (compound.contains(RESTRICT_CENTER_TAG, 10)) {
            NbtUtils.readBlockPos((CompoundTag)compound, (String)RESTRICT_CENTER_TAG).ifPresent(blockPos -> this.schedulePos.setHomeModeEnable(this, (BlockPos)blockPos));
            compound.remove(RESTRICT_CENTER_TAG);
        }
        if (compound.contains(MAID_BACKPACK_TYPE, 8)) {
            ResourceLocation id = ResourceLocation.parse((String)compound.getString(MAID_BACKPACK_TYPE));
            IMaidBackpack backpack = BackpackManager.findBackpack(id).orElse(BackpackManager.getEmptyBackpack());
            this.setMaidBackpackType(backpack);
            if (this.backpackData != null && compound.contains(BACKPACK_DATA_TAG, 10)) {
                this.backpackData.load(compound.getCompound(BACKPACK_DATA_TAG), this);
            }
        }
        this.configManager.readAdditionalSaveData(compound);
        this.gameRecordManager.readAdditionalSaveData(compound);
        this.favorabilityManager.readAdditionalSaveData(compound);
        this.scriptBookManager.readAdditionalSaveData(compound);
        this.schedulePos.load(compound, this);
        this.setBackpackShowItem(this.maidInv.getStackInSlot(5));
        this.killRecordManager.readAdditionalSaveData(compound);
        this.aiChatManager.readFromTag(compound);
    }

    public boolean openMaidGui(Player player) {
        return this.openMaidGui(player, 0);
    }

    public boolean openMaidGui(Player player, int tabIndex) {
        if (player instanceof ServerPlayer && !this.isSleeping()) {
            this.navigation.stop();
            player.openMenu(this.getGuiProvider(tabIndex), buffer -> buffer.writeInt(this.getId()));
        }
        return true;
    }

    private MenuProvider getGuiProvider(int tabIndex) {
        return switch (tabIndex) {
            case 1 -> this.task.getTaskConfigGuiProvider(this);
            case 2 -> MaidConfigContainer.create(this.getId());
            default -> this.getMaidBackpackType().getGuiProvider(this.getId());
        };
    }

    protected void dropEquipment() {
        if (this.getOwnerUUID() != null && !this.level.isClientSide) {
            Vec3 position = Vec3.atBottomCenterOf((Vec3i)this.blockPosition());
            if (this.getY() < (double)(this.level.getMinBuildHeight() + 5)) {
                position = new Vec3(position.x, (double)(this.level.getMinBuildHeight() + 5), position.z);
            }
            if (this.getY() > (double)this.level.getMaxBuildHeight()) {
                position = new Vec3(position.x, (double)this.level.getMaxBuildHeight(), position.z);
            }
            EntityTombstone tombstone = new EntityTombstone(this.level, this.getOwnerUUID(), position);
            tombstone.setMaidName(this.getDisplayName());
            CombinedInvWrapper invWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.maidInv, this.maidBauble, this.hideInv, this.taskInv});
            for (int i = 0; i < invWrapper.getSlots(); ++i) {
                int size = invWrapper.getSlotLimit(i);
                tombstone.insertItem(invWrapper.extractItem(i, size, false));
            }
            IMaidBackpack maidBackpack = this.getMaidBackpackType();
            tombstone.insertItem(maidBackpack.getTakeOffItemStack(ItemStack.EMPTY, null, this));
            maidBackpack.onSpawnTombstone(this, tombstone);
            ItemStack filmItem = ItemFilm.maidToFilm(this);
            tombstone.insertItem(filmItem);
            MaidWorldData maidWorldData = MaidWorldData.get(this.level);
            if (maidWorldData != null) {
                maidWorldData.addTombstones(this, tombstone);
            }
            this.alreadyDropped = true;
            this.level.addFreshEntity((Entity)tombstone);
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED && !this.alreadyDropped) {
            this.dropEquipment();
        }
        super.remove(reason);
    }

    protected void completeUsingItem() {
        this.getSwimManager().resetEatBreatheItem();
        super.completeUsingItem();
        this.backCurrentHandItemStack();
    }

    public void memoryHandItemStack(ItemStack itemStack) {
        ItemStack extractItem;
        ItemStack hideItemStack = this.getHideInv().getStackInSlot(0);
        if (!hideItemStack.isEmpty() && !(extractItem = this.getHideInv().extractItem(0, hideItemStack.getCount(), false)).isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), extractItem);
            this.level.addFreshEntity((Entity)itemEntity);
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.getHideInv(), (ItemStack)itemStack, (boolean)false);
    }

    private void backCurrentHandItemStack() {
        ItemStack stack;
        ItemStack offhandItem = this.getItemInHand(InteractionHand.OFF_HAND);
        if (!offhandItem.isEmpty() && !(stack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableBackpackInv(), (ItemStack)offhandItem.copy(), (boolean)false)).isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), stack);
            this.level.addFreshEntity((Entity)itemEntity);
        }
        ItemStack output = this.getHideInv().extractItem(0, this.getHideInv().getStackInSlot(0).getCount(), false);
        this.setItemInHand(InteractionHand.OFF_HAND, output);
    }

    public ItemStack eat(Level level, ItemStack food, FoodProperties pFoodProperties) {
        ItemStack copy = food.copy();
        ItemStack foodAfterEat = super.eat(level, food, pFoodProperties);
        Optional converts = pFoodProperties.usingConvertsTo();
        NeoForge.EVENT_BUS.post((Event)new MaidAfterEatEvent(this, foodAfterEat.isEmpty() && converts.isPresent() ? copy : foodAfterEat));
        return foodAfterEat;
    }

    protected boolean isAlwaysExperienceDropper() {
        return true;
    }

    public int getBaseExperienceReward() {
        return this.getExperience();
    }

    protected Component getTypeName() {
        if (YsmCompat.isInstalled() && this.isYsmModel()) {
            Component name = this.getYsmModelName();
            if (name.equals((Object)Component.empty())) {
                return Component.literal((String)this.getYsmModelId());
            }
            return name;
        }
        Optional<MaidModelInfo> info = ServerCustomPackLoader.SERVER_MAID_MODELS.getInfo(this.getModelId());
        return (Component)info.map(maidModelInfo -> ParseI18n.parse(maidModelInfo.getName())).orElseGet(() -> Component.literal((String)this.getType().getDescriptionId()));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        int modelSize;
        if (reason == MobSpawnType.STRUCTURE) {
            this.structureSpawn = true;
        }
        if ((modelSize = ServerCustomPackLoader.SERVER_MAID_MODELS.getModelSize()) > 0) {
            int skipRandom = this.random.nextInt(modelSize);
            Optional modelId = ServerCustomPackLoader.SERVER_MAID_MODELS.getModelIdSet().stream().skip(skipRandom).findFirst();
            return modelId.map(id -> {
                this.setModelId((String)id);
                return spawnDataIn;
            }).orElse(spawnDataIn);
        }
        return spawnDataIn;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        super.setItemSlot(slot, stack);
        if (!this.level.isClientSide) {
            NeoForge.EVENT_BUS.post((Event)new MaidEquipEvent(this, slot, stack));
        }
    }

    public void onEquipItem(EquipmentSlot slot, ItemStack oldItem, ItemStack newItem) {
        ServerPlayer serverPlayer;
        super.onEquipItem(slot, oldItem, newItem);
        if (newItem.isEmpty() || this.firstTick || !slot.isArmor()) {
            return;
        }
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)livingEntity;
            ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "any_equipment");
        }
        if (this.isNetheriteArmor(newItem)) {
            for (EquipmentSlot slotIn : EquipmentSlot.values()) {
                ItemStack itemBySlot;
                if (!slotIn.isArmor() || slotIn == slot || slotIn == EquipmentSlot.BODY || this.isNetheriteArmor(itemBySlot = this.getItemBySlot(slotIn))) continue;
                return;
            }
            LivingEntity livingEntity2 = this.getOwner();
            if (livingEntity2 instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)livingEntity2;
                ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "all_netherite_equipment");
            }
        }
    }

    private boolean isNetheriteArmor(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.getMaterial() == ArmorMaterials.NETHERITE;
        }
        return false;
    }

    public void playSound(SoundEvent soundEvent, float volume, float pitch) {
        if (soundEvent.getLocation().getPath().startsWith("maid") && !this.level.isClientSide) {
            NetworkHandler.sendToNearby((Entity)this, new PlayMaidSoundPackage(soundEvent.getLocation(), this.getSoundPackId(), this.getId()), 16);
        } else {
            super.playSound(soundEvent, volume, pitch);
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (((MaidPlaySoundEvent)NeoForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))).isCanceled()) {
            return null;
        }
        return this.task.getAmbientSound(this);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        if (((MaidPlaySoundEvent)NeoForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))).isCanceled()) {
            return null;
        }
        if (damageSourceIn.is(DamageTypeTags.IS_FIRE)) {
            return (SoundEvent)InitSounds.MAID_HURT_FIRE.get();
        }
        if (damageSourceIn.getEntity() instanceof Player) {
            if (this.playerHurtSoundCount == 0) {
                this.playerHurtSoundCount = 120;
                return (SoundEvent)InitSounds.MAID_PLAYER.get();
            }
            return null;
        }
        return (SoundEvent)InitSounds.MAID_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        if (((MaidPlaySoundEvent)NeoForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))).isCanceled()) {
            return null;
        }
        return (SoundEvent)InitSounds.MAID_DEATH.get();
    }

    public float getVoicePitch() {
        return 1.0f + this.random.nextFloat() * 0.1f;
    }

    public float getEyeHeight(Pose pPose) {
        return this.getDimensions(pPose).height() * (this.isMaidInSittingPose() ? 0.65f : 0.85f);
    }

    public boolean isBaby() {
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public boolean canHaveALeashAttachedToIt() {
        return false;
    }

    public boolean canPathReach(BlockPos pos) {
        Path path = this.getNavigation().createPath(pos, 0);
        return path != null && path.canReach();
    }

    public boolean canPathReach(Entity entity) {
        Path path = this.getNavigation().createPath(entity, 0);
        return path != null && path.canReach();
    }

    @Deprecated
    public boolean canFireProjectileWeapon(ProjectileWeaponItem shootableItem) {
        return this.getTask() instanceof IRangedAttackTask;
    }

    public boolean canSee(LivingEntity target) {
        IMaidTask iMaidTask = this.getTask();
        if (iMaidTask instanceof IRangedAttackTask) {
            IRangedAttackTask rangedTask = (IRangedAttackTask)iMaidTask;
            return rangedTask.canSee(this, target);
        }
        return BehaviorUtils.canSee((LivingEntity)this, (LivingEntity)target);
    }

    public AABB searchDimension() {
        if (this.getScheduleDetail() == Activity.WORK) {
            return this.getTask().searchDimension(this);
        }
        return TaskManager.getIdleTask().searchDimension(this);
    }

    public float searchRadius() {
        return this.getTask().searchRadius(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getBoundingBoxForCulling() {
        BedrockModel model = CustomPackLoader.MAID_MODELS.getModel(this.getModelId()).orElse(null);
        if (model == null) {
            return super.getBoundingBoxForCulling();
        }
        return model.getRenderBoundingBox().move(this.position());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getLeashOffset() {
        Optional<BedrockModel<Mob>> modelOptional = CustomPackLoader.MAID_MODELS.getModel(this.getModelId());
        Optional<MaidModelInfo> infoOptional = CustomPackLoader.MAID_MODELS.getInfo(this.getModelId());
        if (modelOptional.isPresent() && infoOptional.isPresent()) {
            BedrockModel<Mob> model = modelOptional.get();
            float renderEntityScale = infoOptional.get().getRenderEntityScale();
            if (model.hasHead()) {
                BedrockPart head = model.getHead();
                return new Vec3((double)(head.x * renderEntityScale), (1.5 - (double)(head.y / 16.0f)) * (double)renderEntityScale, (double)(head.z * renderEntityScale));
            }
        }
        return super.getLeashOffset();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double range = 64.0 * EntityMaid.getViewScale();
        return distance < range * range;
    }

    public void startSleeping(BlockPos pPos) {
        super.startSleeping(pPos);
        this.setHealth(this.getMaxHealth());
        this.favorabilityManager.apply(Type.SLEEP);
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "maid_sleep");
        }
    }

    public void setBackpackDelay() {
        this.backpackDelay = 20;
    }

    public boolean backpackHasDelay() {
        return this.backpackDelay > 0;
    }

    @Override
    public String getModelId() {
        return (String)this.entityData.get(DATA_MODEL_ID);
    }

    public void setModelId(String modelId) {
        this.entityData.set(DATA_MODEL_ID, (Object)modelId);
    }

    @Override
    public boolean isYsmModel() {
        return (Boolean)this.entityData.get(DATA_IS_YSM_MODEL);
    }

    @Override
    public void setIsYsmModel(boolean isYsmModel) {
        this.entityData.set(DATA_IS_YSM_MODEL, (Object)isYsmModel);
    }

    @Override
    public String getYsmModelId() {
        return (String)this.entityData.get(DATA_YSM_MODEL_ID);
    }

    protected void setYsmModelId(String modelId) {
        this.entityData.set(DATA_YSM_MODEL_ID, (Object)modelId);
    }

    @Override
    public String getYsmModelTexture() {
        return (String)this.entityData.get(DATA_YSM_MODEL_TEXTURE);
    }

    protected void setYsmModelTexture(String texture) {
        this.entityData.set(DATA_YSM_MODEL_TEXTURE, (Object)texture);
    }

    @Override
    public Component getYsmModelName() {
        return (Component)this.entityData.get(DATA_YSM_MODEL_NAME);
    }

    protected void setYsmModelName(Component name) {
        this.entityData.set(DATA_YSM_MODEL_NAME, (Object)name);
    }

    @Override
    public void setYsmModel(String modelId, String texture, Component name) {
        if (!modelId.equals(this.getYsmModelId())) {
            this.roamingVars = new Object2FloatOpenHashMap();
            this.stopRouletteAnim();
        }
        this.setYsmModelId(modelId);
        this.setYsmModelTexture(texture);
        this.setYsmModelName(name);
    }

    @Override
    public void playRouletteAnim(String rouletteAnim) {
        this.rouletteAnimPlaying = true;
        this.rouletteAnim = rouletteAnim;
        this.rouletteAnimDirty = true;
    }

    @Override
    public void stopRouletteAnim() {
        this.rouletteAnimPlaying = false;
        this.rouletteAnimDirty = true;
    }

    public String getSoundPackId() {
        return (String)this.entityData.get(DATA_SOUND_PACK_ID);
    }

    public void setSoundPackId(String soundPackId) {
        this.entityData.set(DATA_SOUND_PACK_ID, (Object)soundPackId);
    }

    @Override
    public boolean isMaidInSittingPose() {
        return super.isInSittingPose();
    }

    @Override
    public boolean isBegging() {
        return (Boolean)this.entityData.get(DATA_BEGGING);
    }

    public void setBegging(boolean begging) {
        this.entityData.set(DATA_BEGGING, (Object)begging);
    }

    public boolean isHomeModeEnable() {
        return this.configManager.isHomeModeEnable();
    }

    public void setHomeModeEnable(boolean enable) {
        this.configManager.setHomeModeEnable(enable);
    }

    public MaidConfigManager getConfigManager() {
        return this.configManager;
    }

    public boolean isWithinRestriction() {
        return this.isWithinRestriction(this.blockPosition());
    }

    public boolean isWithinRestriction(BlockPos pos) {
        if (this.hasRestriction()) {
            return this.getRestrictCenter().distSqr((Vec3i)pos) < (double)(this.getRestrictRadius() * this.getRestrictRadius());
        }
        return true;
    }

    public void restrictTo(BlockPos pos, int distance) {
        this.entityData.set(RESTRICT_CENTER, (Object)pos);
        this.entityData.set(RESTRICT_RADIUS, (Object)Float.valueOf(distance));
    }

    public BlockPos getRestrictCenter() {
        return (BlockPos)this.entityData.get(RESTRICT_CENTER);
    }

    public float getRestrictRadius() {
        return ((Float)this.entityData.get(RESTRICT_RADIUS)).floatValue();
    }

    public void clearRestriction() {
        this.schedulePos.clear(this);
    }

    public boolean hasRestriction() {
        return this.isHomeModeEnable();
    }

    public BlockPos getBrainSearchPos() {
        if (this.hasRestriction()) {
            return this.getRestrictCenter();
        }
        return this.blockPosition();
    }

    public boolean canBrainMoving() {
        return !this.isMaidInSittingPose() && !this.isPassenger() && !this.isSleeping() && !this.isLeashed();
    }

    public MaidChatBubbles getChatBubble() {
        return (MaidChatBubbles)this.entityData.get(CHAT_BUBBLE);
    }

    public void setChatBubble(MaidChatBubbles bubbles) {
        this.entityData.set(CHAT_BUBBLE, (Object)bubbles);
    }

    public void addChatBubble(long endTime, ChatText text) {
        ChatBubbleManger.addChatBubble(endTime, text, this);
    }

    public int getChatBubbleCount() {
        return ChatBubbleManger.getChatBubbleCount(this);
    }

    public MaidScriptBookManager getScriptBookManager() {
        return this.scriptBookManager;
    }

    public boolean isPickup() {
        return this.configManager.isPickup();
    }

    public void setPickup(boolean isPickup) {
        this.configManager.setPickup(isPickup);
    }

    public boolean isRideable() {
        return this.configManager.isRideable();
    }

    public void setRideable(boolean rideable) {
        this.configManager.setRideable(rideable);
    }

    public int getHunger() {
        return (Integer)this.entityData.get(DATA_HUNGER);
    }

    public void setHunger(int hunger) {
        this.entityData.set(DATA_HUNGER, (Object)hunger);
    }

    @Override
    public int getFavorability() {
        return (Integer)this.entityData.get(DATA_FAVORABILITY);
    }

    public void setFavorability(int favorability) {
        this.entityData.set(DATA_FAVORABILITY, (Object)favorability);
    }

    @Override
    public int getExperience() {
        return (Integer)this.entityData.get(DATA_EXPERIENCE);
    }

    public void setExperience(int experience) {
        this.entityData.set(DATA_EXPERIENCE, (Object)experience);
    }

    public boolean isStruckByLightning() {
        return (Boolean)this.entityData.get(DATA_STRUCK_BY_LIGHTNING);
    }

    public void setStruckByLightning(boolean isStruck) {
        this.entityData.set(DATA_STRUCK_BY_LIGHTNING, (Object)isStruck);
    }

    @Override
    public boolean isSwingingArms() {
        return (Boolean)this.entityData.get(DATA_ARM_RISE);
    }

    public void setSwingingArms(boolean swingingArms) {
        this.entityData.set(DATA_ARM_RISE, (Object)swingingArms);
    }

    public String getBackpackFluid() {
        return (String)this.entityData.get(BACKPACK_FLUID);
    }

    public void setBackpackFluid(String fluidName) {
        this.entityData.set(BACKPACK_FLUID, (Object)fluidName);
    }

    public MaidSchedule getSchedule() {
        return (MaidSchedule)((Object)this.entityData.get(SCHEDULE_MODE));
    }

    public void setSchedule(MaidSchedule schedule) {
        this.entityData.set(SCHEDULE_MODE, (Object)schedule);
        if (this.level instanceof ServerLevel) {
            this.refreshBrain((ServerLevel)this.level);
        }
    }

    public Activity getScheduleDetail() {
        MaidSchedule schedule = this.getSchedule();
        int time = (int)(this.level.getDayTime() % 24000L);
        switch (schedule) {
            case ALL: {
                return Activity.WORK;
            }
            case NIGHT: {
                return InitEntities.MAID_NIGHT_SHIFT_SCHEDULES.get().getActivityAt(time);
            }
        }
        return InitEntities.MAID_DAY_SHIFT_SCHEDULES.get().getActivityAt(time);
    }

    public SchedulePos getSchedulePos() {
        return this.schedulePos;
    }

    @Override
    public ItemStack getBackpackShowItem() {
        return (ItemStack)this.entityData.get(BACKPACK_ITEM_SHOW);
    }

    public void setBackpackShowItem(ItemStack stack) {
        this.entityData.set(BACKPACK_ITEM_SHOW, (Object)stack);
    }

    @Override
    public IMaidBackpack getMaidBackpackType() {
        ResourceLocation id = ResourceLocation.parse((String)((String)this.entityData.get(BACKPACK_TYPE)));
        return BackpackManager.findBackpack(id).orElse(BackpackManager.getEmptyBackpack());
    }

    public void setMaidBackpackType(IMaidBackpack backpack) {
        if (backpack == this.backpack) {
            return;
        }
        this.backpack = backpack;
        this.backpackData = this.backpack.hasBackpackData() ? this.backpack.getBackpackData(this) : null;
        this.entityData.set(BACKPACK_TYPE, (Object)backpack.getId().toString());
    }

    public IBackpackData getBackpackData() {
        return this.backpackData;
    }

    public ItemStackHandler getMaidInv() {
        return this.maidInv;
    }

    public CombinedInvWrapper getAvailableInv(boolean handsFirst) {
        RangedWrapper combinedInvWrapper = this.getAvailableBackpackInv();
        return handsFirst ? new CombinedInvWrapper(new IItemHandlerModifiable[]{this.handsInvWrapper, combinedInvWrapper}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{combinedInvWrapper, this.handsInvWrapper});
    }

    public RangedWrapper getAvailableBackpackInv() {
        return new RangedWrapper((IItemHandlerModifiable)this.maidInv, 0, this.getMaidBackpackType().getAvailableMaxContainerIndex());
    }

    public EntityHandsInvWrapper getHandsInvWrapper() {
        return this.handsInvWrapper;
    }

    public EntityArmorInvWrapper getArmorInvWrapper() {
        return this.armorInvWrapper;
    }

    public BaubleItemHandler getMaidBauble() {
        return this.maidBauble;
    }

    public CombinedInvWrapper getAllInv() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.getArmorInvWrapper(), this.getHandsInvWrapper(), this.getMaidInv(), this.getMaidBauble()});
    }

    public ItemStackHandler getHideInv() {
        return this.hideInv;
    }

    public ItemStackHandler getTaskInv() {
        return this.taskInv;
    }

    public boolean getIsInvulnerable() {
        return (Boolean)this.entityData.get(DATA_INVULNERABLE);
    }

    public void setEntityInvulnerable(boolean isInvulnerable) {
        super.setInvulnerable(isInvulnerable);
        this.entityData.set(DATA_INVULNERABLE, (Object)isInvulnerable);
    }

    @Override
    public IMaidTask getTask() {
        ResourceLocation uid = ResourceLocation.parse((String)((String)this.entityData.get(DATA_TASK)));
        return TaskManager.findTask(uid).orElse(TaskManager.getIdleTask());
    }

    public void setTask(IMaidTask task) {
        if (task == this.task) {
            return;
        }
        this.task = task;
        this.entityData.set(DATA_TASK, (Object)task.getUid().toString());
        if (this.level instanceof ServerLevel) {
            this.refreshBrain((ServerLevel)this.level);
        }
    }

    public void setInSittingPose(boolean inSittingPose) {
        super.setInSittingPose(inSittingPose);
        this.setOrderedToSit(inSittingPose);
    }

    public MaidGameRecordManager getGameRecordManager() {
        return this.gameRecordManager;
    }

    private CompoundTag getSyncTaskData() {
        return (CompoundTag)this.entityData.get(TASK_DATA_SYNC);
    }

    private void setSyncTaskData(CompoundTag compoundTag) {
        this.entityData.set(TASK_DATA_SYNC, (Object)compoundTag, true);
    }

    public float getLuck() {
        return (float)this.getAttributeValue(Attributes.LUCK);
    }

    public MaidKillRecordManager getKillRecordManager() {
        return this.killRecordManager;
    }

    @Override
    public boolean hasFishingHook() {
        return this.fishing != null;
    }

    public boolean isStructureSpawn() {
        return this.structureSpawn;
    }

    public List<SendEffectPackage.EffectData> getEffects() {
        return this.effects;
    }

    public void setEffects(List<SendEffectPackage.EffectData> effects) {
        this.effects = effects;
    }

    public boolean canDestroyBlock(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        return state.getBlock().canEntityDestroy(state, (BlockGetter)this.level, pos, (Entity)this) && EventHooks.onEntityDestroyBlock((LivingEntity)this, (BlockPos)pos, (BlockState)state);
    }

    public boolean canPlaceBlock(BlockPos pos) {
        BlockState oldState = this.level.getBlockState(pos);
        return oldState.canBeReplaced();
    }

    public boolean destroyBlock(BlockPos pos) {
        return this.destroyBlock(pos, true);
    }

    public boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        return this.canDestroyBlock(pos) && this.destroyBlock(this.level, pos, dropBlock, (Entity)this);
    }

    public boolean destroyBlock(Level level, BlockPos blockPos, boolean dropBlock, @Nullable Entity entity) {
        boolean setResult;
        BlockState blockState = level.getBlockState(blockPos);
        if (blockState.isAir()) {
            return false;
        }
        FluidState fluidState = level.getFluidState(blockPos);
        if (!(blockState.getBlock() instanceof BaseFireBlock)) {
            level.levelEvent(2001, blockPos, Block.getId((BlockState)blockState));
        }
        if (dropBlock) {
            BlockEntity blockEntity = blockState.hasBlockEntity() ? level.getBlockEntity(blockPos) : null;
            this.dropResourcesToMaidInv(blockState, level, blockPos, blockEntity, this, ItemStack.EMPTY);
        }
        if (setResult = level.setBlock(blockPos, fluidState.createLegacyBlock(), 3)) {
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, blockPos, GameEvent.Context.of((Entity)entity, (BlockState)blockState));
        }
        return setResult;
    }

    public void dropResourcesToMaidInv(BlockState state, Level level, BlockPos pos, @Nullable BlockEntity blockEntity, EntityMaid maid, ItemStack tool) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CombinedInvWrapper availableInv = this.getAvailableInv(false);
            Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)maid, (ItemStack)tool).forEach(stack -> {
                ItemStack remindItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)stack, (boolean)false);
                if (!remindItemStack.isEmpty()) {
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)remindItemStack);
                }
            });
            state.spawnAfterBreak(serverLevel, pos, tool, true);
        }
    }

    public boolean placeItemBlock(InteractionHand hand, BlockPos placePos, Direction direction, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.place(new BlockPlaceContext(this.level, null, hand, stack, this.getBlockRayTraceResult(placePos, direction))).consumesAction();
        }
        return false;
    }

    public boolean placeItemBlock(BlockPos placePos, Direction direction, ItemStack stack) {
        return this.placeItemBlock(InteractionHand.MAIN_HAND, placePos, direction, stack);
    }

    public boolean placeItemBlock(BlockPos placePos, ItemStack stack) {
        return this.placeItemBlock(placePos, Direction.UP, stack);
    }

    private BlockHitResult getBlockRayTraceResult(BlockPos pos, Direction direction) {
        return new BlockHitResult(new Vec3((double)pos.getX() + 0.5 + (double)direction.getStepX() * 0.5, (double)pos.getY() + 0.5 + (double)direction.getStepY() * 0.5, (double)pos.getZ() + 0.5 + (double)direction.getStepZ() * 0.5), direction, pos, false);
    }

    public FavorabilityManager getFavorabilityManager() {
        return this.favorabilityManager;
    }

    public Ingredient getTamedItem() {
        Ingredient configIngredient = EntityMaid.getConfigIngredient((String)MaidConfig.MAID_TAMED_ITEM.get(), Items.CAKE);
        Ingredient tagIngredient = Ingredient.of(TagItem.MAID_TAMED_ITEM);
        return this.merge(Lists.newArrayList((Object[])new Ingredient[]{configIngredient, tagIngredient}));
    }

    private Ingredient merge(Collection<Ingredient> parts) {
        return Ingredient.fromValues(parts.stream().flatMap(i -> Arrays.stream(i.getValues())));
    }

    public Ingredient getTemptationItem() {
        return EntityMaid.getConfigIngredient((String)MaidConfig.MAID_TEMPTATION_ITEM.get(), Items.CAKE);
    }

    @Override
    public EntityMaid asStrictMaid() {
        return this;
    }

    @Override
    public Mob asEntity() {
        return this;
    }

    @Override
    public ItemStack[] getHandItemsForAnimation() {
        return this.handItemsForAnimation;
    }

    public Vec3 handleOnClimbable(Vec3 deltaMovement) {
        Vec3 oriDelta = super.handleOnClimbable(deltaMovement);
        if (this.isCanClimb()) {
            Vec3 vec3 = this.position();
            if (vec3.x() % 1.0 != 0.5 || vec3.z() % 1.0 != 0.5) {
                BlockPos.MutableBlockPos currentPosition = this.blockPosition().mutable();
                Vec3 centerPos = Vec3.atBottomCenterOf((Vec3i)currentPosition);
                this.moveTo(centerPos.x, vec3.y(), centerPos.z);
            }
            oriDelta = new Vec3(0.0, oriDelta.y, 0.0);
        }
        return oriDelta;
    }

    @Override
    public boolean onClimbable() {
        Optional ladderPos;
        boolean result = false;
        Path path = this.navigation.getPath();
        if (path != null && !path.isDone()) {
            for (int i = Math.max(0, path.getNextNodeIndex() - 3); i < Math.min(path.getNodeCount(), path.getNextNodeIndex() + 3) - 1; ++i) {
                BlockPos pos1 = path.getNodePos(i);
                BlockPos pos2 = path.getNodePos(i + 1);
                if (pos1.getX() != pos2.getX() || pos1.getZ() != pos2.getZ()) continue;
                result = true;
                break;
            }
        }
        if (result && !(result = super.onClimbable()) && !this.isSpectator() && (ladderPos = CommonHooks.isLivingOnLadder((BlockState)this.level.getBlockState(this.blockPosition().below()), (Level)this.level(), (BlockPos)this.blockPosition().below(), (LivingEntity)this)).isPresent()) {
            result = true;
        }
        if (result) {
            this.climbFallDelayTicks = 30;
            this.getLastClimbablePos().ifPresent(climbablePos -> {
                BlockState blockState = this.level.getBlockState(climbablePos);
                blockState.getOptionalValue((Property)HorizontalDirectionalBlock.FACING).ifPresent(direction -> {
                    int yRot = direction.getOpposite().get2DDataValue() * 90;
                    this.setYRot(yRot);
                    this.setYHeadRot(yRot);
                });
            });
        }
        return result;
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 deltaMovement, float friction) {
        this.moveRelative(this.getFrictionInfluencedSpeed(friction), deltaMovement);
        this.setDeltaMovement(this.handleOnClimbable(this.getDeltaMovement()));
        this.move(MoverType.SELF, this.getDeltaMovement());
        return this.getDeltaMovement();
    }

    public boolean isCanClimb() {
        return this.canClimb;
    }

    public void setCanClimb(boolean canClimb) {
        this.canClimb = canClimb;
    }

    public void setNavigation(PathNavigation navigation) {
        this.navigation = navigation;
    }

    public MaidSwimManager getSwimManager() {
        return this.swimManager;
    }

    public boolean isPushedByFluid() {
        return !this.getSwimManager().wantToSwim();
    }

    public void travel(Vec3 travelVector) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            if (this.getSwimManager().wantToSwim()) {
                this.moveRelative(0.01f, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            } else if (this.getSwimManager().isReadyToLand() || this.isUnderWater()) {
                super.travel(travelVector.scale(1.2).add(0.0, 0.5, 0.0));
            } else {
                super.travel(travelVector.scale(1.2).add(0.0, 0.05, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return pose == Pose.SWIMMING ? this.getSwimManager().getSwimmingDimensions() : super.getDefaultDimensions(pose);
    }

    public void updateSwimming() {
        this.getSwimManager().updateSwimming();
    }

    public boolean isVisuallySwimming() {
        return this.isSwimming();
    }

    public boolean canUseShield() {
        ItemStack offhandItem = this.getOffhandItem();
        return offhandItem.canPerformAction(ItemAbilities.SHIELD_BLOCK) && !this.getCooldowns().isOnCooldown(offhandItem.getItem());
    }

    public boolean isBlocking() {
        return this.isUsingItem() && !this.useItem.isEmpty() && this.useItem.canPerformAction(ItemAbilities.SHIELD_BLOCK);
    }

    protected void blockUsingShield(LivingEntity attacker) {
        super.blockUsingShield(attacker);
        if (attacker.getMainHandItem().canDisableShield(this.useItem, (LivingEntity)this, attacker)) {
            this.getCooldowns().addCooldown(this.getUseItem().getItem(), 100);
            this.stopUsingItem();
            this.level.broadcastEntityEvent((Entity)this, (byte)30);
        }
    }

    protected void hurtCurrentlyUsedShield(float damage) {
        if (this.useItem.canPerformAction(ItemAbilities.SHIELD_BLOCK) && damage >= 3.0f) {
            int damageAmount = 1 + Mth.floor((float)damage);
            InteractionHand interactionhand = this.getUsedItemHand();
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                this.useItem.hurtAndBreak(damageAmount, serverlevel, (LivingEntity)this, item -> {
                    this.onEquippedItemBroken((Item)item, EntityMaid.getSlotForHand((InteractionHand)interactionhand));
                    this.stopUsingItem();
                });
            }
            if (this.useItem.isEmpty()) {
                if (interactionhand == InteractionHand.MAIN_HAND) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                } else {
                    this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                }
                this.useItem = ItemStack.EMPTY;
                this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level.random.nextFloat() * 0.4f);
            } else {
                this.playSound(SoundEvents.SHIELD_BLOCK, 1.0f, 1.0f);
            }
        }
    }

    public ItemCooldowns getCooldowns() {
        return this.cooldowns;
    }

    public MaidAIChatManager getAiChatManager() {
        return this.aiChatManager;
    }

    public MaidNavigationManager getNavigationManager() {
        return this.navigationManager;
    }

    @Nullable
    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null) {
            return null;
        }
        MinecraftServer server = this.level().getServer();
        if (server == null) {
            return this.level().getPlayerByUUID(uuid);
        }
        return server.getPlayerList().getPlayer(uuid);
    }

    public boolean teleportToOwner(LivingEntity owner) {
        BlockPos blockPos = owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(this.getRandom(), -3, 3);
            int y = this.randomIntInclusive(this.getRandom(), -1, 1);
            int z = this.randomIntInclusive(this.getRandom(), -3, 3);
            if (!this.maybeTeleportTo(owner, blockPos.getX() + x, blockPos.getY() + y, blockPos.getZ() + z)) continue;
            return true;
        }
        return false;
    }

    private boolean maybeTeleportTo(LivingEntity owner, int x, int y, int z) {
        if (this.teleportTooClosed(owner, x, z)) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.moveTo((double)x + 0.5, y, (double)z + 0.5, this.getYRot(), this.getXRot());
        this.getNavigation().stop();
        this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        this.getBrain().eraseMemory(MemoryModuleType.PATH);
        return true;
    }

    private boolean teleportTooClosed(LivingEntity owner, int x, int z) {
        return Math.abs((double)x - owner.getX()) < 2.0 && Math.abs((double)z - owner.getZ()) < 2.0;
    }

    private boolean canTeleportTo(BlockPos pos) {
        PathType pathNodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)this, (BlockPos)pos);
        if (pathNodeType == PathType.WALKABLE || pathNodeType == PathType.WATER) {
            BlockPos blockPos = pos.subtract((Vec3i)this.blockPosition());
            return this.level().noCollision((Entity)this, this.getBoundingBox().move(blockPos));
        }
        return false;
    }

    private int randomIntInclusive(RandomSource random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }
}

