/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.ICachedEvaluator;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.CenterOffsetBlockPosSet;
import com.google.common.collect.Lists;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import org.jetbrains.annotations.Nullable;

public class MaidPathFindingBFS {
    private final Node[] tmpNode = new Node[20];
    private final CenterOffsetBlockPosSet cachePos;
    private final Queue<Node> queueNode = Lists.newLinkedList();
    private final NodeEvaluator nodeEvaluator;
    private final BlockPos centerPos;
    private final double maxDistance;
    private final int verticalSearchRange;
    private boolean isFinished = false;

    public MaidPathFindingBFS(NodeEvaluator nodeEvaluator, ServerLevel level, EntityMaid maid) {
        this(nodeEvaluator, level, maid, maid.searchRadius(), 7);
    }

    public MaidPathFindingBFS(NodeEvaluator nodeEvaluator, ServerLevel level, EntityMaid maid, int verticalSearchRange) {
        this(nodeEvaluator, level, maid, maid.searchRadius(), verticalSearchRange);
    }

    public MaidPathFindingBFS(NodeEvaluator nodeEvaluator, ServerLevel level, EntityMaid maid, float maxDistance, int verticalSearchRange) {
        this.nodeEvaluator = nodeEvaluator;
        this.centerPos = maid.blockPosition();
        this.maxDistance = maxDistance;
        this.verticalSearchRange = verticalSearchRange;
        int offset = (int)Math.ceil(this.maxDistance);
        PathNavigationRegion region = new PathNavigationRegion((Level)level, this.centerPos.offset(-offset, -verticalSearchRange, -offset), this.centerPos.offset(offset, verticalSearchRange, offset));
        this.cachePos = new CenterOffsetBlockPosSet(offset + 1, verticalSearchRange + 1, offset + 1, this.centerPos.getX(), this.centerPos.getY(), this.centerPos.getZ());
        if (nodeEvaluator instanceof ICachedEvaluator) {
            ICachedEvaluator ice = (ICachedEvaluator)nodeEvaluator;
            ice.init(offset, verticalSearchRange, offset, this.centerPos.getX(), this.centerPos.getY(), this.centerPos.getZ());
        }
        nodeEvaluator.prepare(region, (Mob)maid);
        Node start = nodeEvaluator.getStart();
        if (start != null) {
            this.cachePos.markVis(start.asBlockPos());
            this.queueNode.add(start);
        }
    }

    private boolean canPathReachInternal(BlockPos pos) {
        return this.cachePos.isVis(pos) || this.cachePos.isVis(pos.above());
    }

    public boolean canPathReach(BlockPos pos) {
        if (this.canPathReachInternal(pos)) {
            return true;
        }
        if (this.isFinished) {
            return false;
        }
        while (!this.canPathReachInternal(pos) && !this.isFinished) {
            this.searchStep();
        }
        return this.canPathReachInternal(pos);
    }

    @Nullable
    private BlockPos searchStep() {
        if (this.isFinished) {
            return null;
        }
        if (this.queueNode.isEmpty()) {
            this.isFinished = true;
            return null;
        }
        Node node = this.queueNode.poll();
        int neighbors = this.nodeEvaluator.getNeighbors(this.tmpNode, node);
        for (int i = 0; i < neighbors; ++i) {
            double neighborDistance;
            BlockPos offset;
            if (this.cachePos.isVis(this.tmpNode[i].asBlockPos()) || this.verticalSearchRange < (offset = this.tmpNode[i].asBlockPos().subtract((Vec3i)this.centerPos)).getY() || offset.getY() < -this.verticalSearchRange || (neighborDistance = (double)(offset.getX() * offset.getX() + offset.getZ() * offset.getZ())) > this.maxDistance * this.maxDistance) continue;
            this.cachePos.markVis(this.tmpNode[i].asBlockPos());
            NodeEvaluator nodeEvaluator = this.nodeEvaluator;
            if (nodeEvaluator instanceof ICachedEvaluator) {
                ICachedEvaluator ice = (ICachedEvaluator)nodeEvaluator;
                ice.markVis(this.tmpNode[i].asBlockPos());
            }
            this.queueNode.add(this.tmpNode[i]);
        }
        return node.asBlockPos();
    }

    public Optional<BlockPos> find(Predicate<BlockPos> predicate) {
        while (!this.isFinished) {
            BlockPos blockPos = this.searchStep();
            if (blockPos == null || !predicate.test(blockPos)) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    public void finish() {
        this.isFinished = true;
        this.nodeEvaluator.done();
    }
}

