/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagItem;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.CropBlockAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class TaskNormalFarm
implements IFarmTask {
    private static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"farm");

    @Override
    public ResourceLocation getUid() {
        return NAME;
    }

    @Override
    public ItemStack getIcon() {
        return Items.IRON_HOE.getDefaultInstance();
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        return stack.is(TagItem.MAID_PLANTABLE_SEEDS) && stack.getItem() instanceof ItemNameBlockItem;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        CropBlock cropBlock;
        Block block = cropState.getBlock();
        if (block instanceof CropBlock && (cropBlock = (CropBlock)block).isMaxAge(cropState)) {
            return true;
        }
        return block == Blocks.NETHER_WART && (Integer)cropState.getValue((Property)NetherWartBlock.AGE) >= 3;
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        if (maid.getMainHandItem().getItem() instanceof HoeItem) {
            maid.destroyBlock(cropPos);
        } else {
            CombinedInvWrapper availableInv = maid.getAvailableInv(false);
            Block cropBlock = cropState.getBlock();
            maid.level.levelEvent(2001, cropPos, Block.getId((BlockState)cropState));
            if (cropBlock instanceof CropBlockAccessor) {
                CropBlockAccessor crop = (CropBlockAccessor)cropBlock;
                BlockEntity blockEntity = cropState.hasBlockEntity() ? maid.level.getBlockEntity(cropPos) : null;
                maid.dropResourcesToMaidInv(cropState, maid.level, cropPos, blockEntity, maid, maid.getMainHandItem());
                if (cropState.hasProperty((Property)crop.tlmAgeProperty())) {
                    try {
                        cropState = (BlockState)cropState.trySetValue((Property)crop.tlmAgeProperty(), (Comparable)Integer.valueOf(0));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                maid.level.setBlock(cropPos, cropState, 3);
                maid.level.gameEvent((Entity)maid, (Holder)GameEvent.BLOCK_CHANGE, cropPos);
                return;
            }
            if (cropBlock == Blocks.NETHER_WART) {
                ItemStack dropItemStack = new ItemStack((ItemLike)Items.NETHER_WART);
                ItemStack remindItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)dropItemStack, (boolean)false);
                if (!remindItemStack.isEmpty()) {
                    Block.popResource((Level)maid.level, (BlockPos)cropPos, (ItemStack)remindItemStack);
                }
                maid.level.setBlock(cropPos, Blocks.NETHER_WART.defaultBlockState(), 3);
                maid.level.gameEvent((Entity)maid, (Holder)GameEvent.BLOCK_CHANGE, cropPos);
            }
        }
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        BlockPos abovePos = basePos.above();
        BlockState aboveState = maid.level.getBlockState(abovePos);
        if (!aboveState.canBeReplaced() || aboveState.liquid()) {
            return false;
        }
        Item item = seed.getItem();
        if (item instanceof ItemNameBlockItem) {
            ItemNameBlockItem blockNamedItem = (ItemNameBlockItem)item;
            BlockState plantBlockState = blockNamedItem.getBlock().defaultBlockState();
            return plantBlockState.canSurvive((LevelReader)maid.level, abovePos);
        }
        return false;
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        maid.placeItemBlock(basePos.above(), seed);
        return seed;
    }
}

