/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber
public class EntityDeathEvent {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Entity causingEntity = event.getSource().getEntity();
        if (causingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)causingEntity;
            maid.getKillRecordManager().onTargetDeath(maid, event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        Player newEntity = event.getEntity();
        Player oldEntity = event.getOriginal();
        boolean wasDeath = event.isWasDeath();
        boolean isKeep = newEntity.level.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
        PowerAttachment power = (PowerAttachment)oldEntity.getData(InitDataAttachment.POWER_NUM);
        MaidNumAttachment maidNum = (MaidNumAttachment)oldEntity.getData(InitDataAttachment.MAID_NUM);
        if (wasDeath && !isKeep) {
            power.min(((Double)MiscConfig.PLAYER_DEATH_LOSS_POWER_POINT.get()).floatValue());
        }
        newEntity.setData(InitDataAttachment.POWER_NUM, (Object)power);
        newEntity.setData(InitDataAttachment.MAID_NUM, (Object)maidNum);
    }
}

