/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimatableEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.AnimationPoint;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.BoneAnimationQueue;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager.AnimationData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.AnimationContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.storage.IForeignVariableStorage;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.storage.VariableStorage;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.util.StringPool;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.value.IValue;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor.IBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor.PointData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.snapshot.BoneSnapshot;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.snapshot.BoneTopLevelSnapshot;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.MathUtil;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.RateLimiter;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.ExpressionEvaluator;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AnimationProcessor<T extends AnimatableEntity<?>> {
    private static final int ROAMING_STRUCT_NAME = StringPool.computeIfAbsent("roaming");
    private final ReferenceArrayList<BoneTopLevelSnapshot> modelRendererList = new ReferenceArrayList();
    private final Object2ReferenceOpenHashMap<String, BoneTopLevelSnapshot> modelRendererMap = new Object2ReferenceOpenHashMap();
    private final VariableStorage animationStorage = new VariableStorage();
    private final Random random = new Random();
    private final ConcurrentLinkedQueue<Pair<IValue, Consumer<String>>> pendingValues = new ConcurrentLinkedQueue();
    private final RateLimiter rateLimiter = new RateLimiter(Minecraft.getInstance().getWindow().getRefreshRate());
    private final T animatable;
    private List<IValue> initializationValues;
    private List<IValue> preAnimationValues;
    private boolean rendererDirty = false;
    public boolean reloadAnimations = false;

    public AnimationProcessor(T animatable) {
        this.animatable = animatable;
    }

    public boolean tickAnimation(double seekTime, AnimationEvent<T> event, AnimationContext<?> ctx) {
        boolean shouldUpdate = this.rateLimiter.request((float)(seekTime / 20.0));
        ctx.setStorage(this.animationStorage);
        ctx.setRandom(this.random);
        ExpressionEvaluator<AnimationContext<?>> evaluator = ExpressionEvaluator.evaluator(ctx);
        this.preProcess(evaluator);
        AnimationData manager = ((AnimatableEntity)this.animatable).getAnimationData();
        for (AnimationController controller : manager.getAnimationControllers()) {
            if (this.reloadAnimations) {
                controller.markNeedsReload();
                controller.getBoneAnimationQueues().clear();
            }
            controller.isJustStarting = manager.isFirstTick;
            event.setController(controller);
            controller.process(seekTime, event, evaluator, (List<BoneTopLevelSnapshot>)this.modelRendererList, false, this.rendererDirty, shouldUpdate);
            boolean isParallelController = controller.getName().startsWith("parallel_");
            for (BoneAnimationQueue boneAnimation : controller.getBoneAnimationQueues()) {
                Vector3f scale;
                BoneTopLevelSnapshot snapshot = boneAnimation.topLevelSnapshot;
                BoneSnapshot initialSnapshot = snapshot.bone.getInitialSnapshot();
                PointData pointData = snapshot.cachedPointData;
                if (!boneAnimation.rotationQueue().isEmpty()) {
                    scale = ((AnimationPoint)boneAnimation.rotationQueue().poll()).getLerpPoint(evaluator);
                    pointData.rotationValueX += scale.x();
                    pointData.rotationValueY += scale.y();
                    pointData.rotationValueZ += scale.z();
                    if (isParallelController) {
                        snapshot.rotationValueX = pointData.rotationValueX + initialSnapshot.rotationValueX;
                        snapshot.rotationValueY = pointData.rotationValueY + initialSnapshot.rotationValueY;
                        snapshot.rotationValueZ = pointData.rotationValueZ + initialSnapshot.rotationValueZ;
                    } else {
                        snapshot.rotationValueX = scale.x() + initialSnapshot.rotationValueX;
                        snapshot.rotationValueY = scale.y() + initialSnapshot.rotationValueY;
                        snapshot.rotationValueZ = scale.z() + initialSnapshot.rotationValueZ;
                    }
                    snapshot.isCurrentlyRunningRotationAnimation = true;
                }
                if (!boneAnimation.positionQueue().isEmpty()) {
                    Vector3f position = ((AnimationPoint)boneAnimation.positionQueue().poll()).getLerpPoint(evaluator);
                    snapshot.positionOffsetX = position.x();
                    snapshot.positionOffsetY = position.y();
                    snapshot.positionOffsetZ = position.z();
                    snapshot.isCurrentlyRunningPositionAnimation = true;
                }
                if (boneAnimation.scaleQueue().isEmpty()) continue;
                scale = ((AnimationPoint)boneAnimation.scaleQueue().poll()).getLerpPoint(evaluator);
                snapshot.scaleValueX = scale.x();
                snapshot.scaleValueY = scale.y();
                snapshot.scaleValueZ = scale.z();
                snapshot.isCurrentlyRunningScaleAnimation = true;
            }
        }
        this.rendererDirty = false;
        this.reloadAnimations = false;
        double resetTickLength = manager.getResetSpeed();
        for (BoneTopLevelSnapshot topLevelSnapshot : this.modelRendererList) {
            double percentageReset;
            BoneSnapshot initialSnapshot = topLevelSnapshot.bone.getInitialSnapshot();
            if (!topLevelSnapshot.isCurrentlyRunningRotationAnimation) {
                percentageReset = Math.min((seekTime - (double)topLevelSnapshot.mostRecentResetRotationTick) / resetTickLength, 1.0);
                if (percentageReset >= 1.0) {
                    topLevelSnapshot.rotationValueX = MathUtil.lerpValues(percentageReset, topLevelSnapshot.rotationValueX, initialSnapshot.rotationValueX);
                    topLevelSnapshot.rotationValueY = MathUtil.lerpValues(percentageReset, topLevelSnapshot.rotationValueY, initialSnapshot.rotationValueY);
                    topLevelSnapshot.rotationValueZ = MathUtil.lerpValues(percentageReset, topLevelSnapshot.rotationValueZ, initialSnapshot.rotationValueZ);
                }
            } else {
                topLevelSnapshot.mostRecentResetRotationTick = 0.0f;
                topLevelSnapshot.isCurrentlyRunningRotationAnimation = false;
            }
            if (!topLevelSnapshot.isCurrentlyRunningPositionAnimation) {
                percentageReset = Math.min((seekTime - (double)topLevelSnapshot.mostRecentResetPositionTick) / resetTickLength, 1.0);
                if (percentageReset >= 1.0) {
                    topLevelSnapshot.positionOffsetX = MathUtil.lerpValues(percentageReset, topLevelSnapshot.positionOffsetX, initialSnapshot.positionOffsetX);
                    topLevelSnapshot.positionOffsetY = MathUtil.lerpValues(percentageReset, topLevelSnapshot.positionOffsetY, initialSnapshot.positionOffsetY);
                    topLevelSnapshot.positionOffsetZ = MathUtil.lerpValues(percentageReset, topLevelSnapshot.positionOffsetZ, initialSnapshot.positionOffsetZ);
                }
            } else {
                topLevelSnapshot.mostRecentResetPositionTick = (float)seekTime;
                topLevelSnapshot.isCurrentlyRunningPositionAnimation = false;
            }
            if (!topLevelSnapshot.isCurrentlyRunningScaleAnimation) {
                percentageReset = Math.min((seekTime - (double)topLevelSnapshot.mostRecentResetScaleTick) / resetTickLength, 1.0);
                if (percentageReset >= 1.0) {
                    topLevelSnapshot.scaleValueX = MathUtil.lerpValues(percentageReset, topLevelSnapshot.scaleValueX, initialSnapshot.scaleValueX);
                    topLevelSnapshot.scaleValueY = MathUtil.lerpValues(percentageReset, topLevelSnapshot.scaleValueY, initialSnapshot.scaleValueY);
                    topLevelSnapshot.scaleValueZ = MathUtil.lerpValues(percentageReset, topLevelSnapshot.scaleValueZ, initialSnapshot.scaleValueZ);
                }
            } else {
                topLevelSnapshot.mostRecentResetScaleTick = (float)seekTime;
                topLevelSnapshot.isCurrentlyRunningScaleAnimation = false;
            }
            topLevelSnapshot.commit();
        }
        manager.isFirstTick = false;
        this.postProcess(evaluator);
        return true;
    }

    @Nullable
    public IBone getBone(String boneName) {
        BoneTopLevelSnapshot renderer = (BoneTopLevelSnapshot)this.modelRendererMap.get((Object)boneName);
        return renderer != null ? renderer.bone : null;
    }

    public void registerModelRenderer(Map<String, IBone> boneMap) {
        this.modelRendererMap.clear();
        this.modelRendererList.clear();
        this.modelRendererList.ensureCapacity(boneMap.size());
        for (Map.Entry<String, IBone> entry : boneMap.entrySet()) {
            BoneTopLevelSnapshot renderer = new BoneTopLevelSnapshot(entry.getValue());
            this.modelRendererMap.put((Object)entry.getKey(), (Object)renderer);
            this.modelRendererList.add((Object)renderer);
        }
        this.animationStorage.initialize(null);
        this.rendererDirty = true;
    }

    public boolean isModelRendererEmpty() {
        return this.modelRendererList.isEmpty();
    }

    public void preAnimationSetup(AnimatableEntity animatable, double seekTime) {
    }

    private void preProcess(ExpressionEvaluator<AnimationContext<?>> evaluator) {
        if (this.rendererDirty && this.initializationValues != null) {
            for (IValue value : this.initializationValues) {
                value.evalAsDouble(evaluator);
            }
            this.initializationValues = null;
        }
        if (this.preAnimationValues != null) {
            for (IValue value : this.preAnimationValues) {
                value.evalAsDouble(evaluator);
            }
        }
    }

    private void postProcess(ExpressionEvaluator<AnimationContext<?>> evaluator) {
        while (!this.pendingValues.isEmpty()) {
            Object result;
            Pair<IValue, Consumer<String>> pair = this.pendingValues.poll();
            try {
                Object ret = ((IValue)pair.getFirst()).evalUnsafe(evaluator);
                result = ret == null ? "null" : (ret instanceof String ? "'" + String.valueOf(ret) + "'" : ret.toString());
            }
            catch (Exception e) {
                result = "Error: " + e.getMessage();
            }
            if (pair.getSecond() == null) continue;
            ((Consumer)pair.getSecond()).accept(result);
        }
    }

    public void execute(IValue value, @Nullable Consumer<String> resultConsumer) {
        this.pendingValues.add((Pair<IValue, Consumer<String>>)Pair.of((Object)value, resultConsumer));
    }

    public IForeignVariableStorage getPublicVariableStorage() {
        return this.animationStorage;
    }
}

