/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class TankBackpackContainer
extends MaidMainContainer {
    public static final MenuType<TankBackpackContainer> TYPE = IMenuTypeExtension.create((windowId, inv, data) -> new TankBackpackContainer(windowId, inv, data.readInt()));
    private static final ResourceLocation INPUT_SLOT = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"slot/tank_input_slot");
    private static final ResourceLocation OUTPUT_SLOT = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"slot/tank_output_slot");
    private final ContainerData data;

    public TankBackpackContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        TankBackpackData tankData = this.getMaid().getBackpackData() instanceof TankBackpackData ? (TankBackpackData)this.getMaid().getBackpackData() : new TankBackpackData(this.getMaid());
        this.data = tankData.getDataAccess();
        this.addSlot(new TankInputSlot((Container)tankData, 0, 161, 101));
        this.addSlot(new TankOutputSlot((Container)tankData, 1, 161, 140));
        this.addDataSlots(this.data);
    }

    @Override
    protected void addBackpackInv(Inventory inventory) {
        int i;
        ItemStackHandler itemHandler = this.maid.getMaidInv();
        for (i = 0; i < 6; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 6 + i, 143 + 18 * i, 57));
        }
        for (i = 0; i < 6; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 12 + i, 143 + 18 * i, 75));
        }
    }

    public int getFluidCount() {
        return this.data.get(0);
    }

    public static class TankInputSlot
    extends Slot {
        public TankInputSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean mayPlace(ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
        }

        @OnlyIn(value=Dist.CLIENT)
        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)INPUT_SLOT);
        }
    }

    public static class TankOutputSlot
    extends Slot {
        public TankOutputSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean mayPlace(ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
        }

        @OnlyIn(value=Dist.CLIENT)
        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)OUTPUT_SLOT);
        }
    }
}

