/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.handler;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BaubleItemHandler
extends ItemStackHandler {
    private IMaidBauble[] baubles;

    public BaubleItemHandler() {
        this(1);
    }

    public BaubleItemHandler(int size) {
        super(size);
        this.baubles = new IMaidBauble[size];
    }

    public BaubleItemHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
        this.baubles = new IMaidBauble[stacks.size()];
        IntStream.range(0, this.getSlots()).forEach(this::onContentsChanged);
    }

    public void setSize(int size) {
        if (size == this.stacks.size()) {
            Arrays.fill(this.baubles, null);
        } else {
            this.baubles = new IMaidBauble[this.stacks.size()];
        }
        super.setSize(size);
    }

    private void setBaubleInSlot(int slot, @Nullable IMaidBauble bauble) {
        this.validateSlotIndex(slot);
        this.baubles[slot] = bauble;
    }

    @Nullable
    public IMaidBauble getBaubleInSlot(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.isEmpty()) {
            return null;
        }
        return this.baubles[slot];
    }

    protected void onContentsChanged(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.isEmpty()) {
            this.setBaubleInSlot(slot, null);
        } else {
            this.setBaubleInSlot(slot, BaubleManager.getBauble(stack));
        }
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return BaubleManager.getBauble(stack) != null;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isItemValid(slot, stack)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    protected void onLoad() {
        IntStream.range(0, this.getSlots()).forEach(this::onContentsChanged);
    }

    public boolean fireEvent(BiFunction<IMaidBauble, ItemStack, Boolean> function) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            IMaidBauble bauble = this.getBaubleInSlot(i);
            if (stack.isEmpty() || bauble == null || !function.apply(bauble, stack).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

