/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemMaidTooltip;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapDecoder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractStoreMaidItem
extends Item {
    static final String CUSTOM_NAME = "CustomName";
    private static final String MAID_OWNER = "Owner";

    public AbstractStoreMaidItem(Item.Properties properties) {
        super(properties);
    }

    public static void storeMaidData(ItemStack stack, EntityMaid maid) {
        CustomData compoundData = (CustomData)stack.get(InitDataComponent.MAID_INFO);
        if (compoundData == null) {
            CompoundTag tag = new CompoundTag();
            maid.saveWithoutId(tag);
            stack.set(InitDataComponent.MAID_INFO, (Object)CustomData.of((CompoundTag)tag));
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.isCurrentlyGlowing()) {
            entity.setGlowingTag(true);
        }
        if (!entity.isInvulnerable()) {
            entity.setInvulnerable(true);
        }
        Vec3 position = entity.position();
        int minY = entity.level.getMinBuildHeight();
        if (position.y < (double)minY) {
            entity.setNoGravity(true);
            entity.setDeltaMovement(Vec3.ZERO);
            entity.setPos(position.x, (double)minY, position.z);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        CustomData maidInfo = (CustomData)stack.get(InitDataComponent.MAID_INFO);
        if (maidInfo == null) {
            return Optional.empty();
        }
        Optional modelId = maidInfo.read((MapDecoder)Codec.STRING.fieldOf("model_id")).result();
        if (modelId.isEmpty()) {
            return Optional.empty();
        }
        String customName = maidInfo.read((MapDecoder)Codec.STRING.fieldOf(CUSTOM_NAME)).result().orElse("");
        YsmMaidInfo ysmMaidInfo = YsmCompat.getYsmMaidInfo(maidInfo.copyTag());
        return Optional.of(new ItemMaidTooltip((String)modelId.get(), customName, ysmMaidInfo));
    }

    public InteractionResult spawnFromStore(UseOnContext context, Player player, Level worldIn, EntityMaid maid, Runnable runnable) {
        ItemStack stack = context.getItemInHand();
        CustomData compoundData = (CustomData)stack.get(InitDataComponent.MAID_INFO);
        if (compoundData != null) {
            CompoundTag maidCompound = compoundData.copyTag();
            UUID ownerUid = maidCompound.getUUID(MAID_OWNER);
            if (!player.getUUID().equals(ownerUid)) {
                return InteractionResult.FAIL;
            }
            maid.load(maidCompound);
            maid.moveTo(context.getClickedPos().above(), 0.0f, 0.0f);
            if (worldIn instanceof ServerLevel) {
                worldIn.addFreshEntity((Entity)maid);
            }
            maid.spawnExplosionParticle();
            maid.playSound(SoundEvents.PLAYER_SPLASH, 1.0f, worldIn.random.nextFloat() * 0.1f + 0.9f);
            runnable.run();
            return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }
        return super.useOn(context);
    }
}

