/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.item.AbstractStoreMaidItem;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class ItemFilm
extends AbstractStoreMaidItem {
    private static final String ID_TAG = "id";

    public ItemFilm() {
        super(new Item.Properties().stacksTo(1));
    }

    public static ItemStack maidToFilm(EntityMaid maid) {
        ItemStack film = ((Item)InitItems.FILM.get()).getDefaultInstance();
        CompoundTag maidTag = new CompoundTag();
        maid.setHomeModeEnable(false);
        maid.saveWithoutId(maidTag);
        ItemFilm.removeMaidSomeData(maidTag);
        maidTag.putString(ID_TAG, Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey(InitEntities.MAID.get())).toString());
        film.set(InitDataComponent.MAID_INFO, (Object)CustomData.of((CompoundTag)maidTag));
        return film;
    }

    public static void filmToMaid(ItemStack film, Level worldIn, BlockPos pos, Player player) {
        CustomData compoundData = (CustomData)film.get(InitDataComponent.MAID_INFO);
        if (compoundData == null) {
            return;
        }
        CompoundTag data = compoundData.copyTag();
        ResourceLocation entityId = ResourceLocation.tryParse((String)data.getString(ID_TAG));
        ResourceLocation maidId = BuiltInRegistries.ENTITY_TYPE.getKey(InitEntities.MAID.get());
        if (entityId != null && entityId.equals((Object)maidId)) {
            EntityMaid maid = new EntityMaid(worldIn);
            maid.readAdditionalSaveData(data);
            maid.setPos(pos.getX(), pos.getY(), pos.getZ());
            if (!worldIn.isClientSide) {
                worldIn.addFreshEntity((Entity)maid);
                NetworkHandler.sendToNearby((Entity)maid, new SpawnParticlePackage(maid.getId(), SpawnParticlePackage.Type.EXPLOSION));
                worldIn.playSound(null, pos, (SoundEvent)InitSounds.ALTAR_CRAFT.get(), SoundSource.VOICE, 1.0f, 1.0f);
            }
            film.shrink(1);
            return;
        }
        if (!worldIn.isClientSide) {
            player.sendSystemMessage((Component)Component.translatable((String)"tooltips.touhou_little_maid.film.no_data.desc"));
        }
    }

    private static void removeMaidSomeData(CompoundTag nbt) {
        nbt.remove("MaidBackpackType");
        nbt.remove("MaidInventory");
        nbt.remove("MaidBaubleInventory");
        nbt.remove("MaidExperience");
        nbt.remove("ArmorItems");
        nbt.remove("HandItems");
        nbt.remove("Leash");
        nbt.remove("Health");
        nbt.remove("HurtTime");
        nbt.remove("DeathTime");
        nbt.remove("HurtByTimestamp");
        nbt.remove("Pos");
        nbt.remove("Motion");
        nbt.remove("FallDistance");
        nbt.remove("Fire");
        nbt.remove("Air");
        nbt.remove("TicksFrozen");
        nbt.remove("HasVisualFire");
        nbt.remove("Passengers");
        nbt.remove("ActiveEffects");
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.get(InitDataComponent.MAID_INFO) == null) {
            tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.film.no_data.desc").withStyle(ChatFormatting.DARK_RED));
        }
    }
}

